/*
 * Copyright 2011-2022 GatlingCorp (https://gatling.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gatling.plugin.exceptions;

public final class UnsupportedJavaVersionException extends EnterprisePluginException {
  public final String clazz;
  public final int version;
  public final int supportedVersion;

  public UnsupportedJavaVersionException(String clazz, int version, int max) {
    super(
        String.format(
            "Version of java %d (found for class '%s') is not supported. Maximum supported java version is %d.",
            version, clazz, max));
    this.clazz = clazz;
    this.version = version;
    this.supportedVersion = max;
  }
}
