/*
 * Copyright 2011-2023 GatlingCorp (https://gatling.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gatling.plugin.model;

import com.fasterxml.jackson.annotation.JsonValue;

public enum RunStatus {
  Building(0, true, false),
  Deploying(1, true, false),
  Deployed(2, true, false),
  Injecting(3, true, false),
  Successful(4, false, true),
  AssertionsSuccessful(5, false, true),
  AutomaticallyStopped(6, false, false),
  ManuallyStopped(7, false, false),
  AssertionsFailed(8, false, false),
  Timeout(9, false, false),
  BuildFailed(10, false, false),
  Broken(11, false, false),
  DeploymentFailed(12, false, false),
  InsufficientCredit(13, false, false),
  // 14 is unused, used to be Collected
  StopRequested(15, true, false);

  @JsonValue public final int value;
  public final boolean running;
  public final boolean successful;

  RunStatus(int value, boolean running, boolean successful) {
    this.value = value;
    this.running = running;
    this.successful = successful;
  }
}
