/*
 * Copyright 2011-2023 GatlingCorp (https://gatling.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gatling.plugin;

import io.gatling.plugin.model.*;

public final class Show {

  static String simulation(Simulation simulation) {
    return String.format("Simulation '%s', id='%s'", simulation.name, simulation.id);
  }

  static String team(Team team) {
    return String.format("Team '%s', id='%s'", team.name, team.id);
  }

  static String location(Location location) {
    if (location instanceof PublicLocation) {
      return "Location " + ((PublicLocation) location).name;
    } else if (location instanceof PrivateLocation) {
      final PrivateLocation prl = (PrivateLocation) location;
      final String description = prl.description != null ? " (" + prl.description + ")" : "";
      return "Private location " + prl.id + description;
    } else {
      throw new IllegalArgumentException(
          "Unsupported location type " + location.getClass().getSimpleName());
    }
  }

  static String packageIndex(PkgIndex pkg) {
    return String.format("Package '%s', id='%s'", pkg.name, pkg.id);
  }
}
