/*
 * Copyright 2011-2023 GatlingCorp (https://gatling.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gatling.plugin.model;

import static io.gatling.plugin.util.ObjectsUtil.nonNullParam;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class RunAssertion {
  public final String message;
  public final boolean result;
  public final Double actualValue;

  @JsonCreator
  public RunAssertion(
      @JsonProperty(value = "message", required = true) String message,
      @JsonProperty(value = "result", required = true) boolean result,
      @JsonProperty(value = "actualValue") Double actualValue) {
    nonNullParam(message, "message");
    this.message = message;
    this.result = result;
    this.actualValue = actualValue;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RunAssertion that = (RunAssertion) o;
    return Objects.equals(message, that.message)
        && result == that.result
        && Objects.equals(actualValue, that.actualValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(message, result, actualValue);
  }

  @Override
  public String toString() {
    return String.format(
        "RunAssertion{message='%s',result='%s',actualValue='%s'}", message, result, actualValue);
  }
}
