/*
 * Copyright 2011-2023 GatlingCorp (https://gatling.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gatling.plugin.model;

import static io.gatling.plugin.util.ObjectsUtil.nonNullParam;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class RunInformation {

  public final UUID runId;
  public final String scenario;
  public final long injectStart;
  public final RunStatus status;
  public final List<RunAssertion> assertions;

  @JsonCreator
  public RunInformation(
      @JsonProperty(value = "runId", required = true) UUID runId,
      @JsonProperty(value = "scenario", required = true) String scenario,
      @JsonProperty(value = "injectStart", required = true) long injectStart,
      @JsonProperty(value = "status", required = true) RunStatus status,
      @JsonProperty(value = "assertions", required = true) List<RunAssertion> assertions) {
    nonNullParam(runId, "runId");
    nonNullParam(runId, "scenario");
    nonNullParam(status, "status");
    nonNullParam(assertions, "assertions");
    this.runId = runId;
    this.scenario = scenario;
    this.injectStart = injectStart;
    this.status = status;
    this.assertions = assertions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RunInformation that = (RunInformation) o;
    return Objects.equals(runId, that.runId)
        && Objects.equals(scenario, that.scenario)
        && injectStart == that.injectStart
        && Objects.equals(status, that.status)
        && Objects.equals(assertions, that.assertions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(runId, scenario, injectStart, status, assertions);
  }

  @Override
  public String toString() {
    return String.format(
        "RunInformation{runId='%s',scenario='%s',injectStart='%s',status='%s',assertions='%s'}",
        runId, scenario, injectStart, status, assertions);
  }
}
