/*
 * Copyright 2011-2023 GatlingCorp (https://gatling.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gatling.plugin.model;

import static io.gatling.plugin.util.ObjectsUtil.nonNullParam;

import java.util.List;
import java.util.Objects;

public final class SimulationEndResult {

  public final RunStatus status;
  public final List<RunAssertion> assertions;

  public SimulationEndResult(RunStatus status, List<RunAssertion> assertions) {
    nonNullParam(status, "status");
    nonNullParam(assertions, "assertions");
    this.status = status;
    this.assertions = assertions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SimulationEndResult that = (SimulationEndResult) o;
    return Objects.equals(status, that.status) && Objects.equals(assertions, that.assertions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, assertions);
  }

  @Override
  public String toString() {
    return String.format("SimulationEndResult{status=%s, assertions=%s}", status, assertions);
  }
}
