/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http;

import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.client.http.ApiPath;
import io.gatling.plugin.client.http.InfoApiRequests;
import io.gatling.plugin.client.http.LocationsApiRequests;
import io.gatling.plugin.client.http.PackagesApiRequests;
import io.gatling.plugin.client.http.PrivateApiRequests;
import io.gatling.plugin.client.http.PrivatePackagesApiRequests;
import io.gatling.plugin.client.http.RunsApiRequests;
import io.gatling.plugin.client.http.SimulationsApiRequests;
import io.gatling.plugin.client.http.TeamsApiRequests;
import io.gatling.plugin.exceptions.ApiCallIOException;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.InvalidBaseUrlException;
import io.gatling.plugin.exceptions.PackageNotFoundException;
import io.gatling.plugin.model.HostByLocation;
import io.gatling.plugin.model.Locations;
import io.gatling.plugin.model.MeaningfulTimeWindow;
import io.gatling.plugin.model.PackageCreationPayload;
import io.gatling.plugin.model.PackageStorageType;
import io.gatling.plugin.model.Pkg;
import io.gatling.plugin.model.PkgIndex;
import io.gatling.plugin.model.RequestsSummary;
import io.gatling.plugin.model.RunInformation;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Series;
import io.gatling.plugin.model.ServerInformation;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.SimulationClassName;
import io.gatling.plugin.model.SimulationCreationPayload;
import io.gatling.plugin.model.StartOptions;
import io.gatling.plugin.model.Team;
import io.gatling.plugin.util.checksum.PkgChecksum;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public final class HttpEnterpriseClient
implements EnterpriseClient {
    private static final Map<String, String> DEFAULT_SYSTEM_PROPERTIES = Collections.emptyMap();
    private static final Map<String, String> DEFAULT_ENVIRONMENT_VARIABLES = Collections.emptyMap();
    private static final MeaningfulTimeWindow DEFAULT_TIME_WINDOW = new MeaningfulTimeWindow(0, 0);
    private final URL baseUrl;
    private final InfoApiRequests infoApiRequests;
    private final PackagesApiRequests packagesApiRequests;
    private final PrivatePackagesApiRequests privatePackagesApiRequests;
    private final LocationsApiRequests locationsApiRequests;
    private final SimulationsApiRequests simulationsApiRequests;
    private final TeamsApiRequests teamsApiRequests;
    private final RunsApiRequests runsApiRequests;

    public HttpEnterpriseClient(URL uRL2, String string, String string2, String string3, URL uRL3) throws EnterprisePluginException {
        if (!"http".equals(uRL2.getProtocol()) && !"https".equals(uRL2.getProtocol())) {
            throw new InvalidBaseUrlException(uRL2);
        }
        this.baseUrl = uRL2;
        URL uRL4 = ApiPath.of("api", "public").buildUrl(uRL2);
        this.infoApiRequests = new InfoApiRequests(uRL4, string);
        this.packagesApiRequests = new PackagesApiRequests(uRL4, string);
        this.privatePackagesApiRequests = Optional.ofNullable(uRL3).map(uRL -> new PrivatePackagesApiRequests((URL)uRL, string)).orElse(null);
        this.locationsApiRequests = new LocationsApiRequests(uRL4, string);
        this.simulationsApiRequests = new SimulationsApiRequests(uRL4, string);
        this.teamsApiRequests = new TeamsApiRequests(uRL4, string);
        this.runsApiRequests = new RunsApiRequests(uRL4, string);
        new PrivateApiRequests(uRL4, string).checkVersionSupport(string2, string3);
    }

    @Override
    public URL getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public ServerInformation getServerInformation() throws EnterprisePluginException {
        return this.infoApiRequests.getServerInformation();
    }

    @Override
    public List<Simulation> getSimulations() throws EnterprisePluginException {
        return this.simulationsApiRequests.listSimulations().data;
    }

    @Override
    public Simulation getSimulation(UUID uUID) throws EnterprisePluginException {
        return this.simulationsApiRequests.getSimulation(uUID);
    }

    @Override
    public List<Team> getTeams() throws EnterprisePluginException {
        return this.teamsApiRequests.listTeams().data;
    }

    @Override
    public Locations getLocations() throws EnterprisePluginException {
        return new Locations(this.locationsApiRequests.listPublicLocations().data, this.locationsApiRequests.listPrivateLocations().data);
    }

    @Override
    public List<PkgIndex> getPackages() throws EnterprisePluginException {
        return this.packagesApiRequests.listPackages().data;
    }

    @Override
    public Pkg getPackage(UUID uUID) throws EnterprisePluginException {
        return this.packagesApiRequests.readPackage(uUID);
    }

    @Override
    public long uploadPackage(UUID uUID, File file) throws EnterprisePluginException {
        return this.privatePackagesApiRequests != null ? this.privatePackagesApiRequests.uploadPackage(uUID, file) : this.packagesApiRequests.uploadPackage(uUID, file);
    }

    @Override
    public RunSummary startSimulation(UUID uUID, Map<String, String> map, Map<String, String> map2) throws EnterprisePluginException {
        StartOptions startOptions = new StartOptions(map, map2);
        return this.simulationsApiRequests.startSimulation(uUID, startOptions);
    }

    private boolean checksumComparison(UUID uUID, File file) throws EnterprisePluginException {
        try {
            Pkg pkg = this.getPackage(uUID);
            return pkg.file != null && PkgChecksum.computeChecksum(file).equals(pkg.file.checksum);
        }
        catch (PackageNotFoundException packageNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            throw new ApiCallIOException(iOException);
        }
    }

    @Override
    public long uploadPackageWithChecksum(UUID uUID, File file) throws EnterprisePluginException {
        return this.checksumComparison(uUID, file) ? -1L : this.uploadPackage(uUID, file);
    }

    @Override
    public SimulationClassName updateSimulationClassName(UUID uUID, String string) throws EnterprisePluginException {
        return this.simulationsApiRequests.updateSimulationClassName(uUID, string);
    }

    @Override
    public Simulation createSimulation(String string, UUID uUID, String string2, UUID uUID2, Map<String, HostByLocation> map) throws EnterprisePluginException {
        return this.simulationsApiRequests.createSimulation(new SimulationCreationPayload(string, uUID, string2, uUID2, DEFAULT_SYSTEM_PROPERTIES, DEFAULT_ENVIRONMENT_VARIABLES, false, DEFAULT_TIME_WINDOW, map, false, false));
    }

    @Override
    public Pkg createPackage(String string, UUID uUID) throws EnterprisePluginException {
        PackageStorageType packageStorageType = this.privatePackagesApiRequests != null ? PackageStorageType.PRIVATE : PackageStorageType.PUBLIC;
        return this.packagesApiRequests.createPackage(new PackageCreationPayload(string, uUID, packageStorageType));
    }

    @Override
    public RunInformation getRunInformation(UUID uUID) throws EnterprisePluginException {
        return this.runsApiRequests.getRunInformation(uUID);
    }

    @Override
    public List<Series> getConcurrentUserMetric(UUID uUID, String string) throws EnterprisePluginException {
        return this.runsApiRequests.getConcurrentUserMetric(uUID, string);
    }

    @Override
    public RequestsSummary getRequestsSummary(UUID uUID) throws EnterprisePluginException {
        return this.runsApiRequests.getRequestsSummary(uUID);
    }

    @Override
    public boolean abortRun(UUID uUID) throws EnterprisePluginException {
        return this.simulationsApiRequests.abortRun(uUID);
    }
}

