/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin;

import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.MetricsSummary;
import io.gatling.plugin.model.RequestsSummary;
import io.gatling.plugin.model.RunInformation;
import io.gatling.plugin.model.RunStatus;
import io.gatling.plugin.model.Series;
import io.gatling.plugin.model.SimulationEndResult;
import io.gatling.plugin.util.DurationFormatter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;

final class RunStatusTask
extends TimerTask {
    private final EnterpriseClient enterpriseClient;
    private final PluginLogger logger;
    private final UUID runId;
    private final CountDownLatch latch;
    private int errorCount = 0;
    private RunStatus oldStatus;
    public SimulationEndResult result;
    public Exception exception;

    RunStatusTask(EnterpriseClient enterpriseClient, PluginLogger pluginLogger, UUID uUID, CountDownLatch countDownLatch) {
        this.enterpriseClient = enterpriseClient;
        this.logger = pluginLogger;
        this.runId = uUID;
        this.latch = countDownLatch;
    }

    @Override
    public void run() {
        try {
            RunInformation runInformation = this.enterpriseClient.getRunInformation(this.runId);
            if (runInformation.status != this.oldStatus) {
                this.logger.info(String.format("Run status is now %s [%s]", new Object[]{runInformation.status, runInformation.status.value}));
            }
            this.oldStatus = runInformation.status;
            if (runInformation.injectStart > 0L) {
                this.logMetricsSummary(this.getMetricsSummary(runInformation));
            }
            this.errorCount = 0;
            if (!runInformation.status.running) {
                this.setResult(new SimulationEndResult(runInformation.status, runInformation.assertions));
            }
        }
        catch (Exception exception) {
            ++this.errorCount;
            if (this.errorCount < 5) {
                String string = exception.getCause() != null ? ": " + exception.getCause().getMessage() : "";
                this.logger.info(String.format("Failed to retrieve current run information (attempt %s/5): %s%s", this.errorCount, exception.getMessage(), string));
            }
            this.setException(exception);
        }
    }

    private MetricsSummary getMetricsSummary(RunInformation runInformation) throws EnterprisePluginException {
        List<Series> list = this.enterpriseClient.getConcurrentUserMetric(runInformation.runId, runInformation.scenario);
        RequestsSummary requestsSummary = this.enterpriseClient.getRequestsSummary(runInformation.runId);
        Instant instant = Instant.now();
        String string = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneOffset.UTC).format(instant);
        String string2 = DurationFormatter.formatDuration(runInformation.injectStart, instant.toEpochMilli());
        double d = list.stream().map(series -> series.values.isEmpty() ? 0.0 : series.values.get(series.values.size() - 1)).reduce(0.0, Double::sum);
        double d2 = requestsSummary.out.counts.total;
        double d3 = requestsSummary.out.rps.total;
        double d4 = requestsSummary.in.counts.koPercent;
        List<MetricsSummary.ChildMetric> list2 = this.recursivelyGetChildren(requestsSummary.children);
        return new MetricsSummary(string, string2, d, d2, d3, d4, list2);
    }

    private List<MetricsSummary.ChildMetric> recursivelyGetChildren(List<RequestsSummary.Child> list) {
        return list.stream().map(child -> child.children == null ? new MetricsSummary.ChildMetric(child.name, child.out.counts.total, child.in.counts.koPercent, child.out.rps.total) : new MetricsSummary.ChildMetric(child.name, this.recursivelyGetChildren(child.children))).collect(Collectors.toList());
    }

    private void logMetricsSummary(MetricsSummary metricsSummary) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Time: ").append(metricsSummary.date).append(", ").append(metricsSummary.duration).append(" elapsed\n");
        stringBuilder.append("Number of concurrent users: ").append(metricsSummary.nbUsers).append("\n");
        stringBuilder.append("Number of requests: ").append(metricsSummary.nbRequest).append("\n");
        stringBuilder.append("Number of requests per seconds: ").append(metricsSummary.requestsSeconds).append("\n");
        this.formatListMetrics(stringBuilder, metricsSummary.listMetric, 0);
        this.logger.info(stringBuilder.toString());
    }

    private void formatListMetrics(StringBuilder stringBuilder, List<MetricsSummary.ChildMetric> list, int n) {
        String string = this.pad(2 * n);
        for (MetricsSummary.ChildMetric childMetric : list) {
            if (childMetric.children == null) {
                stringBuilder.append(string).append("> Request ").append(childMetric.name).append("\n");
                stringBuilder.append(string).append("   Counts: ").append(childMetric.nbRequest).append("\n");
                stringBuilder.append(string).append("   Requests per seconds: ").append(childMetric.requestsSeconds).append("\n");
                stringBuilder.append(string).append("   Failure ratio: ").append(childMetric.failureRatio).append("\n");
                continue;
            }
            stringBuilder.append(string).append("> Group ").append(childMetric.name).append("\n");
            this.formatListMetrics(stringBuilder, childMetric.children, n + 1);
        }
    }

    private String pad(int n) {
        if (n <= 0) {
            return "";
        }
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    private void setResult(SimulationEndResult simulationEndResult) {
        this.result = simulationEndResult;
        this.latch.countDown();
        this.cancel();
    }

    private void setException(Exception exception) {
        this.exception = exception;
        this.latch.countDown();
        this.cancel();
    }
}

