/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.pkg;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

enum ManifestEntry {
    ManifestVersion("Manifest-Version"),
    ImplementationTitle("Implementation-Title"),
    ImplementationVersion("Implementation-Version"),
    ImplementationVendor("Implementation-Vendor"),
    SpecificationVendor("Specification-Vendor"),
    GatlingVersion("Gatling-Version"),
    GatlingPackager("Gatling-Packager"),
    GatlingPackagerVersion("Gatling-Packager-Version"),
    GatlingSimulations("Gatling-Simulations"),
    GatlingExtraProtocols("Gatling-Extra-Protocols"),
    JavaVersion("Java-Version");

    private static final String MANIFEST_ENTRY_SEPARATOR = ": ";
    private final String name;

    private ManifestEntry(String string2) {
        this.name = string2;
    }

    void write(Writer writer, String string) throws IOException {
        writer.write(this.name + MANIFEST_ENTRY_SEPARATOR + string + "\n");
    }

    void write(Writer writer, List<String> list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            writer.write(this.name + "-" + i + MANIFEST_ENTRY_SEPARATOR + list.get(i) + "\n");
        }
    }

    String readManifestEntry(String string) {
        return this.readManifestEntry(string, stream -> (String)stream.findFirst().orElseThrow());
    }

    List<String> readManifestMultiValuedEntry(String string) {
        return this.readManifestEntry(string, stream -> stream.collect(Collectors.toList()));
    }

    private <T> T readManifestEntry(String string2, Function<Stream<String>, T> function) {
        Stream<String> stream = string2.lines().filter(string -> string.startsWith(this.name)).map(string -> {
            int n = string.indexOf(MANIFEST_ENTRY_SEPARATOR) + MANIFEST_ENTRY_SEPARATOR.length();
            return string.substring(n);
        });
        return function.apply(stream);
    }
}

