/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client;

import com.fasterxml.jackson.databind.JsonNode;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.client.http.api.ApiPath;
import io.gatling.plugin.client.http.api.ArtifactsApi;
import io.gatling.plugin.client.http.api.InfoApi;
import io.gatling.plugin.client.http.api.PkgsApi;
import io.gatling.plugin.client.http.api.PrivateApi;
import io.gatling.plugin.client.http.api.PrivatePackagesApi;
import io.gatling.plugin.client.http.api.RunsApi;
import io.gatling.plugin.client.http.api.SimulationsApi;
import io.gatling.plugin.client.http.requests.ArtifactCreationRequest;
import io.gatling.plugin.client.http.requests.BuildPluginRequest;
import io.gatling.plugin.client.http.requests.CoordinatesRequest;
import io.gatling.plugin.client.http.requests.PkgDeployRequest;
import io.gatling.plugin.client.http.requests.PkgStorageTypeRequest;
import io.gatling.plugin.client.http.requests.SimulationDeployRequest;
import io.gatling.plugin.client.http.requests.StartOptionsRequest;
import io.gatling.plugin.client.http.responses.ArtifactIndexResponse;
import io.gatling.plugin.client.http.responses.ArtifactResponse;
import io.gatling.plugin.client.http.responses.DeployedPkgInfoResponse;
import io.gatling.plugin.client.http.responses.DeployedSimulationInfoResponse;
import io.gatling.plugin.client.http.responses.RequestsSummaryResponse;
import io.gatling.plugin.client.http.responses.RunInformationResponse;
import io.gatling.plugin.client.http.responses.RunSummaryResponse;
import io.gatling.plugin.client.http.responses.SeriesResponse;
import io.gatling.plugin.client.http.responses.SimulationResponse;
import io.gatling.plugin.client.http.responses.VersionSupportedResponse;
import io.gatling.plugin.exceptions.ApiCallIOException;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.InvalidBaseUrlException;
import io.gatling.plugin.exceptions.PackageNotFoundException;
import io.gatling.plugin.model.BuildPlugin;
import io.gatling.plugin.model.DeployedPkgInfo;
import io.gatling.plugin.model.DeployedSimulationInfo;
import io.gatling.plugin.model.Pkg;
import io.gatling.plugin.model.PkgFile;
import io.gatling.plugin.model.PkgIndex;
import io.gatling.plugin.model.RequestsSummary;
import io.gatling.plugin.model.RunAssertion;
import io.gatling.plugin.model.RunComment;
import io.gatling.plugin.model.RunInformation;
import io.gatling.plugin.model.RunStatus;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Series;
import io.gatling.plugin.model.ServerInformation;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.VersionSupported;
import io.gatling.plugin.model.Versions;
import io.gatling.plugin.util.checksum.PkgChecksum;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public final class HttpEnterpriseClient
extends EnterpriseClient {
    private final URL baseUrl;
    private final InfoApi infoApiRequests;
    private final ArtifactsApi artifactsApiRequests;
    private final PrivatePackagesApi privatePackagesApiRequests;
    private final SimulationsApi simulationsApi;
    private final RunsApi runsApi;
    private final PkgsApi pkgsApi;

    public HttpEnterpriseClient(URL uRL2, String string, URL uRL3, BuildPlugin buildPlugin) throws EnterprisePluginException {
        super(buildPlugin);
        if (!"http".equals(uRL2.getProtocol()) && !"https".equals(uRL2.getProtocol())) {
            throw new InvalidBaseUrlException(uRL2);
        }
        this.baseUrl = uRL2;
        URL uRL4 = ApiPath.of("api", "public").buildUrl(uRL2);
        this.infoApiRequests = new InfoApi(uRL4, string);
        this.artifactsApiRequests = new ArtifactsApi(uRL4, string);
        this.privatePackagesApiRequests = Optional.ofNullable(uRL3).map(uRL -> new PrivatePackagesApi((URL)uRL, string)).orElse(null);
        this.simulationsApi = new SimulationsApi(uRL4, string);
        this.runsApi = new RunsApi(uRL4, string);
        this.pkgsApi = new PkgsApi(uRL4, string);
        new PrivateApi(uRL4, string).checkVersionSupport(buildPlugin.buildTool.value, buildPlugin.pluginVersion);
    }

    @Override
    public URL getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public ServerInformation getServerInformation() throws EnterprisePluginException {
        VersionSupportedResponse versionSupportedResponse = this.infoApiRequests.getServerInformation().versions.java;
        return new ServerInformation(new Versions(new VersionSupported(versionSupportedResponse.min, versionSupportedResponse.max)));
    }

    @Override
    public Simulation getSimulation(UUID uUID) throws EnterprisePluginException {
        SimulationResponse simulationResponse = this.simulationsApi.getSimulation(uUID);
        return new Simulation(simulationResponse.id, simulationResponse.name, simulationResponse.teamId, simulationResponse.className, simulationResponse.pkgId);
    }

    @Override
    public List<PkgIndex> getPackages() throws EnterprisePluginException {
        List<ArtifactIndexResponse> list = this.artifactsApiRequests.listPackages().data;
        return list.stream().map(artifactIndexResponse -> new PkgIndex(artifactIndexResponse.id, artifactIndexResponse.teamId, artifactIndexResponse.name, artifactIndexResponse.fileName)).collect(Collectors.toList());
    }

    @Override
    public Pkg getPackage(UUID uUID) throws EnterprisePluginException {
        ArtifactResponse artifactResponse = this.artifactsApiRequests.readPackage(uUID);
        PkgFile pkgFile = Optional.ofNullable(artifactResponse.file).map(pkgFileResponse -> new PkgFile(pkgFileResponse.filename, pkgFileResponse.version, pkgFileResponse.checksum)).orElse(null);
        return new Pkg(artifactResponse.id, artifactResponse.teamId, artifactResponse.name, pkgFile);
    }

    @Override
    public long uploadPackage(UUID uUID, File file) throws EnterprisePluginException {
        return this.privatePackagesApiRequests != null ? this.privatePackagesApiRequests.uploadPackage(uUID, file) : this.artifactsApiRequests.uploadPackage(uUID, file);
    }

    private boolean checksumComparison(UUID uUID, File file) throws EnterprisePluginException {
        try {
            Pkg pkg = this.getPackage(uUID);
            return pkg.file != null && PkgChecksum.computeChecksum(file).equals(pkg.file.checksum);
        }
        catch (PackageNotFoundException packageNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            throw new ApiCallIOException(iOException);
        }
    }

    @Override
    public long uploadPackageWithChecksum(UUID uUID, File file) throws EnterprisePluginException {
        return this.checksumComparison(uUID, file) ? -1L : this.uploadPackage(uUID, file);
    }

    @Override
    public Pkg createPackage(String string, UUID uUID) throws EnterprisePluginException {
        PkgStorageTypeRequest pkgStorageTypeRequest = this.privatePackagesApiRequests != null ? PkgStorageTypeRequest.PRIVATE : PkgStorageTypeRequest.PUBLIC;
        ArtifactResponse artifactResponse = this.artifactsApiRequests.createPackage(new ArtifactCreationRequest(string, uUID, pkgStorageTypeRequest));
        PkgFile pkgFile = Optional.ofNullable(artifactResponse.file).map(pkgFileResponse -> new PkgFile(pkgFileResponse.filename, pkgFileResponse.version, pkgFileResponse.checksum)).orElse(null);
        return new Pkg(artifactResponse.id, artifactResponse.teamId, artifactResponse.name, pkgFile);
    }

    @Override
    public RunInformation getRunInformation(UUID uUID) throws EnterprisePluginException {
        RunInformationResponse runInformationResponse = this.runsApi.getRunInformation(uUID);
        List<RunAssertion> list = runInformationResponse.assertions.stream().map(runAssertionResponse -> new RunAssertion(runAssertionResponse.message, runAssertionResponse.result, runAssertionResponse.actualValue)).collect(Collectors.toList());
        return new RunInformation(runInformationResponse.runId, runInformationResponse.scenario, runInformationResponse.injectStart, RunStatus.valueOf(runInformationResponse.status), list);
    }

    @Override
    public List<Series> getConcurrentUserMetric(UUID uUID, String string) throws EnterprisePluginException {
        List<SeriesResponse> list = this.runsApi.getConcurrentUserMetric(uUID, string);
        return list.stream().map(seriesResponse -> new Series(seriesResponse.values)).collect(Collectors.toList());
    }

    private static RequestsSummary.In requestsSummaryInFromResponse(RequestsSummaryResponse.In in) {
        return new RequestsSummary.In(new RequestsSummary.KoPercent(in.counts.koPercent), new RequestsSummary.Total(in.rps.total));
    }

    private static RequestsSummary.Out requestsSummaryOutFromResponse(RequestsSummaryResponse.Out out) {
        return new RequestsSummary.Out(new RequestsSummary.Total(out.counts.total), new RequestsSummary.Total(out.rps.total));
    }

    private static RequestsSummary.Child requestsSummaryChildFromResponse(RequestsSummaryResponse.Child child) {
        return new RequestsSummary.Child(child.name, HttpEnterpriseClient.requestsSummaryInFromResponse(child.in), HttpEnterpriseClient.requestsSummaryOutFromResponse(child.out), child.index, child.children.stream().map(HttpEnterpriseClient::requestsSummaryChildFromResponse).collect(Collectors.toList()));
    }

    @Override
    public RequestsSummary getRequestsSummary(UUID uUID) throws EnterprisePluginException {
        RequestsSummaryResponse requestsSummaryResponse = this.runsApi.getRequestsSummary(uUID);
        RequestsSummary.In in = HttpEnterpriseClient.requestsSummaryInFromResponse(requestsSummaryResponse.in);
        RequestsSummary.Out out = HttpEnterpriseClient.requestsSummaryOutFromResponse(requestsSummaryResponse.out);
        List<RequestsSummary.Child> list = requestsSummaryResponse.children.stream().map(HttpEnterpriseClient::requestsSummaryChildFromResponse).collect(Collectors.toList());
        return new RequestsSummary(in, out, list);
    }

    @Override
    public boolean abortRun(UUID uUID) throws EnterprisePluginException {
        return this.simulationsApi.abortRun(uUID);
    }

    @Override
    public DeployedPkgInfo deployPkg(JsonNode jsonNode, String string, Boolean bl) throws EnterprisePluginException {
        DeployedPkgInfoResponse deployedPkgInfoResponse = this.pkgsApi.deployPackage((PkgDeployRequest)new PkgDeployRequest((BuildPluginRequest)new BuildPluginRequest((String)this.buildPlugin.pluginVersion, (String)this.buildPlugin.buildTool.value, (boolean)this.buildPlugin.interactive.booleanValue(), (boolean)this.buildPlugin.ci.booleanValue()), (CoordinatesRequest)new CoordinatesRequest((String)string), (Boolean)bl, (JsonNode)jsonNode)).data;
        return new DeployedPkgInfo(deployedPkgInfoResponse.id, deployedPkgInfoResponse.name);
    }

    @Override
    public List<DeployedSimulationInfo> deploySimulations(UUID uUID, JsonNode jsonNode) throws EnterprisePluginException {
        List<DeployedSimulationInfoResponse> list = this.pkgsApi.deploySimulations((UUID)uUID, (SimulationDeployRequest)new SimulationDeployRequest((BuildPluginRequest)new BuildPluginRequest((String)this.buildPlugin.pluginVersion, (String)this.buildPlugin.buildTool.value, (boolean)this.buildPlugin.interactive.booleanValue(), (boolean)this.buildPlugin.ci.booleanValue()), (JsonNode)jsonNode)).data;
        return list.stream().map(deployedSimulationInfoResponse -> new DeployedSimulationInfo(deployedSimulationInfoResponse.id, deployedSimulationInfoResponse.name)).collect(Collectors.toList());
    }

    @Override
    public RunSummary startSimulation(UUID uUID, RunComment runComment) throws EnterprisePluginException {
        StartOptionsRequest startOptionsRequest = new StartOptionsRequest(Map.of(), Map.of(), runComment.title, runComment.description);
        RunSummaryResponse runSummaryResponse = this.simulationsApi.startSimulation(uUID, startOptionsRequest);
        return new RunSummary(runSummaryResponse.runId, runSummaryResponse.className, runSummaryResponse.reportsPath);
    }
}

