/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.gatling.plugin.client.http.requests.HostByLocationRequest;
import io.gatling.plugin.client.http.requests.MeaningfulTimeWindowRequest;
import io.gatling.plugin.util.ObjectsUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class SimulationCreationRequest {
    public final String name;
    public final UUID teamId;
    public final String className;
    @JsonProperty(value="build")
    @JsonSerialize(using=PkgIdJsonSerializer.class)
    public final UUID pkgId;
    public final Map<String, String> systemProperties;
    public final Map<String, String> environmentVariables;
    public final boolean ignoreGlobalProperties;
    public final MeaningfulTimeWindowRequest meaningfulTimeWindow;
    public final Map<String, HostByLocationRequest> hostsByPool;
    public final boolean usePoolWeights;
    public final boolean usePoolDedicatedIps;

    public SimulationCreationRequest(String string, UUID uUID, String string2, UUID uUID2, Map<String, String> map, Map<String, String> map2, boolean bl, MeaningfulTimeWindowRequest meaningfulTimeWindowRequest, Map<String, HostByLocationRequest> map3, boolean bl2, boolean bl3) {
        ObjectsUtil.nonNullParam(string, "name");
        ObjectsUtil.nonNullParam(uUID, "teamId");
        ObjectsUtil.nonNullParam(string2, "className");
        ObjectsUtil.nonNullParam(uUID2, "pkgId");
        ObjectsUtil.nonNullParam(map, "systemProperties");
        ObjectsUtil.nonNullParam(map2, "environmentVariables");
        ObjectsUtil.nonNullParam(meaningfulTimeWindowRequest, "meaningfulTimeWindow");
        ObjectsUtil.nonNullParam(map3, "hostsByPool");
        this.name = string;
        this.teamId = uUID;
        this.className = string2;
        this.pkgId = uUID2;
        this.systemProperties = map;
        this.environmentVariables = map2;
        this.ignoreGlobalProperties = bl;
        this.meaningfulTimeWindow = meaningfulTimeWindowRequest;
        this.hostsByPool = map3;
        this.usePoolWeights = bl2;
        this.usePoolDedicatedIps = bl3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SimulationCreationRequest simulationCreationRequest = (SimulationCreationRequest)object;
        return this.ignoreGlobalProperties == simulationCreationRequest.ignoreGlobalProperties && this.usePoolWeights == simulationCreationRequest.usePoolWeights && this.usePoolDedicatedIps == simulationCreationRequest.usePoolDedicatedIps && this.name.equals(simulationCreationRequest.name) && this.teamId.equals(simulationCreationRequest.teamId) && this.className.equals(simulationCreationRequest.className) && this.pkgId.equals(simulationCreationRequest.pkgId) && this.systemProperties.equals(simulationCreationRequest.systemProperties) && this.environmentVariables.equals(simulationCreationRequest.environmentVariables) && this.meaningfulTimeWindow.equals(simulationCreationRequest.meaningfulTimeWindow) && this.hostsByPool.equals(simulationCreationRequest.hostsByPool);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.teamId, this.className, this.pkgId, this.systemProperties, this.environmentVariables, this.ignoreGlobalProperties, this.meaningfulTimeWindow, this.hostsByPool, this.usePoolWeights, this.usePoolDedicatedIps);
    }

    public String toString() {
        return String.format("Simulation{name='%s',teamId='%s',className='%s',pkgId='%s'}", this.name, this.teamId, this.className, this.pkgId);
    }

    private static final class PkgIdJsonSerializer
    extends JsonSerializer<UUID> {
        private PkgIdJsonSerializer() {
        }

        public void serialize(UUID uUID, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("pkgId", uUID.toString());
            jsonGenerator.writeEndObject();
        }
    }
}

