/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import io.gatling.plugin.BatchEnterprisePlugin;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.client.json.JsonUtil;
import io.gatling.plugin.domain.PluginClient;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.InvalidConfigFileException;
import io.gatling.plugin.exceptions.SimulationNameNotDeployedException;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.DeployedPkgInfo;
import io.gatling.plugin.model.DeployedSimulationInfo;
import io.gatling.plugin.model.DeploymentInfo;
import io.gatling.plugin.model.RunComment;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.util.ObjectsUtil;
import java.io.File;
import java.util.List;
import java.util.UUID;

public final class BatchEnterprisePluginClient
extends PluginClient
implements BatchEnterprisePlugin {
    public BatchEnterprisePluginClient(EnterpriseClient enterpriseClient, PluginLogger pluginLogger) {
        super(enterpriseClient, pluginLogger);
    }

    @Override
    public long uploadPackage(UUID uUID, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(uUID, "packageId");
        ObjectsUtil.nonNullParam(file, "file");
        this.validateJavaVersion(file);
        return this.uploadPackageWithChecksum(uUID, file);
    }

    @Override
    public long uploadPackageWithSimulationId(UUID uUID, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(file, "simulationId");
        ObjectsUtil.nonNullParam(file, "file");
        Simulation simulation = this.enterpriseClient.getSimulation(uUID);
        return this.uploadPackage(simulation.pkgId, file);
    }

    @Override
    public DeploymentInfo deployFromDescriptor(File file, File file2, String string, Boolean bl) throws EnterprisePluginException {
        ObjectNode objectNode;
        Object object;
        ObjectsUtil.nonNullParam(file2, "pkg");
        ObjectsUtil.nonNullParam(string, "artifactId");
        ObjectsUtil.nonNullParam(bl, "usePrivateRepository");
        if (file != null && file.exists()) {
            try {
                object = ConfigFactory.parseFile((File)file).resolve();
                objectNode = JsonUtil.JSON_MAPPER.readTree(object.root().render(ConfigRenderOptions.concise()));
            }
            catch (JsonProcessingException | ConfigException throwable) {
                throw new InvalidConfigFileException(file, throwable);
            }
        } else {
            objectNode = JsonUtil.JSON_MAPPER.createObjectNode();
        }
        object = this.deployPkg((JsonNode)objectNode, string, bl);
        this.uploadPackage(object.id, file2);
        List<DeployedSimulationInfo> list = this.deploySimulations(object.id, (JsonNode)objectNode);
        return new DeploymentInfo((DeployedPkgInfo)object, list);
    }

    private DeployedPkgInfo deployPkg(JsonNode jsonNode, String string, Boolean bl) throws EnterprisePluginException {
        DeployedPkgInfo deployedPkgInfo = this.enterpriseClient.deployPkg(jsonNode, string, bl);
        this.logger.info(String.format("Package '%s' (id='%s') deployed", deployedPkgInfo.name, deployedPkgInfo.id));
        return deployedPkgInfo;
    }

    private List<DeployedSimulationInfo> deploySimulations(UUID uUID, JsonNode jsonNode) throws EnterprisePluginException {
        List<DeployedSimulationInfo> list = this.enterpriseClient.deploySimulations(uUID, jsonNode);
        for (DeployedSimulationInfo deployedSimulationInfo : list) {
            this.logger.info(String.format("Simulation '%s' (id='%s') deployed", deployedSimulationInfo.name, deployedSimulationInfo.id));
        }
        return list;
    }

    @Override
    public RunSummary startSimulation(String string, DeploymentInfo deploymentInfo, RunComment runComment) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(string, "simulationName");
        ObjectsUtil.nonNullParam(deploymentInfo, "deploymentInfo");
        DeployedSimulationInfo deployedSimulationInfo2 = deploymentInfo.deployedSimulationInfoList.stream().filter(deployedSimulationInfo -> deployedSimulationInfo.name.equals(string)).findFirst().orElseThrow(() -> new SimulationNameNotDeployedException(string));
        return this.startSimulation(deployedSimulationInfo2, runComment);
    }
}

