/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.graphite.types;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.graphite.types.MetricByStatus;
import io.gatling.graphite.types.Metrics;
import io.gatling.graphite.types.RequestMetricsBuffer;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.IntCountsHistogram;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u0017\ti\u0002*[:u_\u001e\u0014\u0018-\u001c*fcV,7\u000f^'fiJL7m\u001d\"vM\u001a,'O\u0003\u0002\u0004\t\u0005)A/\u001f9fg*\u0011QAB\u0001\tOJ\f\u0007\u000f[5uK*\u0011q\u0001C\u0001\bO\u0006$H.\u001b8h\u0015\u0005I\u0011AA5p\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0015%\u0016\fX/Z:u\u001b\u0016$(/[2t\u0005V4g-\u001a:\t\u0011]\u0001!\u0011!Q\u0001\na\tQbY8oM&<WO]1uS>t\u0007CA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003\u0019\u0019wN\u001c4jO*\u0011QDB\u0001\u0005G>\u0014X-\u0003\u0002 5\t!r)\u0019;mS:<7i\u001c8gS\u001e,(/\u0019;j_:DQ!\t\u0001\u0005\u0002\t\na\u0001P5oSRtDCA\u0012%!\t\u0019\u0002\u0001C\u0003\u0018A\u0001\u0007\u0001\u0004C\u0004'\u0001\t\u0007I\u0011B\u0014\u0002\u0017A,'oY3oi&dW-M\u000b\u0002QA\u0011Q\"K\u0005\u0003U9\u0011a\u0001R8vE2,\u0007B\u0002\u0017\u0001A\u0003%\u0001&\u0001\u0007qKJ\u001cWM\u001c;jY\u0016\f\u0004\u0005C\u0004/\u0001\t\u0007I\u0011B\u0014\u0002\u0017A,'oY3oi&dWM\r\u0005\u0007a\u0001\u0001\u000b\u0011\u0002\u0015\u0002\u0019A,'oY3oi&dWM\r\u0011\t\u000fI\u0002!\u0019!C\u0005O\u0005Y\u0001/\u001a:dK:$\u0018\u000e\\34\u0011\u0019!\u0004\u0001)A\u0005Q\u0005a\u0001/\u001a:dK:$\u0018\u000e\\34A!9a\u0007\u0001b\u0001\n\u00139\u0013a\u00039fe\u000e,g\u000e^5mKRBa\u0001\u000f\u0001!\u0002\u0013A\u0013\u0001\u00049fe\u000e,g\u000e^5mKR\u0002\u0003b\u0002\u001e\u0001\u0005\u0004%IaO\u0001\f_.D\u0015n\u001d;pOJ\fW.F\u0001=!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0007IIJD\u0015n\u001d;pOJ\fWNC\u0001B\u0003\ry'oZ\u0005\u0003\u0007z\u0012\u0011#\u00112tiJ\f7\r\u001e%jgR|wM]1n\u0011\u0019)\u0005\u0001)A\u0005y\u0005aqn\u001b%jgR|wM]1nA!9q\t\u0001b\u0001\n\u0013Y\u0014aC6p\u0011&\u001cHo\\4sC6Da!\u0013\u0001!\u0002\u0013a\u0014\u0001D6p\u0011&\u001cHo\\4sC6\u0004\u0003bB&\u0001\u0005\u0004%IaO\u0001\rC2d\u0007*[:u_\u001e\u0014\u0018-\u001c\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\u001f\u0002\u001b\u0005dG\u000eS5ti><'/Y7!\u0011\u0015y\u0005\u0001\"\u0011Q\u0003\r\tG\r\u001a\u000b\u0004#Rs\u0006CA\u0007S\u0013\t\u0019fB\u0001\u0003V]&$\b\"B+O\u0001\u00041\u0016AB:uCR,8\u000f\u0005\u0002X96\t\u0001L\u0003\u0002Z5\u0006)1\u000f^1ug*\u00111LB\u0001\bG>lWn\u001c8t\u0013\ti\u0006L\u0001\u0004Ti\u0006$Xo\u001d\u0005\u0006?:\u0003\r\u0001Y\u0001\u0005i&lW\r\u0005\u0002\u000eC&\u0011!M\u0004\u0002\u0005\u0019>tw\rC\u0003e\u0001\u0011\u0005S-A\u0003dY\u0016\f'\u000fF\u0001R\u0011\u00159\u0007\u0001\"\u0011i\u0003=iW\r\u001e:jGN\u0014\u0015p\u0015;biV\u001cX#A5\u0011\u0005MQ\u0017BA6\u0003\u00059iU\r\u001e:jG\nK8\u000b^1ukNDQ!\u001c\u0001\u0005\n9\f!#\\3ue&\u001c7o\u00144ISN$xn\u001a:b[R\u0011q.\u001e\t\u0004\u001bA\u0014\u0018BA9\u000f\u0005\u0019y\u0005\u000f^5p]B\u00111c]\u0005\u0003i\n\u0011q!T3ue&\u001c7\u000fC\u0003wY\u0002\u0007A(A\u0005iSN$xn\u001a:b[\u0002")
public class HistogramRequestMetricsBuffer
implements RequestMetricsBuffer {
    private final double percentile1;
    private final double percentile2;
    private final double percentile3;
    private final double percentile4;
    private final AbstractHistogram okHistogram;
    private final AbstractHistogram koHistogram;
    private final AbstractHistogram allHistogram;

    private double percentile1() {
        return this.percentile1;
    }

    private double percentile2() {
        return this.percentile2;
    }

    private double percentile3() {
        return this.percentile3;
    }

    private double percentile4() {
        return this.percentile4;
    }

    private AbstractHistogram okHistogram() {
        return this.okHistogram;
    }

    private AbstractHistogram koHistogram() {
        return this.koHistogram;
    }

    private AbstractHistogram allHistogram() {
        return this.allHistogram;
    }

    @Override
    public void add(Status status, long time) {
        long recordableTime = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(time), 1L);
        this.allHistogram().recordValue(recordableTime);
        Status status2 = status;
        if (OK$.MODULE$.equals(status2)) {
            this.okHistogram().recordValue(recordableTime);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (KO$.MODULE$.equals(status2)) {
            this.koHistogram().recordValue(recordableTime);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)status2);
        }
    }

    @Override
    public void clear() {
        this.okHistogram().reset();
        this.koHistogram().reset();
        this.allHistogram().reset();
    }

    @Override
    public MetricByStatus metricsByStatus() {
        return new MetricByStatus(this.metricsOfHistogram(this.okHistogram()), this.metricsOfHistogram(this.koHistogram()), this.metricsOfHistogram(this.allHistogram()));
    }

    private Option<Metrics> metricsOfHistogram(AbstractHistogram histogram) {
        long count = histogram.getTotalCount();
        return count > 0L ? new Some((Object)new Metrics(count, (int)histogram.getMinValue(), (int)histogram.getMaxValue(), (int)histogram.getMean(), (int)histogram.getStdDeviation(), (int)histogram.getValueAtPercentile(this.percentile1()), (int)histogram.getValueAtPercentile(this.percentile2()), (int)histogram.getValueAtPercentile(this.percentile3()), (int)histogram.getValueAtPercentile(this.percentile4()))) : None$.MODULE$;
    }

    public HistogramRequestMetricsBuffer(GatlingConfiguration configuration) {
        this.percentile1 = configuration.charting().indicators().percentile1();
        this.percentile2 = configuration.charting().indicators().percentile2();
        this.percentile3 = configuration.charting().indicators().percentile3();
        this.percentile4 = configuration.charting().indicators().percentile4();
        this.okHistogram = new IntCountsHistogram(2);
        this.koHistogram = new IntCountsHistogram(2);
        this.allHistogram = new IntCountsHistogram(2);
    }
}

