/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.graphite;

import akka.actor.ActorRef;
import akka.actor.package$;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Collections;
import io.gatling.commons.util.Collections$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.message.ResponseTimings$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.Flush$;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.ShortScenarioDescription;
import io.gatling.core.stats.writer.UserMessage;
import io.gatling.core.util.NameGen;
import io.gatling.graphite.GraphiteData;
import io.gatling.graphite.GraphitePath;
import io.gatling.graphite.GraphitePathPattern;
import io.gatling.graphite.OldGraphitePathPattern;
import io.gatling.graphite.message.GraphiteMetrics$;
import io.gatling.graphite.sender.MetricsSender$;
import io.gatling.graphite.types.HistogramRequestMetricsBuffer;
import io.gatling.graphite.types.MetricByStatus;
import io.gatling.graphite.types.RequestMetricsBuffer;
import io.gatling.graphite.types.UserBreakdown;
import io.gatling.graphite.types.UserBreakdownBuffer;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=c!B\b\u0011\u0001I1\u0002\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011Q\u0002!\u0011!Q\u0001\nUBQa\u000f\u0001\u0005\u0002qBQ\u0001\u0011\u0001\u0005\u0002\u0005Cq\u0001\u0013\u0001C\u0002\u0013%\u0011\n\u0003\u0004S\u0001\u0001\u0006IA\u0013\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u00065\u0002!\ta\u0017\u0005\u0006I\u0002!I!\u001a\u0005\u0006Y\u0002!I!\u001c\u0005\u0006i\u0002!\t%\u001e\u0005\u0006y\u0002!\t% \u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\ti\u0002\u0001C\u0005\u0003?\u0011!c\u0012:ba\"LG/\u001a#bi\u0006<&/\u001b;fe*\u0011\u0011CE\u0001\tOJ\f\u0007\u000f[5uK*\u00111\u0003F\u0001\bO\u0006$H.\u001b8h\u0015\u0005)\u0012AA5p'\r\u0001q#\n\t\u00041}\tS\"A\r\u000b\u0005iY\u0012AB<sSR,'O\u0003\u0002\u001d;\u0005)1\u000f^1ug*\u0011aDE\u0001\u0005G>\u0014X-\u0003\u0002!3\tQA)\u0019;b/JLG/\u001a:\u0011\u0005\t\u001aS\"\u0001\t\n\u0005\u0011\u0002\"\u0001D$sCBD\u0017\u000e^3ECR\f\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u001e\u0003\u0011)H/\u001b7\n\u0005):#a\u0002(b[\u0016<UM\\\u0001\u0006G2|7m[\u0002\u0001!\tq#'D\u00010\u0015\tA\u0003G\u0003\u00022%\u000591m\\7n_:\u001c\u0018BA\u001a0\u0005\u0015\u0019En\\2l\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011a'O\u0007\u0002o)\u0011\u0001(H\u0001\u0007G>tg-[4\n\u0005i:$\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004{yz\u0004C\u0001\u0012\u0001\u0011\u0015Y3\u00011\u0001.\u0011\u0015!4\u00011\u00016\u0003aqWm\u001e*fgB|gn]3NKR\u0014\u0018nY:Ck\u001a4WM]\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q\tE\u0001\u0006if\u0004Xm]\u0005\u0003\u000f\u0012\u0013ACU3rk\u0016\u001cH/T3ue&\u001c7OQ;gM\u0016\u0014\u0018A\u00044mkNDG+[7fe:\u000bW.Z\u000b\u0002\u0015B\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\u0005Y\u0006twMC\u0001P\u0003\u0011Q\u0017M^1\n\u0005Ec%AB*ue&tw-A\bgYV\u001c\b\u000eV5nKJt\u0015-\\3!\u0003\u0019yg.\u00138jiR\u0011\u0011%\u0016\u0005\u0006-\u001e\u0001\raV\u0001\u0005S:LG\u000f\u0005\u0002\u00191&\u0011\u0011,\u0007\u0002\u0005\u0013:LG/A\u0004p]\u001acWo\u001d5\u0015\u0005q\u0013\u0007CA/a\u001b\u0005q&\"A0\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005t&\u0001B+oSRDQa\u0019\u0005A\u0002\u0005\nA\u0001Z1uC\u0006iqN\\+tKJlUm]:bO\u0016$2\u0001\u00184l\u0011\u00159\u0017\u00021\u0001i\u0003-)8/\u001a:NKN\u001c\u0018mZ3\u0011\u0005aI\u0017B\u00016\u001a\u0005-)6/\u001a:NKN\u001c\u0018mZ3\t\u000b\rL\u0001\u0019A\u0011\u0002#=t'+Z:q_:\u001cX-T3tg\u0006<W\rF\u0002]]NDQa\u001c\u0006A\u0002A\f\u0001B]3ta>t7/\u001a\t\u00031EL!A]\r\u0003\u001fI+7\u000f]8og\u0016lUm]:bO\u0016DQa\u0019\u0006A\u0002\u0005\n\u0011b\u001c8NKN\u001c\u0018mZ3\u0015\u0007q38\u0010C\u0003x\u0017\u0001\u0007\u00010A\u0004nKN\u001c\u0018mZ3\u0011\u0005aI\u0018B\u0001>\u001a\u0005Aau.\u00193Fm\u0016tG/T3tg\u0006<W\rC\u0003d\u0017\u0001\u0007\u0011%A\u0004p]\u000e\u0013\u0018m\u001d5\u0015\tqs\u0018Q\u0003\u0005\u0007\u007f2\u0001\r!!\u0001\u0002\u000b\r\fWo]3\u0011\t\u0005\r\u0011\u0011\u0003\b\u0005\u0003\u000b\ti\u0001E\u0002\u0002\byk!!!\u0003\u000b\u0007\u0005-A&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001fq\u0016A\u0002)sK\u0012,g-C\u0002R\u0003'Q1!a\u0004_\u0011\u0015\u0019G\u00021\u0001\"\u0003\u0019ygn\u0015;paR\u0019A,a\u0007\t\u000b\rl\u0001\u0019A\u0011\u0002+M,g\u000eZ'fiJL7m\u001d+p\u000fJ\f\u0007\u000f[5uKRIA,!\t\u0002$\u00055\u00121\t\u0005\u0006G:\u0001\r!\t\u0005\b\u0003Kq\u0001\u0019AA\u0014\u0003\u0015)\u0007o\\2i!\ri\u0016\u0011F\u0005\u0004\u0003Wq&\u0001\u0002'p]\u001eDq!a\f\u000f\u0001\u0004\t\t$A\bsKF,Xm\u001d;t\u001b\u0016$(/[2t!!\t\u0019!a\r\u00028\u0005u\u0012\u0002BA\u001b\u0003'\u00111!T1q!\r\u0011\u0013\u0011H\u0005\u0004\u0003w\u0001\"\u0001D$sCBD\u0017\u000e^3QCRD\u0007cA\"\u0002@%\u0019\u0011\u0011\t#\u0003\u001d5+GO]5d\u0005f\u001cF/\u0019;vg\"9\u0011Q\t\bA\u0002\u0005\u001d\u0013AD;tKJ\u0014%/Z1lI><hn\u001d\t\t\u0003\u0007\t\u0019$a\u000e\u0002JA\u00191)a\u0013\n\u0007\u00055CIA\u0007Vg\u0016\u0014(I]3bW\u0012|wO\u001c")
public class GraphiteDataWriter
extends DataWriter<GraphiteData>
implements NameGen {
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final String flushTimerName;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public RequestMetricsBuffer newResponseMetricsBuffer() {
        return new HistogramRequestMetricsBuffer(this.configuration);
    }

    private String flushTimerName() {
        return this.flushTimerName;
    }

    public GraphiteData onInit(Init init) {
        ActorRef metricsSender = this.context().actorOf(MetricsSender$.MODULE$.props(this.clock, this.configuration), this.genName("metricsSender"));
        Map requestsByPath = Map$.MODULE$.empty();
        Map usersByScenario = Map$.MODULE$.empty();
        OldGraphitePathPattern pattern = new OldGraphitePathPattern(init.runMessage(), this.configuration);
        usersByScenario.update((Object)((GraphitePathPattern)pattern).allUsersPath(), (Object)new UserBreakdownBuffer(BoxesRunTime.unboxToLong((Object)Collections.PimpedTraversableOnce$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedTraversableOnce((TraversableOnce)init.scenarios()), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)GraphiteDataWriter.$anonfun$onInit$1(x$1)), (Numeric)Numeric.LongIsIntegral$.MODULE$))));
        init.scenarios().foreach((Function1 & Serializable & scala.Serializable)scenario -> (Map)usersByScenario.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pattern.usersPath(scenario.name())), (Object)new UserBreakdownBuffer(BoxesRunTime.unboxToLong((Object)scenario.totalUserCount().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L))))));
        this.setTimer(this.flushTimerName(), Flush$.MODULE$, this.configuration.data().graphite().writePeriod(), true);
        return new GraphiteData(metricsSender, (Map<GraphitePath, RequestMetricsBuffer>)requestsByPath, (Map<GraphitePath, UserBreakdownBuffer>)usersByScenario, pattern);
    }

    public void onFlush(GraphiteData data) {
        scala.collection.immutable.Map requestsMetrics = data.requestsByPath().mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.metricsByStatus()).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map usersBreakdowns = data.usersByScenario().mapValues((Function1 & Serializable & scala.Serializable)x$3 -> x$3.breakDown()).toMap(Predef$.MODULE$.$conforms());
        data.requestsByPath().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GraphiteDataWriter.$anonfun$onFlush$3(x0$1);
            return BoxedUnit.UNIT;
        });
        this.sendMetricsToGraphite(data, this.clock.nowSeconds(), (scala.collection.immutable.Map<GraphitePath, MetricByStatus>)requestsMetrics, (scala.collection.immutable.Map<GraphitePath, UserBreakdown>)usersBreakdowns);
    }

    private void onUserMessage(UserMessage userMessage, GraphiteData data) {
        ((UserBreakdownBuffer)data.usersByScenario().apply((Object)data.format().usersPath(userMessage.session().scenario()))).add(userMessage);
        ((UserBreakdownBuffer)data.usersByScenario().apply((Object)data.format().allUsersPath())).add(userMessage);
    }

    private void onResponseMessage(ResponseMessage response, GraphiteData data) {
        int responseTime = ResponseTimings$.MODULE$.responseTime(response.startTimestamp(), response.endTimestamp());
        if (!this.configuration.data().graphite().light()) {
            ((RequestMetricsBuffer)data.requestsByPath().getOrElseUpdate((Object)data.format().responsePath(response.name(), (List<String>)response.groupHierarchy()), (Function0 & Serializable & scala.Serializable)() -> this.newResponseMetricsBuffer())).add(response.status(), responseTime);
        }
        ((RequestMetricsBuffer)data.requestsByPath().getOrElseUpdate((Object)data.format().allResponsesPath(), (Function0 & Serializable & scala.Serializable)() -> this.newResponseMetricsBuffer())).add(response.status(), responseTime);
    }

    public void onMessage(LoadEventMessage message, GraphiteData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)loadEventMessage;
            this.onUserMessage(userMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            this.onResponseMessage(responseMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void onCrash(String cause, GraphiteData data) {
    }

    public void onStop(GraphiteData data) {
        this.cancelTimer(this.flushTimerName());
        this.onFlush(data);
    }

    private void sendMetricsToGraphite(GraphiteData data, long epoch, scala.collection.immutable.Map<GraphitePath, MetricByStatus> requestsMetrics, scala.collection.immutable.Map<GraphitePath, UserBreakdown> userBreakdowns) {
        package$.MODULE$.actorRef2Scala(data.metricsSender()).$bang((Object)GraphiteMetrics$.MODULE$.apply(data.format().metrics(userBreakdowns, requestsMetrics), epoch), this.self());
    }

    public static final /* synthetic */ long $anonfun$onInit$1(ShortScenarioDescription x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.totalUserCount().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$onFlush$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RequestMetricsBuffer buff = (RequestMetricsBuffer)tuple2._2();
        buff.clear();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public GraphiteDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        NameGen.$init$((NameGen)this);
        this.flushTimerName = "flushTimer";
    }
}

