/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.grpc;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.javaapi.core.ActionBuilder;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.grpc.GrpcClientStreamAwaitStreamEndActionBuilder;
import io.gatling.javaapi.grpc.GrpcDsl;
import io.gatling.javaapi.grpc.internal.Expressions;
import io.gatling.javaapi.grpc.internal.GrpcChecks;
import io.grpc.CallCredentials;
import io.grpc.Metadata;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class GrpcClientStreamingServiceBuilder<ReqT, RespT> {
    private final io.gatling.grpc.service.builder.GrpcClientStreamingServiceBuilder<ReqT, RespT> wrapped;

    GrpcClientStreamingServiceBuilder(io.gatling.grpc.service.builder.GrpcClientStreamingServiceBuilder<ReqT, RespT> grpcClientStreamingServiceBuilder) {
        this.wrapped = grpcClientStreamingServiceBuilder;
    }

    private GrpcClientStreamingServiceBuilder<ReqT, RespT> make(Function<io.gatling.grpc.service.builder.GrpcClientStreamingServiceBuilder<ReqT, RespT>, io.gatling.grpc.service.builder.GrpcClientStreamingServiceBuilder<ReqT, RespT>> function) {
        return new GrpcClientStreamingServiceBuilder<ReqT, RespT>(function.apply(this.wrapped));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> asciiHeader(@NonNull String string, @NonNull String string2) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.asciiHeader(string, string2));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> asciiHeaders(Map<String, String> map) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.asciiHeaders(Converters.toScalaMap((Map)map)));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> binaryHeader(@NonNull String string, @NonNull byte[] byArray) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.binaryHeader(string, byArray));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> binaryHeaders(@NonNull Map<String, byte[]> map) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.binaryHeaders(Converters.toScalaMap((Map)map)));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> callCredentials(@NonNull Function<Session, CallCredentials> function) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.callCredentials(io.gatling.javaapi.core.internal.Expressions.javaFunctionToExpression((Function)function)));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> callCredentials(@NonNull String string) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.callCredentials(io.gatling.javaapi.core.internal.Expressions.toExpression((String)string, CallCredentials.class)));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> callCredentials(@NonNull CallCredentials callCredentials) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.callCredentials(io.gatling.javaapi.core.internal.Expressions.toStaticValueExpression((Object)callCredentials)));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> check(CheckBuilder ... checkBuilderArray) {
        return this.check(Arrays.asList(checkBuilderArray));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> check(@NonNull List<CheckBuilder> list) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.check(GrpcChecks.toScalaChecks(list)));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> deadlineAfter(long l) {
        return this.deadlineAfter(Duration.ofSeconds(l));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> deadlineAfter(@NonNull Duration duration) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.deadlineAfter(Converters.toScalaDuration((Duration)duration)));
    }

    @NonNull
    public <T> GrpcClientStreamingServiceBuilder<ReqT, RespT> header(@NonNull Metadata.Key<T> key, @NonNull T t) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.header(key, t));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> messageRequestName(@NonNull String string) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.messageRequestName(io.gatling.javaapi.core.internal.Expressions.toStringExpression((String)string)));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> messageRequestName(@NonNull Function<Session, String> function) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.messageRequestName(io.gatling.javaapi.core.internal.Expressions.javaFunctionToExpression((Function)function)));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> messageResponseTimePolicy(@NonNull GrpcDsl.MessageResponseTimePolicy messageResponseTimePolicy) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.messageResponseTimePolicy(messageResponseTimePolicy.toScalaEnum()));
    }

    @NonNull
    public GrpcClientStreamingServiceBuilder<ReqT, RespT> streamName(@NonNull String string) {
        return this.make(grpcClientStreamingServiceBuilder -> grpcClientStreamingServiceBuilder.streamName(string));
    }

    @NonNull
    public ActionBuilder start() {
        return () -> this.wrapped.start();
    }

    @NonNull
    public ActionBuilder cancel() {
        return () -> this.wrapped.cancel();
    }

    @NonNull
    public ActionBuilder send(@NonNull ReqT ReqT) {
        return this.send(session -> ReqT);
    }

    @NonNull
    public ActionBuilder send(@NonNull Function<Session, ReqT> function) {
        return () -> this.wrapped.send(io.gatling.javaapi.core.internal.Expressions.javaFunctionToExpression((Function)function));
    }

    @NonNull
    public ActionBuilder halfClose() {
        return () -> this.wrapped.halfClose();
    }

    @NonNull
    public GrpcClientStreamAwaitStreamEndActionBuilder<ReqT, RespT> awaitStreamEnd(@NonNull BiFunction<Session, Session, Session> biFunction) {
        return new GrpcClientStreamAwaitStreamEndActionBuilder(this.wrapped.awaitStreamEnd(Expressions.reconcileBiFunctionToExpression(biFunction)));
    }

    @NonNull
    public GrpcClientStreamAwaitStreamEndActionBuilder<ReqT, RespT> awaitStreamEnd() {
        return new GrpcClientStreamAwaitStreamEndActionBuilder(this.wrapped.awaitStreamEnd());
    }
}

