/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.grpc;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.grpc.Predef;
import io.gatling.grpc.Predef$;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.grpc.Grpc;
import io.gatling.javaapi.grpc.GrpcProtocolBuilder;
import io.gatling.javaapi.grpc.internal.GrpcCheckType;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.function.Function;
import net.jodah.typetools.TypeResolver;
import scala.Function1;

public final class GrpcDsl {
    public static final GrpcProtocolBuilder grpc = new GrpcProtocolBuilder(io.gatling.grpc.protocol.GrpcProtocolBuilder.apply((GatlingConfiguration)io.gatling.core.Predef.configuration()));

    private GrpcDsl() {
    }

    @NonNull
    public static Grpc grpc(@NonNull String string) {
        return new Grpc((Function1<io.gatling.core.session.Session, Validation<String>>)Expressions.toStringExpression((String)string));
    }

    @NonNull
    public static Grpc grpc(@NonNull Function<Session, String> function) {
        return new Grpc((Function1<io.gatling.core.session.Session, Validation<String>>)Expressions.javaFunctionToExpression(function));
    }

    @NonNull
    public static CheckBuilder.Find<Status.Code> statusCode() {
        return new CheckBuilder.Find.Default(Predef.statusCode(), (CheckBuilder.CheckType)GrpcCheckType.Status, Status.Code.class, null);
    }

    @NonNull
    public static CheckBuilder.Find<String> statusDescription() {
        return new CheckBuilder.Find.Default(Predef.statusDescription(), (CheckBuilder.CheckType)GrpcCheckType.Status, String.class, null);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<String> asciiHeader(@NonNull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.asciiHeader((String)string), (CheckBuilder.CheckType)GrpcCheckType.Header, Metadata.class, null);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<byte[]> binaryHeader(@NonNull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.binaryHeader((String)string), (CheckBuilder.CheckType)GrpcCheckType.Header, Metadata.class, null);
    }

    @NonNull
    public static <X> CheckBuilder.MultipleFind<X> header(@NonNull Metadata.Key<X> key) {
        return new CheckBuilder.MultipleFind.Default(Predef.header(key), (CheckBuilder.CheckType)GrpcCheckType.Header, Metadata.class, null);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<String> asciiTrailer(@NonNull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.asciiTrailer((String)string), (CheckBuilder.CheckType)GrpcCheckType.Trailer, Metadata.class, null);
    }

    @NonNull
    public static CheckBuilder.MultipleFind<byte[]> binaryTrailer(@NonNull String string) {
        return new CheckBuilder.MultipleFind.Default(Predef.binaryTrailer((String)string), (CheckBuilder.CheckType)GrpcCheckType.Trailer, Metadata.class, null);
    }

    @NonNull
    public static <X> CheckBuilder.MultipleFind<X> trailer(@NonNull Metadata.Key<X> key) {
        return new CheckBuilder.MultipleFind.Default(Predef.trailer(key), (CheckBuilder.CheckType)GrpcCheckType.Trailer, Metadata.class, null);
    }

    @NonNull
    public static <X, X2> CheckBuilder.Find<X2> response(@NonNull Function<X, X2> function) {
        Class[] classArray = TypeResolver.resolveRawArguments(Function.class, function.getClass());
        Class clazz = classArray[1];
        return new CheckBuilder.Find.Default(Predef.response(object -> new Success(function.apply(object))), (CheckBuilder.CheckType)GrpcCheckType.Response, clazz, null);
    }

    public static enum MessageResponseTimePolicy {
        FromStreamStart,
        FromLastMessageSent,
        FromLastMessageReceived;


        io.gatling.grpc.engine.MessageResponseTimePolicy toScalaEnum() {
            switch (this.ordinal()) {
                case 0: {
                    return Predef$.MODULE$.FromStreamStartPolicy();
                }
                case 1: {
                    return Predef$.MODULE$.FromLastMessageSentPolicy();
                }
                case 2: {
                    return Predef$.MODULE$.FromLastMessageReceivedPolicy();
                }
            }
            throw new RuntimeException("Unknown MessageResponseTimePolicy type: " + ((Object)((Object)this)).getClass().getSimpleName());
        }
    }
}

