/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.grpc;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.core.protocol.Protocol;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.grpc.CallCredentials;
import io.grpc.ChannelCredentials;
import io.grpc.Metadata;
import java.util.Map;
import java.util.function.Function;

public final class GrpcProtocolBuilder
implements ProtocolBuilder {
    private final io.gatling.grpc.protocol.GrpcProtocolBuilder wrapped;

    GrpcProtocolBuilder(io.gatling.grpc.protocol.GrpcProtocolBuilder grpcProtocolBuilder) {
        this.wrapped = grpcProtocolBuilder;
    }

    private GrpcProtocolBuilder make(Function<io.gatling.grpc.protocol.GrpcProtocolBuilder, io.gatling.grpc.protocol.GrpcProtocolBuilder> function) {
        return new GrpcProtocolBuilder(function.apply(this.wrapped));
    }

    @NonNull
    public GrpcProtocolBuilder asciiHeader(@NonNull String string, @NonNull String string2) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.asciiHeader(string, string2));
    }

    @NonNull
    public GrpcProtocolBuilder asciiHeaders(@NonNull Map<String, String> map) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.asciiHeaders(Converters.toScalaMap((Map)map)));
    }

    @NonNull
    public GrpcProtocolBuilder binaryHeader(@NonNull String string, byte[] byArray) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.binaryHeader(string, byArray));
    }

    @NonNull
    public GrpcProtocolBuilder binaryHeaders(@NonNull Map<String, byte[]> map) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.binaryHeaders(Converters.toScalaMap((Map)map)));
    }

    @NonNull
    public GrpcProtocolBuilder callCredentials(@NonNull Function<Session, CallCredentials> function) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.callCredentials(Expressions.javaFunctionToExpression((Function)function)));
    }

    @NonNull
    public GrpcProtocolBuilder callCredentials(@NonNull String string) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.callCredentials(Expressions.toExpression((String)string, CallCredentials.class)));
    }

    @NonNull
    public GrpcProtocolBuilder callCredentials(@NonNull CallCredentials callCredentials) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.callCredentials(Expressions.toStaticValueExpression((Object)callCredentials)));
    }

    @NonNull
    public GrpcProtocolBuilder channelCredentials(@NonNull Function<Session, ChannelCredentials> function) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.channelCredentials(Expressions.javaFunctionToExpression((Function)function)));
    }

    @NonNull
    public GrpcProtocolBuilder channelCredentials(@NonNull String string) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.channelCredentials(Expressions.toExpression((String)string, ChannelCredentials.class)));
    }

    @NonNull
    public GrpcProtocolBuilder channelCredentials(@NonNull ChannelCredentials channelCredentials) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.channelCredentials(channelCredentials));
    }

    @NonNull
    public GrpcProtocolBuilder forAddress(@NonNull String string, int n) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.forAddress(string, n));
    }

    @NonNull
    public GrpcProtocolBuilder forTarget(@NonNull String string) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.forTarget(string));
    }

    @NonNull
    public <T> GrpcProtocolBuilder header(@NonNull Metadata.Key<T> key, @NonNull T t) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.header(key, t));
    }

    @NonNull
    public GrpcProtocolBuilder overrideAuthority(@NonNull String string) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.overrideAuthority(string));
    }

    @NonNull
    public GrpcProtocolBuilder shareChannel() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::shareChannel);
    }

    @NonNull
    public GrpcProtocolBuilder shareSslContext() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::shareSslContext);
    }

    @NonNull
    public GrpcProtocolBuilder useChannelPool(int n) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.useChannelPool(n));
    }

    @NonNull
    public GrpcProtocolBuilder usePlaintext() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::usePlaintext);
    }

    @NonNull
    public GrpcProtocolBuilder useInsecureTrustManager() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::useInsecureTrustManager);
    }

    @NonNull
    public GrpcProtocolBuilder useStandardTrustManager() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::useStandardTrustManager);
    }

    @NonNull
    public GrpcProtocolBuilder useCustomCertificateTrustManager(@NonNull String string) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.useCustomCertificateTrustManager(string));
    }

    @NonNull
    public GrpcProtocolBuilder useCustomLoadBalancingPolicy(@NonNull String string) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.useCustomLoadBalancingPolicy(string));
    }

    @NonNull
    public GrpcProtocolBuilder useCustomLoadBalancingPolicy(@NonNull String string, @NonNull String string2) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.useCustomLoadBalancingPolicy(string, string2));
    }

    @NonNull
    public GrpcProtocolBuilder usePickFirstLoadBalancingPolicy() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::usePickFirstLoadBalancingPolicy);
    }

    @NonNull
    public GrpcProtocolBuilder usePickRandomLoadBalancingPolicy() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::usePickRandomLoadBalancingPolicy);
    }

    @NonNull
    public GrpcProtocolBuilder useRoundRobinLoadBalancingPolicy() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::useRoundRobinLoadBalancingPolicy);
    }

    public Protocol protocol() {
        return this.wrapped.protocol();
    }
}

