/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.grpc;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.javaapi.core.ActionBuilder;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.grpc.internal.GrpcChecks;
import io.grpc.CallCredentials;
import io.grpc.Metadata;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class GrpcUnaryActionBuilder<ReqT, RespT>
implements ActionBuilder {
    private final io.gatling.grpc.action.builder.GrpcUnaryActionBuilder<ReqT, RespT> wrapped;

    GrpcUnaryActionBuilder(io.gatling.grpc.action.builder.GrpcUnaryActionBuilder<ReqT, RespT> grpcUnaryActionBuilder) {
        this.wrapped = grpcUnaryActionBuilder;
    }

    public io.gatling.core.action.builder.ActionBuilder asScala() {
        return this.wrapped;
    }

    private GrpcUnaryActionBuilder<ReqT, RespT> make(Function<io.gatling.grpc.action.builder.GrpcUnaryActionBuilder<ReqT, RespT>, io.gatling.grpc.action.builder.GrpcUnaryActionBuilder<ReqT, RespT>> function) {
        return new GrpcUnaryActionBuilder<ReqT, RespT>(function.apply(this.wrapped));
    }

    @NonNull
    public GrpcUnaryActionBuilder<ReqT, RespT> asciiHeader(@NonNull String string, @NonNull String string2) {
        return this.make(grpcUnaryActionBuilder -> grpcUnaryActionBuilder.asciiHeader(string, string2));
    }

    @NonNull
    public GrpcUnaryActionBuilder<ReqT, RespT> asciiHeaders(@NonNull Map<String, String> map) {
        return this.make(grpcUnaryActionBuilder -> grpcUnaryActionBuilder.asciiHeaders(Converters.toScalaMap((Map)map)));
    }

    @NonNull
    public GrpcUnaryActionBuilder<ReqT, RespT> binaryHeader(String string, byte[] byArray) {
        return this.make(grpcUnaryActionBuilder -> grpcUnaryActionBuilder.binaryHeader(string, byArray));
    }

    @NonNull
    public GrpcUnaryActionBuilder<ReqT, RespT> binaryHeaders(@NonNull Map<String, byte[]> map) {
        return this.make(grpcUnaryActionBuilder -> grpcUnaryActionBuilder.binaryHeaders(Converters.toScalaMap((Map)map)));
    }

    @NonNull
    public GrpcUnaryActionBuilder<ReqT, RespT> callCredentials(@NonNull Function<Session, CallCredentials> function) {
        return this.make(grpcUnaryActionBuilder -> grpcUnaryActionBuilder.callCredentials(Expressions.javaFunctionToExpression((Function)function)));
    }

    @NonNull
    public GrpcUnaryActionBuilder<ReqT, RespT> callCredentials(@NonNull String string) {
        return this.make(grpcUnaryActionBuilder -> grpcUnaryActionBuilder.callCredentials(Expressions.toExpression((String)string, CallCredentials.class)));
    }

    @NonNull
    public GrpcUnaryActionBuilder<ReqT, RespT> callCredentials(@NonNull CallCredentials callCredentials) {
        return this.make(grpcUnaryActionBuilder -> grpcUnaryActionBuilder.callCredentials(Expressions.toStaticValueExpression((Object)callCredentials)));
    }

    @NonNull
    public GrpcUnaryActionBuilder<ReqT, RespT> check(CheckBuilder ... checkBuilderArray) {
        return this.check(Arrays.asList(checkBuilderArray));
    }

    @NonNull
    public GrpcUnaryActionBuilder<ReqT, RespT> check(@NonNull List<CheckBuilder> list) {
        return this.make(grpcUnaryActionBuilder -> grpcUnaryActionBuilder.check(GrpcChecks.toScalaChecks(list)));
    }

    @NonNull
    public GrpcUnaryActionBuilder<ReqT, RespT> deadlineAfter(long l) {
        return this.deadlineAfter(Duration.ofSeconds(l));
    }

    @NonNull
    public GrpcUnaryActionBuilder<ReqT, RespT> deadlineAfter(@NonNull Duration duration) {
        return this.make(grpcUnaryActionBuilder -> grpcUnaryActionBuilder.deadlineAfter(Converters.toScalaDuration((Duration)duration)));
    }

    @NonNull
    public <T> GrpcUnaryActionBuilder<ReqT, RespT> header(@NonNull Metadata.Key<T> key, @NonNull T t) {
        return this.make(grpcUnaryActionBuilder -> grpcUnaryActionBuilder.header(key, t));
    }
}

