/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.grpc;

import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.grpc.internal.AsciiScalaGrpcHeaderValue;
import io.gatling.javaapi.grpc.internal.BinaryScalaGrpcHeaderValue;
import io.gatling.javaapi.grpc.internal.GenericScalaGrpcHeaderValue;
import io.gatling.javaapi.grpc.internal.ScalaGrpcHeaderValue;
import io.grpc.Metadata;
import java.util.Map;
import java.util.function.Function;
import net.jodah.typetools.TypeResolver;
import org.jspecify.annotations.NonNull;

public interface GrpcHeaders<B extends GrpcHeaders<B, W>, W extends io.gatling.grpc.protocol.GrpcHeaders<W>> {
    public B make(Function<W, W> var1);

    default public @NonNull Value<B, String> asciiHeader(@NonNull String string) {
        return new Value(new AsciiScalaGrpcHeaderValue(this, string));
    }

    default public @NonNull B asciiHeaders(@NonNull Map<String, String> map) {
        return this.make(grpcHeaders -> grpcHeaders.asciiHeaders(Converters.toScalaMap((Map)map)));
    }

    default public @NonNull Value<B, byte[]> binaryHeader(@NonNull String string) {
        return new Value(new BinaryScalaGrpcHeaderValue(this, string));
    }

    default public @NonNull B binaryHeaders(@NonNull Map<String, byte[]> map) {
        return this.make(grpcHeaders -> grpcHeaders.binaryHeaders(Converters.toScalaMap((Map)map)));
    }

    default public <T> @NonNull Value<B, T> header(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Metadata.Key<T> key) {
        return new Value(new GenericScalaGrpcHeaderValue(this, key));
    }

    public static final class Value<B extends GrpcHeaders<B, ?>, V> {
        private final ScalaGrpcHeaderValue<B, ?, V> wrapped;

        Value(ScalaGrpcHeaderValue<B, ?, V> scalaGrpcHeaderValue) {
            this.wrapped = scalaGrpcHeaderValue;
        }

        public @NonNull B value(@NonNull V v) {
            return this.wrapped.value_(Expressions.toStaticValueExpression(v));
        }

        public @NonNull B value(@NonNull Function<Session, V> function) {
            return this.wrapped.value_(Expressions.javaFunctionToExpression(function));
        }

        @Deprecated(since="3.14.6", forRemoval=true)
        public @NonNull B valueEl(@NonNull String string) {
            return this.valueEL(string);
        }

        public @NonNull B valueEL(@NonNull String string) {
            Class clazz = TypeResolver.resolveRawArguments(Metadata.Key.class, this.wrapped.getClass())[0];
            return this.wrapped.value_(Expressions.toExpression((String)string, (Class)clazz));
        }
    }
}

