/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.grpc;

import io.gatling.core.protocol.Protocol;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.grpc.GrpcHeaders;
import io.gatling.javaapi.grpc.GrpcServerConfigurationBuilder;
import io.grpc.CallCredentials;
import io.grpc.ChannelCredentials;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import scala.collection.Iterable;

public final class GrpcProtocolBuilder
implements ProtocolBuilder,
GrpcHeaders<GrpcProtocolBuilder, io.gatling.grpc.protocol.GrpcProtocolBuilder> {
    private final io.gatling.grpc.protocol.GrpcProtocolBuilder wrapped;

    GrpcProtocolBuilder(io.gatling.grpc.protocol.GrpcProtocolBuilder grpcProtocolBuilder) {
        this.wrapped = grpcProtocolBuilder;
    }

    @Override
    public GrpcProtocolBuilder make(Function<io.gatling.grpc.protocol.GrpcProtocolBuilder, io.gatling.grpc.protocol.GrpcProtocolBuilder> function) {
        return new GrpcProtocolBuilder(function.apply(this.wrapped));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder callCredentials(@NonNull CallCredentials callCredentials) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.callCredentials(Expressions.toStaticValueExpression((Object)callCredentials)));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder callCredentials(@NonNull String string) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.callCredentials(Expressions.toExpression((String)string, CallCredentials.class)));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder callCredentials(@NonNull Function<Session, CallCredentials> function) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.callCredentials(Expressions.javaFunctionToExpression((Function)function)));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder channelCredentials(@NonNull ChannelCredentials channelCredentials) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.channelCredentials(channelCredentials));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder channelCredentials(@NonNull String string) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.channelCredentials(Expressions.toExpression((String)string, ChannelCredentials.class)));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder channelCredentials(@NonNull Function<Session, ChannelCredentials> function) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.channelCredentials(Expressions.javaFunctionToExpression((Function)function)));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder forAddress(@NonNull String string, int n) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.forAddress(string, n));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder forTarget(@NonNull String string) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.forTarget(string));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder overrideAuthority(@NonNull String string) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.overrideAuthority(string));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder shareChannel() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::shareChannel);
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder shareSslContext() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::shareSslContext);
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder useChannelPool(int n) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.useChannelPool(n));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder usePlaintext() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::usePlaintext);
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder useInsecureTrustManager() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::useInsecureTrustManager);
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder useStandardTrustManager() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::useStandardTrustManager);
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder useCustomCertificateTrustManager(@NonNull String string) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.useCustomCertificateTrustManager(string));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder useCustomLoadBalancingPolicy(@NonNull String string) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.useCustomLoadBalancingPolicy(string));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder useCustomLoadBalancingPolicy(@NonNull String string, @NonNull String string2) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.useCustomLoadBalancingPolicy(string, string2));
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder usePickFirstLoadBalancingPolicy() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::usePickFirstLoadBalancingPolicy);
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder usePickRandomLoadBalancingPolicy() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::usePickRandomLoadBalancingPolicy);
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder useRoundRobinLoadBalancingPolicy() {
        return this.make(io.gatling.grpc.protocol.GrpcProtocolBuilder::useRoundRobinLoadBalancingPolicy);
    }

    @Deprecated(since="3.14.9", forRemoval=true)
    public @NonNull GrpcProtocolBuilder unmatchedInboundMessageBufferSize(int n) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.unmatchedInboundMessageBufferSize(n));
    }

    public @NonNull GrpcServerConfigurationBuilder serverConfiguration(@NonNull String string) {
        return new GrpcServerConfigurationBuilder(this.wrapped.serverConfiguration(string));
    }

    public @NonNull GrpcProtocolBuilder serverConfigurations(GrpcServerConfigurationBuilder ... grpcServerConfigurationBuilderArray) {
        return this.serverConfigurations(Arrays.asList(grpcServerConfigurationBuilderArray));
    }

    public @NonNull GrpcProtocolBuilder serverConfigurations(@NonNull List<GrpcServerConfigurationBuilder> list) {
        return this.make(grpcProtocolBuilder -> grpcProtocolBuilder.serverConfigurations((Iterable)Converters.toScalaSeq(list.stream().map(GrpcServerConfigurationBuilder::asScala).collect(Collectors.toList()))));
    }

    public Protocol protocol() {
        return this.wrapped.build();
    }

    public io.gatling.grpc.protocol.GrpcProtocolBuilder asScala() {
        return this.wrapped;
    }
}

