/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.grpc.action;

import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.grpc.action.GrpcRequestAction;
import io.gatling.grpc.engine.ClosedStream$;
import io.gatling.grpc.engine.GrpcStream;
import io.gatling.grpc.engine.StreamListenerState;
import io.gatling.grpc.enterprise.GrpcStatsEngineAdapter;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001\u0002\u0007\u000e\u0005YA\u0001\"\f\u0001\u0003\u0006\u0004%\tE\f\u0005\tk\u0001\u0011\t\u0011)A\u0005_!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0005I\u0001\t\u0005\t\u0015!\u0003J?\"A\u0011\r\u0001B\u0001B\u0003%\u0001\f\u0003\u0005c\u0001\t\u0015\r\u0011\"\u0011d\u0011!a\u0007A!A!\u0002\u0013!\u0007\u0002C7\u0001\u0005\u000b\u0007I\u0011\t8\t\u0011Q\u0004!\u0011!Q\u0001\n=DQ!\u001e\u0001\u0005\u0002YDQA \u0001\u0005B}\u0014\u0001d\u0012:qG\u0006;\u0018-\u001b;TiJ,\u0017-\\#oI\u0006\u001bG/[8o\u0015\tqq\"\u0001\u0004bGRLwN\u001c\u0006\u0003!E\tAa\u001a:qG*\u0011!cE\u0001\bO\u0006$H.\u001b8h\u0015\u0005!\u0012AA5p\u0007\u0001)2a\u0006\u0010,'\t\u0001\u0001\u0004\u0005\u0003\u001a5qQS\"A\u0007\n\u0005mi!!E$sa\u000e\u0014V-];fgR\f5\r^5p]B\u0011QD\b\u0007\u0001\t\u0015y\u0002A1\u0001!\u0005\u0011\u0011V-\u001d+\u0012\u0005\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#a\u0002(pi\"Lgn\u001a\t\u0003E!J!!K\u0012\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\u001eW\u0011)A\u0006\u0001b\u0001A\t)!+Z:q)\u0006yqM\u001d9d'R\fGo]#oO&tW-F\u00010!\t\u00014'D\u00012\u0015\t\u0011t\"\u0001\u0006f]R,'\u000f\u001d:jg\u0016L!\u0001N\u0019\u0003-\u001d\u0013\boY*uCR\u001cXI\\4j]\u0016\fE-\u00199uKJ\f\u0001c\u001a:qGN#\u0018\r^:F]\u001eLg.\u001a\u0011\u0002\u0013I,7m\u001c8dS2,\u0007C\u0001\u001dE\u001d\tI$I\u0004\u0002;\u0003:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}U\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000b\n\u0005I\u0019\u0012B\u0001\t\u0012\u0013\t\u0019u\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000b\u001a\u0013\u0011BU3d_:\u001c\u0017\u000e\\3\n\u0005\u001d{!aB$sa\u000e$5\u000f\\\u0001\u0012gR\u0014X-Y7SKF,Xm\u001d;OC6,\u0007c\u0001&V1:\u00111J\u0015\b\u0003\u0019>s!AO'\n\u00059\u000b\u0012\u0001B2pe\u0016L!\u0001U)\u0002\u000fM,7o]5p]*\u0011a*E\u0005\u0003'R\u000bq\u0001]1dW\u0006<WM\u0003\u0002Q#&\u0011ak\u0016\u0002\u000b\u000bb\u0004(/Z:tS>t'BA*U!\tIFL\u0004\u0002[7B\u0011AhI\u0005\u0003\u0007\u000eJ!!\u00180\u0003\rM#(/\u001b8h\u0015\t\u00195%\u0003\u0002a5\u0005Y!/Z9vKN$h*Y7f\u0003)\u0019HO]3b[:\u000bW.Z\u0001\u0006G2|7m[\u000b\u0002IB\u0011QM[\u0007\u0002M*\u0011q\r[\u0001\u0005kRLGN\u0003\u0002j#\u000591m\\7n_:\u001c\u0018BA6g\u0005\u0015\u0019En\\2l\u0003\u0019\u0019Gn\\2lA\u0005!a.\u001a=u+\u0005y\u0007C\u00019s\u001b\u0005\t(B\u0001\bR\u0013\t\u0019\u0018O\u0001\u0004BGRLwN\\\u0001\u0006]\u0016DH\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f]D\u0018P_>}{B!\u0011\u0004\u0001\u000f+\u0011\u0015i#\u00021\u00010\u0011\u00151$\u00021\u00018\u0011\u0015A%\u00021\u0001J\u0011\u0015\t'\u00021\u0001Y\u0011\u0015\u0011'\u00021\u0001e\u0011\u0015i'\u00021\u0001p\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\t\u0005\u0005\u00111\u0003\t\u0007\u0003\u0007\tI!!\u0004\u000e\u0005\u0005\u0015!bAA\u0004Q\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\n\t\u0005-\u0011Q\u0001\u0002\u000b-\u0006d\u0017\u000eZ1uS>t\u0007c\u0001\u0012\u0002\u0010%\u0019\u0011\u0011C\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0007!.\u0001\r!!\u0006\u0011\t\u0005]\u0011\u0011D\u0007\u0002)&\u0019\u00111\u0004+\u0003\u000fM+7o]5p]\u0002")
public final class GrpcAwaitStreamEndAction<ReqT, RespT>
extends GrpcRequestAction<ReqT, RespT> {
    private final GrpcStatsEngineAdapter grpcStatsEngine;
    private final Function2<Session, Session, Validation<Session>> reconcile;
    private final String streamName;
    private final Clock clock;
    private final Action next;

    @Override
    public GrpcStatsEngineAdapter grpcStatsEngine() {
        return this.grpcStatsEngine;
    }

    public Clock clock() {
        return this.clock;
    }

    public Action next() {
        return this.next;
    }

    public Validation<BoxedUnit> sendRequest(Session session) {
        return ((Validation)super.requestName().apply((Object)session)).flatMap((Function1 & Serializable)streamRequestName -> this.lookupStream(session, $this.streamName).map((Function1 & Serializable)stream -> {
            GrpcAwaitStreamEndAction.$anonfun$sendRequest$2(this, streamRequestName, session, stream);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ void $anonfun$sendRequest$2(GrpcAwaitStreamEndAction $this, String streamRequestName$1, Session session$1, GrpcStream stream) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("awaiting end of gRPC stream [requestName={}]", (Object)streamRequestName$1);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        StreamListenerState streamListenerState = stream.listenerState();
        if (ClosedStream$.MODULE$.equals(streamListenerState)) {
            Session session;
            BoxedUnit boxedUnit2;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("gRPC stream is closed, sending to next action [requestName={}]", (Object)streamRequestName$1);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Validation validation = (Validation)$this.reconcile.apply((Object)session$1, (Object)stream.listenerSession());
            if (validation instanceof Success) {
                Success success = (Success)validation;
                Session reconciledSession = (Session)success.value();
                session = $this.removeStream(reconciledSession, $this.streamName);
            } else if (validation instanceof Failure) {
                Failure failure = (Failure)validation;
                String errorMessage = failure.message();
                $this.statsEngine().logCrash(session$1.scenario(), session$1.groups(), streamRequestName$1, "Failed to reconcile session: " + errorMessage);
                session = $this.removeStream(session$1, $this.streamName).markAsFailed();
            } else {
                throw new MatchError((Object)validation);
            }
            Session updatedSession = session;
            $this.next().$bang(updatedSession);
            return;
        }
        stream.requestCallbackOnStreamEnd((Action)$this, session$1);
    }

    public GrpcAwaitStreamEndAction(GrpcStatsEngineAdapter grpcStatsEngine, Function2<Session, Session, Validation<Session>> reconcile, Function1<Session, Validation<String>> streamRequestName, String streamName, Clock clock, Action next) {
        this.grpcStatsEngine = grpcStatsEngine;
        this.reconcile = reconcile;
        this.streamName = streamName;
        this.clock = clock;
        this.next = next;
        super("grpcAwaitStreamEndAction", streamRequestName);
    }
}

