/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.grpc.engine;

import io.gatling.grpc.protocol.CustomCertificateTrustManager;
import io.gatling.grpc.protocol.GrpcProtocol;
import io.gatling.grpc.protocol.InsecureTrustManager$;
import io.gatling.grpc.protocol.NegotiationType;
import io.gatling.grpc.protocol.StandardTrustManager$;
import io.gatling.grpc.protocol.TrustManagerType;
import io.gatling.grpc.protocol.UseTransportSecurity;
import io.grpc.netty.GrpcSslContexts;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.util.Using;
import scala.util.Using$;

public final class GrpcSslContextSupport$ {
    public static final GrpcSslContextSupport$ MODULE$ = new GrpcSslContextSupport$();

    public Option<SslContextBuilder> io$gatling$grpc$engine$GrpcSslContextSupport$$newSslContextBuilder(GrpcProtocol protocol) {
        NegotiationType negotiationType = protocol.enginePart().negotiationType();
        if (negotiationType instanceof UseTransportSecurity) {
            UseTransportSecurity useTransportSecurity = (UseTransportSecurity)negotiationType;
            TrustManagerType trustManagerType = useTransportSecurity.trustManager();
            SslContextBuilder builder = GrpcSslContexts.forClient();
            TrustManagerType trustManagerType2 = trustManagerType;
            if (StandardTrustManager$.MODULE$.equals(trustManagerType2)) {
                return new Some((Object)builder);
            }
            if (InsecureTrustManager$.MODULE$.equals(trustManagerType2)) {
                return new Some((Object)builder.trustManager(InsecureTrustManagerFactory.INSTANCE));
            }
            if (trustManagerType2 instanceof CustomCertificateTrustManager) {
                CustomCertificateTrustManager customCertificateTrustManager = (CustomCertificateTrustManager)trustManagerType2;
                String certificatePath = customCertificateTrustManager.certificatePath();
                return Using$.MODULE$.apply((Function0 & Serializable)() -> Thread.currentThread().getContextClassLoader().getResourceAsStream(certificatePath), (Function1 & Serializable)is -> builder.trustManager(is), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).toOption();
            }
            throw new MatchError((Object)trustManagerType2);
        }
        return None$.MODULE$;
    }

    private GrpcSslContextSupport$() {
    }
}

