/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.grpc.engine;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.grpc.action.builder.GrpcAttributes;
import io.gatling.grpc.check.GrpcMessageResponse;
import io.gatling.grpc.check.GrpcStreamEndResponse;
import io.gatling.grpc.engine.CancelledStream$;
import io.gatling.grpc.engine.ClosedStream$;
import io.gatling.grpc.engine.FromLastMessageReceivedPolicy$;
import io.gatling.grpc.engine.FromLastMessageSentPolicy$;
import io.gatling.grpc.engine.FromStreamStartPolicy$;
import io.gatling.grpc.engine.GrpcEngineClientStreamTracer;
import io.gatling.grpc.engine.GrpcStream$;
import io.gatling.grpc.engine.HalfClosedStream$;
import io.gatling.grpc.engine.MessageResponseTimePolicy;
import io.gatling.grpc.engine.NewStream$;
import io.gatling.grpc.engine.OpenStream$;
import io.gatling.grpc.engine.StreamListenerState;
import io.gatling.grpc.engine.response.GrpcStreamResponseProcessor$;
import io.gatling.grpc.enterprise.GrpcStatsEngineAdapter;
import io.gatling.grpc.protocol.GrpcProtocolRequestPart;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientStreamTracer;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r}w!B*U\u0011\u0003if!B0U\u0011\u0003\u0001\u0007\"B4\u0002\t\u0003A\u0007\"B5\u0002\t\u0003QgABAv\u0003\t\u000bi\u000f\u0003\u0006\u0002T\u0011\u0011)\u001a!C\u0001\u0005\u000fA!Ba\u0005\u0005\u0005#\u0005\u000b\u0011\u0002B\u0005\u0011)\t9\n\u0002BK\u0002\u0013\u0005\u0011\u0011\u0014\u0005\u000b\u0003o#!\u0011#Q\u0001\n\u0005m\u0005BB4\u0005\t\u0003\u0011)\u0002C\u0005\u0003\u001c\u0011\t\t\u0011\"\u0001\u0003\u001e!I!1\u0005\u0003\u0012\u0002\u0013\u0005!Q\u0005\u0005\n\u0005w!\u0011\u0013!C\u0001\u0005{A\u0011B!\u0011\u0005\u0003\u0003%\tEa\u0011\t\u0013\tMC!!A\u0005\u0002\tU\u0003\"\u0003B/\t\u0005\u0005I\u0011\u0001B0\u0011%\u0011\u0019\u0007BA\u0001\n\u0003\u0012)\u0007C\u0005\u0003t\u0011\t\t\u0011\"\u0001\u0003v!I!q\u0010\u0003\u0002\u0002\u0013\u0005#\u0011\u0011\u0005\n\u0005\u000b#\u0011\u0011!C!\u0005\u000fC\u0011B!#\u0005\u0003\u0003%\tEa#\t\u0013\t5E!!A\u0005B\t=u!CBR\u0003\u0005\u0005\t\u0012ABS\r%\tY/AA\u0001\u0012\u0003\u00199\u000b\u0003\u0004h/\u0011\u00051Q\u0018\u0005\n\u0005\u0013;\u0012\u0011!C#\u0005\u0017C\u0001\"[\f\u0002\u0002\u0013\u00055q\u0018\u0005\n\u0007\u000b<\u0012\u0011!CA\u0007\u000fD\u0011b!6\u0018\u0003\u0003%Iaa6\u0007\r\u0005E\u0012AAA\u001a\u0011)\t9%\bB\u0001B\u0003%\u0011\u0011\n\u0005\u000b\u00033j\"\u0011!Q\u0001\n\u0005m\u0003BCA4;\t\u0005\t\u0015!\u0003\u0002j!Q\u0011QO\u000f\u0003\u0002\u0003\u0006I!a\u001e\t\u0015\u00055UD!A!\u0002\u0013\t9\b\u0003\u0006\u0002\u0010v\u0011\t\u0011)A\u0005\u0003#C1\"a&\u001e\u0005\u0003\u0007I\u0011A\u0001\u0002\u001a\"Y\u0011\u0011V\u000f\u0003\u0002\u0004%\t!AAV\u0011)\t9,\bB\u0001B\u0003&\u00111\u0014\u0005\bOv!\t!AA]\u0011)\ti-\ba\u0001\n\u0003\t\u0011q\u001a\u0005\u000b\u0003/l\u0002\u0019!C\u0001\u0003\u0005e\u0007\u0002CAo;\u0001\u0006K!!5\t\u0015\u0005}W\u00041A\u0005\u0002\u0005\t\t\u000f\u0003\u0006\u0003\u0014v\u0001\r\u0011\"\u0001\u0002\u0005+C\u0001B!'\u001eA\u0003&\u00111\u001d\u0005\n\u00057k\u0002\u0019!C\u0005\u0005;C\u0011B!*\u001e\u0001\u0004%IAa*\t\u0011\t-V\u0004)Q\u0005\u0005?C\u0011B!,\u001e\u0005\u0004%IAa,\t\u0011\tuV\u0004)A\u0005\u0005cCABa0\u001e\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0005\u0003DAB!3\u001e\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0005\u0017D1Ba4\u001e\u0001\u0004\u0005\t\u0015)\u0003\u0003D\"I!\u0011[\u000fA\u0002\u0013%!Q\u0014\u0005\n\u0005'l\u0002\u0019!C\u0005\u0005+D\u0001B!7\u001eA\u0003&!q\u0014\u0005\n\u00057l\"\u0019!C\u0005\u0005_C\u0001B!8\u001eA\u0003%!\u0011\u0017\u0005\n\u0005?l\u0002\u0019!C\u0005\u0005;C\u0011B!9\u001e\u0001\u0004%IAa9\t\u0011\t\u001dX\u0004)Q\u0005\u0005?C!B!;\u001e\u0005\u0004%\t!\u0001Bv\u0011!\u0011Y0\bQ\u0001\n\t5\bb\u0002B\u007f;\u0011\u0005#q \u0005\b\u0007\u0007iB\u0011IB\u0003\u0011\u001d\u00199!\bC!\u0007\u0013Aqaa\u0004\u001e\t\u0003\u001a\t\u0002C\u0004\u0004\"u!Iaa\t\t\u000f\r%R\u0004\"\u0003\u0004,!91qF\u000f\u0005\n\rE\u0002bBB\u001c;\u0011%1\u0011\b\u0004\u0005?R\u0013Q\u000f\u0003\u0006\u0002\u0004!\u0013\t\u0011)A\u0005\u0003\u000bA!\"a\u000bI\u0005\u0003\u0005\u000b\u0011BA\u0017\u0011\u00199\u0007\n\"\u0001\u0004B!91\u0011\n%\u0005\u0002\u0005=\u0007bBB&\u0011\u0012\u0005\u0011\u0011\u0014\u0005\b\u0007\u001bBE\u0011AB(\u0011\u001d\u0019\u0019\u0006\u0013C\u0001\u0007\u000bAqa!\u0016I\t\u0003\u00199\u0006C\u0004\u0004^!#\ta!\u0002\t\u000f\r}\u0003\n\"\u0001\u0004b\u0005QqI\u001d9d'R\u0014X-Y7\u000b\u0005U3\u0016AB3oO&tWM\u0003\u0002X1\u0006!qM\u001d9d\u0015\tI&,A\u0004hCRd\u0017N\\4\u000b\u0003m\u000b!![8\u0004\u0001A\u0011a,A\u0007\u0002)\nQqI\u001d9d'R\u0014X-Y7\u0014\u0005\u0005\t\u0007C\u00012f\u001b\u0005\u0019'\"\u00013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001c'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;\u0006)\u0011\r\u001d9msV)1n!\u001b\u0004nQ)Bna\u001c\u0004\u0000\r\r5QQBD\u0007#\u001bYj!(\u0004 \u000e\u0005\u0006cA7si6\taN\u0003\u0002pa\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005ED\u0016aB2p[6|gn]\u0005\u0003g:\u0014!BV1mS\u0012\fG/[8o!\u0019q\u0006ja\u001a\u0004lU)a/a\u0005\u0002(M\u0019\u0001*Y<\u0011\u0005a|X\"A=\u000b\u0005i\\\u0018\u0001D:dC2\fGn\\4hS:<'B\u0001?~\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001@\u0002\u0007\r|W.C\u0002\u0002\u0002e\u0014Qb\u0015;sS\u000e$Hj\\4hS:<\u0017\u0001B2bY2\u0004\u0002\"a\u0002\u0002\f\u0005=\u0011QE\u0007\u0003\u0003\u0013Q!a\u0016.\n\t\u00055\u0011\u0011\u0002\u0002\u000b\u00072LWM\u001c;DC2d\u0007\u0003BA\t\u0003'a\u0001\u0001B\u0004\u0002\u0016!\u0013\r!a\u0006\u0003\tI+\u0017\u000fV\t\u0005\u00033\ty\u0002E\u0002c\u00037I1!!\bd\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AYA\u0011\u0013\r\t\u0019c\u0019\u0002\u0004\u0003:L\b\u0003BA\t\u0003O!q!!\u000bI\u0005\u0004\t9BA\u0003SKN\u0004H+\u0001\u0005mSN$XM\\3s!\u0015\ty#HA\u0013\u001d\tq\u0006A\u0001\u0005MSN$XM\\3s+\u0011\t)$!\u0012\u0014\tu\t9d\u001e\t\u0007\u0003s\ty$a\u0011\u000f\t\u0005\u001d\u00111H\u0005\u0005\u0003{\tI!\u0001\u0006DY&,g\u000e^\"bY2LA!!\r\u0002B)!\u0011QHA\u0005!\u0011\t\t\"!\u0012\u0005\u000f\u0005%RD1\u0001\u0002\u0018\u0005qqM\u001d9d\u0003R$(/\u001b2vi\u0016\u001c\bCBA&\u0003+\n\u0019%\u0004\u0002\u0002N)!\u0011qJA)\u0003\u001d\u0011W/\u001b7eKJT1!a\u0015W\u0003\u0019\t7\r^5p]&!\u0011qKA'\u000599%\u000f]2BiR\u0014\u0018NY;uKN\fqb\u001a:qGN#\u0018\r^:F]\u001eLg.\u001a\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011\r,\u0002\u0015\u0015tG/\u001a:qe&\u001cX-\u0003\u0003\u0002f\u0005}#AF$sa\u000e\u001cF/\u0019;t\u000b:<\u0017N\\3BI\u0006\u0004H/\u001a:\u0002\u000b\rdwnY6\u0011\t\u0005-\u0014\u0011O\u0007\u0003\u0003[R1!a\u001cq\u0003\u0011)H/\u001b7\n\t\u0005M\u0014Q\u000e\u0002\u0006\u00072|7m[\u0001\u0012gR\u0014X-Y7SKF,Xm\u001d;OC6,\u0007\u0003BA=\u0003\u000fsA!a\u001f\u0002\u0004B\u0019\u0011QP2\u000e\u0005\u0005}$bAAA9\u00061AH]8pizJ1!!\"d\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011RAF\u0005\u0019\u0019FO]5oO*\u0019\u0011QQ2\u0002%5,7o]1hKJ+\u0017/^3ti:\u000bW.Z\u0001\u001a[\u0016\u001c8/Y4f%\u0016\u001c\bo\u001c8tKRKW.\u001a)pY&\u001c\u0017\u0010E\u0002_\u0003'K1!!&U\u0005eiUm]:bO\u0016\u0014Vm\u001d9p]N,G+[7f!>d\u0017nY=\u0002\u000fM,7o]5p]V\u0011\u00111\u0014\t\u0005\u0003;\u000b)+\u0004\u0002\u0002 *!\u0011qSAQ\u0015\r\t\u0019\u000bW\u0001\u0005G>\u0014X-\u0003\u0003\u0002(\u0006}%aB*fgNLwN\\\u0001\fg\u0016\u001c8/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002.\u0006M\u0006c\u00012\u00020&\u0019\u0011\u0011W2\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003k+\u0013\u0011!a\u0001\u00037\u000b1\u0001\u001f\u00132\u0003!\u0019Xm]:j_:\u0004C\u0003EA^\u0003\u007f\u000b\t-a1\u0002F\u0006\u001d\u0017\u0011ZAf!\u0015\ti,HA\"\u001b\u0005\t\u0001bBA$O\u0001\u0007\u0011\u0011\n\u0005\b\u00033:\u0003\u0019AA.\u0011\u001d\t9g\na\u0001\u0003SBq!!\u001e(\u0001\u0004\t9\bC\u0004\u0002\u000e\u001e\u0002\r!a\u001e\t\u000f\u0005=u\u00051\u0001\u0002\u0012\"9\u0011qS\u0014A\u0002\u0005m\u0015!B:uCR,WCAAi!\rq\u00161[\u0005\u0004\u0003+$&aE*ue\u0016\fW\u000eT5ti\u0016tWM]*uCR,\u0017!C:uCR,w\fJ3r)\u0011\ti+a7\t\u0013\u0005U\u0016&!AA\u0002\u0005E\u0017AB:uCR,\u0007%A\ndC2d'-Y2l\u001f:\u001cFO]3b[\u0016sG-\u0006\u0002\u0002dB)!-!:\u0002j&\u0019\u0011q]2\u0003\r=\u0003H/[8o!\r\ti\f\u0002\u0002\t\u0007\u0006dGNY1dWN1A!YAx\u0003k\u00042AYAy\u0013\r\t\u0019p\u0019\u0002\b!J|G-^2u!\u0011\t9P!\u0001\u000f\t\u0005e\u0018Q \b\u0005\u0003{\nY0C\u0001e\u0013\r\typY\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019A!\u0002\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u0005}8-\u0006\u0002\u0003\nA!!1\u0002B\b\u001b\t\u0011iA\u0003\u0003\u0002T\u0005\u0005\u0016\u0002\u0002B\t\u0005\u001b\u0011a!Q2uS>t\u0017aB1di&|g\u000e\t\u000b\u0007\u0003S\u00149B!\u0007\t\u000f\u0005M\u0013\u00021\u0001\u0003\n!9\u0011qS\u0005A\u0002\u0005m\u0015\u0001B2paf$b!!;\u0003 \t\u0005\u0002\"CA*\u0015A\u0005\t\u0019\u0001B\u0005\u0011%\t9J\u0003I\u0001\u0002\u0004\tY*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u001d\"\u0006\u0002B\u0005\u0005SY#Aa\u000b\u0011\t\t5\"qG\u0007\u0003\u0005_QAA!\r\u00034\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005k\u0019\u0017AC1o]>$\u0018\r^5p]&!!\u0011\bB\u0018\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yD\u000b\u0003\u0002\u001c\n%\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003FA!!q\tB)\u001b\t\u0011IE\u0003\u0003\u0003L\t5\u0013\u0001\u00027b]\u001eT!Aa\u0014\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\u0013I%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003XA\u0019!M!\u0017\n\u0007\tm3MA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002 \t\u0005\u0004\"CA[\u001f\u0005\u0005\t\u0019\u0001B,\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B4!\u0019\u0011IGa\u001c\u0002 5\u0011!1\u000e\u0006\u0004\u0005[\u001a\u0017AC2pY2,7\r^5p]&!!\u0011\u000fB6\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t]$Q\u0010\t\u0004E\ne\u0014b\u0001B>G\n9!i\\8mK\u0006t\u0007\"CA[#\u0005\u0005\t\u0019AA\u0010\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\t\u0015#1\u0011\u0005\n\u0003k\u0013\u0012\u0011!a\u0001\u0005/\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005/\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u000b\na!Z9vC2\u001cH\u0003\u0002B<\u0005#C\u0011\"!.\u0016\u0003\u0003\u0005\r!a\b\u0002/\r\fG\u000e\u001c2bG.|en\u0015;sK\u0006lWI\u001c3`I\u0015\fH\u0003BAW\u0005/C\u0011\"!.-\u0003\u0003\u0005\r!a9\u0002)\r\fG\u000e\u001c2bG.|en\u0015;sK\u0006lWI\u001c3!\u00039\u0019H/\u0019:u)&lWm\u001d;b[B,\"Aa(\u0011\u0007\t\u0014\t+C\u0002\u0003$\u000e\u0014A\u0001T8oO\u0006\u00112\u000f^1siRKW.Z:uC6\u0004x\fJ3r)\u0011\tiK!+\t\u0013\u0005Uv&!AA\u0002\t}\u0015aD:uCJ$H+[7fgR\fW\u000e\u001d\u0011\u0002#I,\u0017/^3tiRKW.Z:uC6\u00048/\u0006\u0002\u00032B1!1\u0017B]\u0005?k!A!.\u000b\t\t]&1N\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011YL!.\u0003\u000bE+X-^3\u0002%I,\u0017/^3tiRKW.Z:uC6\u00048\u000fI\u0001\bQ\u0016\fG-\u001a:t+\t\u0011\u0019\r\u0005\u0003\u0002\b\t\u0015\u0017\u0002\u0002Bd\u0003\u0013\u0011\u0001\"T3uC\u0012\fG/Y\u0001\fQ\u0016\fG-\u001a:t?\u0012*\u0017\u000f\u0006\u0003\u0002.\n5\u0007\"CA[i\u0005\u0005\t\u0019\u0001Bb\u0003!AW-\u00193feN\u0004\u0013!\u00079sKZLw.^:SKN\u0004xN\\:f)&lWm\u001d;b[B\fQ\u0004\u001d:fm&|Wo\u001d*fgB|gn]3US6,7\u000f^1na~#S-\u001d\u000b\u0005\u0003[\u00139\u000eC\u0005\u00026^\n\t\u00111\u0001\u0003 \u0006Q\u0002O]3wS>,8OU3ta>t7/\u001a+j[\u0016\u001cH/Y7qA\u0005\u0011\"/Z:q_:\u001cX\rV5nKN$\u0018-\u001c9t\u0003M\u0011Xm\u001d9p]N,G+[7fgR\fW\u000e]:!\u00031)g\u000e\u001a+j[\u0016\u001cH/Y7q\u0003A)g\u000e\u001a+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0003\u0002.\n\u0015\b\"CA[y\u0005\u0005\t\u0019\u0001BP\u00035)g\u000e\u001a+j[\u0016\u001cH/Y7qA\u0005iAO]1dKJ4\u0015m\u0019;pef,\"A!<\u0011\t\t=(Q\u001f\b\u0005\u0003\u000f\u0011\t0\u0003\u0003\u0003t\u0006%\u0011AE\"mS\u0016tGo\u0015;sK\u0006lGK]1dKJLAAa>\u0003z\n9a)Y2u_JL(\u0002\u0002Bz\u0003\u0013\ta\u0002\u001e:bG\u0016\u0014h)Y2u_JL\b%A\u0005p]\"+\u0017\rZ3sgR!\u0011QVB\u0001\u0011\u001d\u0011y\f\u0011a\u0001\u0005\u0007\fqa\u001c8SK\u0006$\u0017\u0010\u0006\u0002\u0002.\u0006IqN\\'fgN\fw-\u001a\u000b\u0005\u0003[\u001bY\u0001C\u0004\u0004\u000e\t\u0003\r!a\u0011\u0002\u000f5,7o]1hK\u00069qN\\\"m_N,GCBAW\u0007'\u0019i\u0002C\u0004\u0004\u0016\r\u0003\raa\u0006\u0002\rM$\u0018\r^;t!\u0011\t9a!\u0007\n\t\rm\u0011\u0011\u0002\u0002\u0007'R\fG/^:\t\u000f\r}1\t1\u0001\u0003D\u0006AAO]1jY\u0016\u00148/A\u0007m_\u001e\u001cFO]3b[>\u0003XM\u001c\u000b\u0005\u0003[\u001b)\u0003C\u0004\u0004(\u0011\u0003\rAa(\u0002\u0013QLW.Z:uC6\u0004\u0018A\u00047pO6+7o]1hKN+g\u000e\u001e\u000b\u0005\u0003[\u001bi\u0003C\u0004\u0004(\u0015\u0003\rAa(\u0002%1|w-T3tg\u0006<WMU3dK&4X\r\u001a\u000b\u0007\u0003[\u001b\u0019d!\u000e\t\u000f\r5a\t1\u0001\u0002D!91q\u0005$A\u0002\t}\u0015a\u00047pON#(/Z1n\u00072|7/\u001a3\u0015\u0011\u0005561HB\u001f\u0007\u007fAqa!\u0006H\u0001\u0004\u00199\u0002C\u0004\u0004 \u001d\u0003\rAa1\t\u000f\r\u001dr\t1\u0001\u0003 R111IB#\u0007\u000f\u0002bA\u0018%\u0002\u0010\u0005\u0015\u0002bBA\u0002\u0017\u0002\u0007\u0011Q\u0001\u0005\b\u0003WY\u0005\u0019AA\u0017\u00035a\u0017n\u001d;f]\u0016\u00148\u000b^1uK\u0006yA.[:uK:,'oU3tg&|g.A\u0003ti\u0006\u0014H\u000f\u0006\u0003\u0002.\u000eE\u0003b\u0002B`\u001d\u0002\u0007!1Y\u0001\u0007G\u0006t7-\u001a7\u0002\u0017M,g\u000eZ'fgN\fw-\u001a\u000b\u0005\u0003[\u001bI\u0006C\u0004\u0004\\A\u0003\r!a\u0004\u0002\u000fI,\u0017/^3ti\u0006I\u0001.\u00197g\u00072|7/Z\u0001\u001be\u0016\fX/Z:u\u0007\u0006dGNY1dW>s7\u000b\u001e:fC6,e\u000e\u001a\u000b\u0007\u0003[\u001b\u0019g!\u001a\t\u000f\u0005M#\u000b1\u0001\u0003\n!9\u0011q\u0013*A\u0002\u0005m\u0005\u0003BA\t\u0007S\"q!!\u0006\u0004\u0005\u0004\t9\u0002\u0005\u0003\u0002\u0012\r5DaBA\u0015\u0007\t\u0007\u0011q\u0003\u0005\b\u0007c\u001a\u0001\u0019AB:\u0003Y9'\u000f]2Qe>$xnY8m\u0003R$(/\u001b2vi\u0016\u001c\b\u0003BB;\u0007wj!aa\u001e\u000b\u0007\red+\u0001\u0005qe>$xnY8m\u0013\u0011\u0019iha\u001e\u0003/\u001d\u0013\bo\u0019)s_R|7m\u001c7SKF,Xm\u001d;QCJ$\bbBA$\u0007\u0001\u00071\u0011\u0011\t\u0007\u0003\u0017\n)fa\u001b\t\u000f\u0005e3\u00011\u0001\u0002\\!9\u0011qM\u0002A\u0002\u0005%\u0004bBBE\u0007\u0001\u000711R\u0001\bG\"\fgN\\3m!\u0011\t9a!$\n\t\r=\u0015\u0011\u0002\u0002\b\u0007\"\fgN\\3m\u0011\u001d\u0019\u0019j\u0001a\u0001\u0007+\u000b\u0001#\\3uQ>$G)Z:de&\u0004Ho\u001c:\u0011\u0011\u0005\u001d1qSB4\u0007WJAa!'\u0002\n\t\u0001R*\u001a;i_\u0012$Um]2sSB$xN\u001d\u0005\b\u0003k\u001a\u0001\u0019AA<\u0011\u001d\tii\u0001a\u0001\u0003oBq!a$\u0004\u0001\u0004\t\t\nC\u0004\u0002\u0018\u000e\u0001\r!a'\u0002\u0011\r\u000bG\u000e\u001c2bG.\u00042!!0\u0018'\u001592\u0011VB[!)\u0019Yk!-\u0003\n\u0005m\u0015\u0011^\u0007\u0003\u0007[S1aa,d\u0003\u001d\u0011XO\u001c;j[\u0016LAaa-\u0004.\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\r]61X\u0007\u0003\u0007sS1a\u0017B'\u0013\u0011\u0011\u0019a!/\u0015\u0005\r\u0015FCBAu\u0007\u0003\u001c\u0019\rC\u0004\u0002Ti\u0001\rA!\u0003\t\u000f\u0005]%\u00041\u0001\u0002\u001c\u00069QO\\1qa2LH\u0003BBe\u0007#\u0004RAYAs\u0007\u0017\u0004rAYBg\u0005\u0013\tY*C\u0002\u0004P\u000e\u0014a\u0001V;qY\u0016\u0014\u0004\"CBj7\u0005\u0005\t\u0019AAu\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u00073\u0004BAa\u0012\u0004\\&!1Q\u001cB%\u0005\u0019y%M[3di\u0002")
public final class GrpcStream<ReqT, RespT>
implements StrictLogging {
    private final ClientCall<ReqT, RespT> call;
    private final Listener<RespT> listener;
    private Logger logger;

    public static <ReqT, RespT> Validation<GrpcStream<ReqT, RespT>> apply(GrpcProtocolRequestPart grpcProtocolAttributes, GrpcAttributes<RespT> grpcAttributes, GrpcStatsEngineAdapter grpcStatsEngine, Clock clock, Channel channel, MethodDescriptor<ReqT, RespT> methodDescriptor, String streamRequestName, String messageRequestName, MessageResponseTimePolicy messageResponseTimePolicy, Session session) {
        return GrpcStream$.MODULE$.apply(grpcProtocolAttributes, grpcAttributes, grpcStatsEngine, clock, channel, methodDescriptor, streamRequestName, messageRequestName, messageResponseTimePolicy, session);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public StreamListenerState listenerState() {
        return this.listener.state();
    }

    public Session listenerSession() {
        return this.listener.session();
    }

    public void start(Metadata headers) {
        StreamListenerState streamListenerState = this.listener.state();
        if (NewStream$.MODULE$.equals(streamListenerState)) {
            this.listener.state_$eq(OpenStream$.MODULE$);
            this.call.start(this.listener, headers);
            this.call.request(Integer.MAX_VALUE);
            return;
        }
        throw new IllegalStateException("Cannot start gRPC stream; current state is " + streamListenerState);
    }

    public void cancel() {
        StreamListenerState streamListenerState = this.listener.state();
        if (ClosedStream$.MODULE$.equals(streamListenerState) ? true : CancelledStream$.MODULE$.equals(streamListenerState)) {
            throw new IllegalStateException("Cannot cancel gRPC stream; current state is " + streamListenerState);
        }
        this.listener.state_$eq(CancelledStream$.MODULE$);
        this.call.cancel("gRPC call cancelled from the Gatling gRPC DSL", null);
    }

    public void sendMessage(ReqT request) {
        StreamListenerState streamListenerState = this.listener.state();
        if (OpenStream$.MODULE$.equals(streamListenerState)) {
            this.call.sendMessage(request);
            package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)BoxedUnit.UNIT));
            return;
        }
        throw new IllegalStateException("Cannot send message on gRPC stream; current state is " + streamListenerState);
    }

    public void halfClose() {
        StreamListenerState streamListenerState = this.listener.state();
        if (OpenStream$.MODULE$.equals(streamListenerState)) {
            this.listener.state_$eq(HalfClosedStream$.MODULE$);
            this.call.halfClose();
            return;
        }
        throw new IllegalStateException("Cannot half-close gRPC stream; current state is " + streamListenerState);
    }

    public void requestCallbackOnStreamEnd(Action action, Session session) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("requestCallbackOnStreamEnd [action={}, session={}, state={}]", new Object[]{action, session, this.listener.state()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        StreamListenerState streamListenerState = this.listener.state();
        if (OpenStream$.MODULE$.equals(streamListenerState) ? true : (HalfClosedStream$.MODULE$.equals(streamListenerState) ? true : CancelledStream$.MODULE$.equals(streamListenerState))) {
            this.listener.callbackOnStreamEnd_$eq((Option<Callback>)new Some((Object)new Callback(action, session)));
            return;
        }
        throw new IllegalStateException("Cannot await end of gRPC stream; current state is " + streamListenerState);
    }

    public GrpcStream(ClientCall<ReqT, RespT> call, Listener<RespT> listener) {
        this.call = call;
        this.listener = listener;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }

    public static final class Callback
    implements Product,
    Serializable {
        private final Action action;
        private final Session session;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Action action() {
            return this.action;
        }

        public Session session() {
            return this.session;
        }

        public Callback copy(Action action, Session session) {
            return new Callback(action, session);
        }

        public Action copy$default$1() {
            return this.action();
        }

        public Session copy$default$2() {
            return this.session();
        }

        public String productPrefix() {
            return "Callback";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.action();
                }
                case 1: {
                    return this.session();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Callback;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "action";
                }
                case 1: {
                    return "session";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Callback)) return false;
            boolean bl = true;
            if (!bl) return false;
            Callback callback = (Callback)x$1;
            Action action = this.action();
            Action action2 = callback.action();
            if (action == null) {
                if (action2 != null) {
                    return false;
                }
            } else if (!action.equals(action2)) return false;
            Session session = this.session();
            Session session2 = callback.session();
            if (session == null) {
                if (session2 == null) return true;
                return false;
            } else {
                if (!session.equals(session2)) return false;
                return true;
            }
        }

        public Callback(Action action, Session session) {
            this.action = action;
            this.session = session;
            Product.$init$((Product)this);
        }
    }

    public static final class Listener<RespT>
    extends ClientCall.Listener<RespT>
    implements StrictLogging {
        private final GrpcAttributes<RespT> grpcAttributes;
        private final GrpcStatsEngineAdapter grpcStatsEngine;
        public final Clock io$gatling$grpc$engine$GrpcStream$Listener$$clock;
        private final String streamRequestName;
        private final String messageRequestName;
        private final MessageResponseTimePolicy messageResponseTimePolicy;
        private Session session;
        private StreamListenerState state;
        private Option<Callback> callbackOnStreamEnd;
        private long io$gatling$grpc$engine$GrpcStream$Listener$$startTimestamp;
        private final Queue<Object> io$gatling$grpc$engine$GrpcStream$Listener$$requestTimestamps;
        private Metadata headers;
        private long previousResponseTimestamp;
        private final Queue<Object> io$gatling$grpc$engine$GrpcStream$Listener$$responseTimestamps;
        private long io$gatling$grpc$engine$GrpcStream$Listener$$endTimestamp;
        private final ClientStreamTracer.Factory tracerFactory;
        private Logger logger;

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        public Session session() {
            return this.session;
        }

        public void session_$eq(Session x$1) {
            this.session = x$1;
        }

        public StreamListenerState state() {
            return this.state;
        }

        public void state_$eq(StreamListenerState x$1) {
            this.state = x$1;
        }

        public Option<Callback> callbackOnStreamEnd() {
            return this.callbackOnStreamEnd;
        }

        public void callbackOnStreamEnd_$eq(Option<Callback> x$1) {
            this.callbackOnStreamEnd = x$1;
        }

        private long startTimestamp() {
            return this.io$gatling$grpc$engine$GrpcStream$Listener$$startTimestamp;
        }

        public void io$gatling$grpc$engine$GrpcStream$Listener$$startTimestamp_$eq(long x$1) {
            this.io$gatling$grpc$engine$GrpcStream$Listener$$startTimestamp = x$1;
        }

        public Queue<Object> io$gatling$grpc$engine$GrpcStream$Listener$$requestTimestamps() {
            return this.io$gatling$grpc$engine$GrpcStream$Listener$$requestTimestamps;
        }

        public Metadata headers() {
            return this.headers;
        }

        public void headers_$eq(Metadata x$1) {
            this.headers = x$1;
        }

        private long previousResponseTimestamp() {
            return this.previousResponseTimestamp;
        }

        private void previousResponseTimestamp_$eq(long x$1) {
            this.previousResponseTimestamp = x$1;
        }

        public Queue<Object> io$gatling$grpc$engine$GrpcStream$Listener$$responseTimestamps() {
            return this.io$gatling$grpc$engine$GrpcStream$Listener$$responseTimestamps;
        }

        private long endTimestamp() {
            return this.io$gatling$grpc$engine$GrpcStream$Listener$$endTimestamp;
        }

        public void io$gatling$grpc$engine$GrpcStream$Listener$$endTimestamp_$eq(long x$1) {
            this.io$gatling$grpc$engine$GrpcStream$Listener$$endTimestamp = x$1;
        }

        public ClientStreamTracer.Factory tracerFactory() {
            return this.tracerFactory;
        }

        public void onHeaders(Metadata headers) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("onHeaders [headers={}]", (Object)headers);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.headers_$eq(headers);
        }

        public void onReady() {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("onReady");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }

        public void onMessage(RespT message) {
            BoxedUnit boxedUnit;
            long l;
            try {
                l = BoxesRunTime.unboxToLong((Object)this.io$gatling$grpc$engine$GrpcStream$Listener$$responseTimestamps().dequeue());
            }
            catch (NoSuchElementException e) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("onMessage called while there was no message timestamp to dequeue");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                throw new IllegalStateException("GrpcStream.Listener.onMessage called while there was no message timestamp to dequeue", e);
            }
            long timestamp = l;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("onMessage [timestamp={}, message={}]", new Object[]{BoxesRunTime.boxToLong((long)timestamp), message});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.logMessageReceived(message, timestamp);
            this.previousResponseTimestamp_$eq(timestamp);
        }

        public void onClose(Status status, Metadata trailers) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("onClose [timestamp={}, status={}, trailers={}]", new Object[]{BoxesRunTime.boxToLong((long)this.endTimestamp()), status, trailers});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.state_$eq(ClosedStream$.MODULE$);
            if (this.endTimestamp() < 0L) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("onClose called while endTimestamp had not been registered");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                throw new IllegalStateException("GrpcStreamListener.onClose called while endTimestamp had not been registered");
            }
            this.logStreamClosed(status, trailers, this.endTimestamp());
            this.callbackOnStreamEnd().foreach((Function1 & Serializable)cb -> {
                Listener.$anonfun$onClose$1(cb);
                return BoxedUnit.UNIT;
            });
        }

        public void io$gatling$grpc$engine$GrpcStream$Listener$$logStreamOpen(long timestamp) {
            GrpcStreamResponseProcessor$.MODULE$.logRequest(this.grpcStatsEngine, this.session(), this.streamRequestName, timestamp);
        }

        public void io$gatling$grpc$engine$GrpcStream$Listener$$logMessageSent(long timestamp) {
            GrpcStreamResponseProcessor$.MODULE$.logRequest(this.grpcStatsEngine, this.session(), this.messageRequestName, timestamp);
        }

        private void logMessageReceived(RespT message, long timestamp) {
            long l;
            MessageResponseTimePolicy messageResponseTimePolicy = this.messageResponseTimePolicy;
            if (FromStreamStartPolicy$.MODULE$.equals(messageResponseTimePolicy)) {
                l = this.startTimestamp();
            } else if (FromLastMessageSentPolicy$.MODULE$.equals(messageResponseTimePolicy)) {
                l = BoxesRunTime.unboxToLong((Object)this.io$gatling$grpc$engine$GrpcStream$Listener$$requestTimestamps().lastOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.startTimestamp()));
            } else if (FromLastMessageReceivedPolicy$.MODULE$.equals(messageResponseTimePolicy)) {
                l = this.previousResponseTimestamp() > 0L ? this.previousResponseTimestamp() : this.startTimestamp();
            } else {
                throw new MatchError((Object)messageResponseTimePolicy);
            }
            long initialTimestamp = l;
            this.session_$eq(GrpcStreamResponseProcessor$.MODULE$.logMessage(this.grpcAttributes, this.grpcStatsEngine, new GrpcMessageResponse<RespT>(message), this.messageRequestName, this.session(), initialTimestamp, timestamp));
        }

        private void logStreamClosed(Status status, Metadata trailers, long timestamp) {
            this.session_$eq(GrpcStreamResponseProcessor$.MODULE$.logStreamEnd(this.grpcAttributes, this.grpcStatsEngine, new GrpcStreamEndResponse(this.headers(), status, trailers), this.session(), this.streamRequestName, this.startTimestamp(), timestamp));
        }

        public static final /* synthetic */ void $anonfun$onClose$1(Callback cb) {
            cb.action().$bang(cb.session());
        }

        public Listener(GrpcAttributes<RespT> grpcAttributes, GrpcStatsEngineAdapter grpcStatsEngine, Clock clock, String streamRequestName, String messageRequestName, MessageResponseTimePolicy messageResponseTimePolicy, Session session) {
            this.grpcAttributes = grpcAttributes;
            this.grpcStatsEngine = grpcStatsEngine;
            this.io$gatling$grpc$engine$GrpcStream$Listener$$clock = clock;
            this.streamRequestName = streamRequestName;
            this.messageRequestName = messageRequestName;
            this.messageResponseTimePolicy = messageResponseTimePolicy;
            this.session = session;
            StrictLogging.$init$((StrictLogging)this);
            this.state = NewStream$.MODULE$;
            this.callbackOnStreamEnd = None$.MODULE$;
            this.io$gatling$grpc$engine$GrpcStream$Listener$$startTimestamp = -1L;
            this.io$gatling$grpc$engine$GrpcStream$Listener$$requestTimestamps = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
            this.previousResponseTimestamp = -1L;
            this.io$gatling$grpc$engine$GrpcStream$Listener$$responseTimestamps = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
            this.io$gatling$grpc$engine$GrpcStream$Listener$$endTimestamp = -1L;
            this.tracerFactory = new ClientStreamTracer.Factory(this){
                private final /* synthetic */ Listener $outer;

                public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
                    return new GrpcEngineClientStreamTracer(this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$clock, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)timestamp -> {
                        $this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$startTimestamp_$eq(timestamp);
                        $this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$logStreamOpen(timestamp);
                    }, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)timestamp -> {
                        $this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$requestTimestamps().enqueue((Object)BoxesRunTime.boxToLong((long)timestamp));
                        $this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$logMessageSent(timestamp);
                    }, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)timestamp -> $this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$responseTimestamps().enqueue((Object)BoxesRunTime.boxToLong((long)timestamp)), (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)x$2 -> $this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$endTimestamp_$eq(x$2));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$newClientStreamTracer$1(io.gatling.grpc.engine.GrpcStream$Listener$$anon$1 long ), $anonfun$newClientStreamTracer$2(io.gatling.grpc.engine.GrpcStream$Listener$$anon$1 long ), $anonfun$newClientStreamTracer$3(io.gatling.grpc.engine.GrpcStream$Listener$$anon$1 long ), $anonfun$newClientStreamTracer$4(io.gatling.grpc.engine.GrpcStream$Listener$$anon$1 long )}, serializedLambda);
                }
            };
            Statics.releaseFence();
        }
    }
}

