/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.grpc.action;

import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.grpc.action.GrpcRequestAction;
import io.gatling.grpc.engine.ClosedStream$;
import io.gatling.grpc.engine.GrpcStream;
import io.gatling.grpc.engine.StreamListenerState;
import io.gatling.grpc.enterprise.GrpcStatsEngineAdapter;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001\u0002\u0007\u000e\u0005YA\u0001\"\f\u0001\u0003\u0006\u0004%\tE\f\u0005\tk\u0001\u0011\t\u0011)A\u0005_!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0005Q\u0001\t\u0005\t\u0015!\u0003RW\"AQ\u000e\u0001B\u0001B\u0003%1\r\u0003\u0005o\u0001\t\u0015\r\u0011\"\u0011p\u0011!1\bA!A!\u0002\u0013\u0001\b\u0002C<\u0001\u0005\u000b\u0007I\u0011\t=\t\u0011y\u0004!\u0011!Q\u0001\neDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\t\u0001\u0011\u0005\u00131\u0003\u0002\u0019\u000fJ\u00048-Q<bSR\u001cFO]3b[\u0016sG-Q2uS>t'B\u0001\b\u0010\u0003\u0019\t7\r^5p]*\u0011\u0001#E\u0001\u0005OJ\u00048M\u0003\u0002\u0013'\u00059q-\u0019;mS:<'\"\u0001\u000b\u0002\u0005%|7\u0001A\u000b\u0004/yY3C\u0001\u0001\u0019!\u0011I\"\u0004\b\u0016\u000e\u00035I!aG\u0007\u0003#\u001d\u0013\bo\u0019*fcV,7\u000f^!di&|g\u000e\u0005\u0002\u001e=1\u0001A!B\u0010\u0001\u0005\u0004\u0001#\u0001\u0002*fcR\u000b\"!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\u000f9{G\u000f[5oOB\u0011!\u0005K\u0005\u0003S\r\u00121!\u00118z!\ti2\u0006B\u0003-\u0001\t\u0007\u0001EA\u0003SKN\u0004H+A\bheB\u001c7\u000b^1ug\u0016sw-\u001b8f+\u0005y\u0003C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0010\u0003))g\u000e^3saJL7/Z\u0005\u0003iE\u0012ac\u0012:qGN#\u0018\r^:F]\u001eLg.Z!eCB$XM]\u0001\u0011OJ\u00048m\u0015;biN,enZ5oK\u0002\n\u0011A\u001a\t\u0006EaR\u0004\tS\u0005\u0003s\r\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\tmrDDK\u0007\u0002y)\u0011QhD\u0001\u0007K:<\u0017N\\3\n\u0005}b$AC$sa\u000e\u001cFO]3b[B\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\bg\u0016\u001c8/[8o\u0015\t)\u0015#\u0001\u0003d_J,\u0017BA$C\u0005\u001d\u0019Vm]:j_:\u00042!\u0013(A\u001b\u0005Q%BA&M\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u001bF\tqaY8n[>t7/\u0003\u0002P\u0015\nQa+\u00197jI\u0006$\u0018n\u001c8\u0002#M$(/Z1n%\u0016\fX/Z:u\u001d\u0006lW\rE\u0002SA\u000et!a\u00150\u000f\u0005QkfBA+]\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002Z+\u00051AH]8pizJ\u0011\u0001F\u0005\u0003%MI!!R\t\n\u0005\r#\u0015BA0C\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u00192\u0003\u0015\u0015C\bO]3tg&|gN\u0003\u0002`\u0005B\u0011A\r\u001b\b\u0003K\u001a\u0004\"aV\u0012\n\u0005\u001d\u001c\u0013A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!aZ\u0012\n\u00051T\u0012a\u0003:fcV,7\u000f\u001e(b[\u0016\f!b\u001d;sK\u0006lg*Y7f\u0003\u0015\u0019Gn\\2l+\u0005\u0001\bCA9u\u001b\u0005\u0011(BA:M\u0003\u0011)H/\u001b7\n\u0005U\u0014(!B\"m_\u000e\\\u0017AB2m_\u000e\\\u0007%\u0001\u0003oKb$X#A=\u0011\u0005idX\"A>\u000b\u00059!\u0015BA?|\u0005\u0019\t5\r^5p]\u0006)a.\u001a=uA\u00051A(\u001b8jiz\"b\"a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty\u0001\u0005\u0003\u001a\u0001qQ\u0003\"B\u0017\u000b\u0001\u0004y\u0003\"\u0002\u001c\u000b\u0001\u00049\u0004\"\u0002)\u000b\u0001\u0004\t\u0006\"B7\u000b\u0001\u0004\u0019\u0007\"\u00028\u000b\u0001\u0004\u0001\b\"B<\u000b\u0001\u0004I\u0018aC:f]\u0012\u0014V-];fgR$B!!\u0006\u0002\u001eA!\u0011JTA\f!\r\u0011\u0013\u0011D\u0005\u0004\u00037\u0019#\u0001B+oSRDQaQ\u0006A\u0002\u0001\u0003")
public final class GrpcAwaitStreamEndAction<ReqT, RespT>
extends GrpcRequestAction<ReqT, RespT> {
    private final GrpcStatsEngineAdapter grpcStatsEngine;
    private final Function2<GrpcStream<ReqT, RespT>, Session, Validation<Session>> f;
    private final String streamName;
    private final Clock clock;
    private final Action next;

    @Override
    public GrpcStatsEngineAdapter grpcStatsEngine() {
        return this.grpcStatsEngine;
    }

    public Clock clock() {
        return this.clock;
    }

    public Action next() {
        return this.next;
    }

    public Validation<BoxedUnit> sendRequest(Session session) {
        return ((Validation)super.requestName().apply((Object)session)).flatMap((Function1 & Serializable)streamRequestName -> this.lookupStream(session, $this.streamName).map((Function1 & Serializable)stream -> {
            GrpcAwaitStreamEndAction.$anonfun$sendRequest$2(this, streamRequestName, session, stream);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ void $anonfun$sendRequest$2(GrpcAwaitStreamEndAction $this, String streamRequestName$1, Session session$1, GrpcStream stream) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("awaiting end of gRPC stream [requestName={}]", (Object)streamRequestName$1);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        StreamListenerState streamListenerState = stream.listenerState();
        if (ClosedStream$.MODULE$.equals(streamListenerState)) {
            Session session;
            BoxedUnit boxedUnit2;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("gRPC stream is closed, sending to next action [requestName={}]", (Object)streamRequestName$1);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Validation validation = (Validation)$this.f.apply((Object)stream, (Object)session$1);
            if (validation instanceof Success) {
                Success success = (Success)validation;
                Session reconciledSession = (Session)success.value();
                session = $this.removeStream(reconciledSession, $this.streamName);
            } else if (validation instanceof Failure) {
                Failure failure = (Failure)validation;
                String errorMessage = failure.message();
                $this.statsEngine().logRequestCrash(session$1.scenario(), session$1.groups(), streamRequestName$1, "Failed to reconcile session: " + errorMessage);
                session = $this.removeStream(session$1, $this.streamName).markAsFailed();
            } else {
                throw new MatchError((Object)validation);
            }
            Session updatedSession = session;
            $this.next().$bang(updatedSession);
            return;
        }
        stream.requestCallbackOnStreamEnd((Action)$this, session$1);
    }

    public GrpcAwaitStreamEndAction(GrpcStatsEngineAdapter grpcStatsEngine, Function2<GrpcStream<ReqT, RespT>, Session, Validation<Session>> f, Function1<Session, Validation<String>> streamRequestName, String streamName, Clock clock, Action next) {
        this.grpcStatsEngine = grpcStatsEngine;
        this.f = f;
        this.streamName = streamName;
        this.clock = clock;
        this.next = next;
        super("grpcAwaitStreamEndAction", streamRequestName);
    }
}

