/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.grpc.engine;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.grpc.Attributes;
import io.grpc.ClientStreamTracer;
import io.grpc.Metadata;
import io.grpc.Status;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001\u0002\u000b\u0016\u0005yA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\to\u0001\u0011\t\u0011)A\u0005q!AA\t\u0001B\u0001B\u0003%\u0001\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u00039\u0011!1\u0005A!A!\u0002\u0013A\u0004\"B$\u0001\t\u0003A\u0005\"\u0002)\u0001\t\u0003\n\u0006\"\u0002/\u0001\t\u0003j\u0006\"B2\u0001\t\u0003\"\u0007\"B4\u0001\t\u0003B\u0007\"\u00026\u0001\t\u0003Z\u0007\"B9\u0001\t\u0003\u0012\b\"B:\u0001\t\u0003\u0012\b\"\u0002;\u0001\t\u0003*\b\"B<\u0001\t\u0003B\b\"\u0002>\u0001\t\u0003Z\bBB@\u0001\t\u0003\n\t\u0001C\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010\tarI\u001d9d\u000b:<\u0017N\\3DY&,g\u000e^*ue\u0016\fW\u000e\u0016:bG\u0016\u0014(B\u0001\f\u0018\u0003\u0019)gnZ5oK*\u0011\u0001$G\u0001\u0005OJ\u00048M\u0003\u0002\u001b7\u00059q-\u0019;mS:<'\"\u0001\u000f\u0002\u0005%|7\u0001A\n\u0004\u0001}!\u0003C\u0001\u0011#\u001b\u0005\t#B\u0001\r\u001c\u0013\t\u0019\u0013E\u0001\nDY&,g\u000e^*ue\u0016\fW\u000e\u0016:bG\u0016\u0014\bCA\u0013-\u001b\u00051#BA\u0014)\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tI#&\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0013aA2p[&\u0011QF\n\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\u000b\rdwnY6\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014\u0001B;uS2T!\u0001N\r\u0002\u000f\r|W.\\8og&\u0011a'\r\u0002\u0006\u00072|7m[\u0001\u000e_:\u001cFO]3b[N#\u0018M\u001d;\u0011\tebd(Q\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\tIa)\u001e8di&|g.\r\t\u0003s}J!\u0001\u0011\u001e\u0003\t1{gn\u001a\t\u0003s\tK!a\u0011\u001e\u0003\tUs\u0017\u000e^\u0001\u000f_:\u0014V-];fgR\u001cF/\u0019:u\u00035ygNU3ta>t7/Z#oI\u0006YqN\\*ue\u0016\fW.\u00128e\u0003\u0019a\u0014N\\5u}Q1\u0011j\u0013'N\u001d>\u0003\"A\u0013\u0001\u000e\u0003UAQA\f\u0004A\u0002=BQa\u000e\u0004A\u0002aBQ\u0001\u0012\u0004A\u0002aBQ!\u0012\u0004A\u0002aBQA\u0012\u0004A\u0002a\nQb\u001d;sK\u0006l7I]3bi\u0016$GcA!S/\")1k\u0002a\u0001)\u0006qAO]1ogB|'\u000f^!uiJ\u001c\bC\u0001\u0011V\u0013\t1\u0016E\u0001\u0006BiR\u0014\u0018NY;uKNDQ\u0001W\u0004A\u0002e\u000bq\u0001[3bI\u0016\u00148\u000f\u0005\u0002!5&\u00111,\t\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006yq.\u001e;c_VtG-T3tg\u0006<W\r\u0006\u0002B=\")q\f\u0003a\u0001A\u0006)1/Z9O_B\u0011\u0011(Y\u0005\u0003Ej\u00121!\u00138u\u0003ayW\u000f\u001e2pk:$WK\\2p[B\u0014Xm]:fINK'0\u001a\u000b\u0003\u0003\u0016DQAZ\u0005A\u0002y\nQAY=uKN\f\u0001c\\;uE>,h\u000eZ,je\u0016\u001c\u0016N_3\u0015\u0005\u0005K\u0007\"\u00024\u000b\u0001\u0004q\u0014aE8vi\n|WO\u001c3NKN\u001c\u0018mZ3TK:$H\u0003B!m[>DQaX\u0006A\u0002\u0001DQA\\\u0006A\u0002y\n\u0001c\u001c9uS>t\u0017\r\\,je\u0016\u001c\u0016N_3\t\u000bA\\\u0001\u0019\u0001 \u00021=\u0004H/[8oC2,fnY8naJ,7o]3e'&TX-A\bpkR\u0014w.\u001e8e\u0011\u0016\fG-\u001a:t)\u0005\t\u0015AD5oE>,h\u000e\u001a%fC\u0012,'o]\u0001\u000fS:\u0014w.\u001e8e\u001b\u0016\u001c8/Y4f)\t\te\u000fC\u0003`\u001d\u0001\u0007\u0001-A\bj]\n|WO\u001c3XSJ,7+\u001b>f)\t\t\u0015\u0010C\u0003g\u001f\u0001\u0007a(\u0001\nj]\n|WO\u001c3NKN\u001c\u0018mZ3SK\u0006$G\u0003B!}{zDQa\u0018\tA\u0002\u0001DQA\u001c\tA\u0002yBQ\u0001\u001d\tA\u0002y\nq#\u001b8c_VtG-\u00168d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\u0015\u0007\u0005\u000b\u0019\u0001C\u0003g#\u0001\u0007a(A\bj]\n|WO\u001c3Ue\u0006LG.\u001a:t)\r\t\u0015\u0011\u0002\u0005\u0007\u0003\u0017\u0011\u0002\u0019A-\u0002\u0011Q\u0014\u0018-\u001b7feN\fAb\u001d;sK\u0006l7\t\\8tK\u0012$2!QA\t\u0011\u001d\t\u0019b\u0005a\u0001\u0003+\taa\u001d;biV\u001c\bc\u0001\u0011\u0002\u0018%\u0019\u0011\u0011D\u0011\u0003\rM#\u0018\r^;t\u0001")
public final class GrpcEngineClientStreamTracer
extends ClientStreamTracer
implements StrictLogging {
    private final Clock clock;
    private final Function1<Object, BoxedUnit> onStreamStart;
    private final Function1<Object, BoxedUnit> onRequestStart;
    private final Function1<Object, BoxedUnit> onResponseEnd;
    private final Function1<Object, BoxedUnit> onStreamEnd;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void streamCreated(Attributes transportAttrs, Metadata headers) {
        BoxedUnit boxedUnit;
        long timestamp = this.clock.nowMillis();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("streamCreated [now={}, headers={}]", new Object[]{BoxesRunTime.boxToLong((long)timestamp), headers});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.onStreamStart.apply$mcVJ$sp(timestamp);
    }

    public void outboundMessage(int seqNo) {
        BoxedUnit boxedUnit;
        long timestamp = this.clock.nowMillis();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("outboundMessage [now={}, seqNo={}]", new Object[]{BoxesRunTime.boxToLong((long)timestamp), BoxesRunTime.boxToInteger((int)seqNo)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.onRequestStart.apply$mcVJ$sp(timestamp);
    }

    public void outboundUncompressedSize(long bytes) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("outboundUncompressedSize [now={}, bytes={}]", new Object[]{BoxesRunTime.boxToLong((long)this.clock.nowMillis()), BoxesRunTime.boxToLong((long)bytes)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void outboundWireSize(long bytes) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("outboundWireSize [now={}, bytes={}]", new Object[]{BoxesRunTime.boxToLong((long)this.clock.nowMillis()), BoxesRunTime.boxToLong((long)bytes)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("outboundMessageSent [now={}, seqNo={}, optionalWireSize={}, optionalUncompressedSize={}]", new Object[]{BoxesRunTime.boxToLong((long)this.clock.nowMillis()), BoxesRunTime.boxToInteger((int)seqNo), BoxesRunTime.boxToLong((long)optionalWireSize), BoxesRunTime.boxToLong((long)optionalUncompressedSize)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void outboundHeaders() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("outboundHeaders [now={}]", (Object)BoxesRunTime.boxToLong((long)this.clock.nowMillis()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void inboundHeaders() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("inboundHeaders [now={}]", (Object)BoxesRunTime.boxToLong((long)this.clock.nowMillis()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void inboundMessage(int seqNo) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("inboundMessage [now={}, seqNo={}]", new Object[]{BoxesRunTime.boxToLong((long)this.clock.nowMillis()), BoxesRunTime.boxToInteger((int)seqNo)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void inboundWireSize(long bytes) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("inboundWireSize [now={}, bytes={}]", new Object[]{BoxesRunTime.boxToLong((long)this.clock.nowMillis()), BoxesRunTime.boxToLong((long)bytes)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        BoxedUnit boxedUnit;
        long timestamp = this.clock.nowMillis();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("inboundMessageRead [now={}, seqNo={}, optionalWireSize={}, optionalUncompressedSize={}]", new Object[]{BoxesRunTime.boxToLong((long)timestamp), BoxesRunTime.boxToInteger((int)seqNo), BoxesRunTime.boxToLong((long)optionalWireSize), BoxesRunTime.boxToLong((long)optionalUncompressedSize)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.onResponseEnd.apply$mcVJ$sp(timestamp);
    }

    public void inboundUncompressedSize(long bytes) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("inboundUncompressedSize [now={}, bytes={}]", new Object[]{BoxesRunTime.boxToLong((long)this.clock.nowMillis()), BoxesRunTime.boxToLong((long)bytes)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void inboundTrailers(Metadata trailers) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("inboundTrailers [now={}, trailers={}]", new Object[]{BoxesRunTime.boxToLong((long)this.clock.nowMillis()), trailers});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void streamClosed(Status status) {
        BoxedUnit boxedUnit;
        long timestamp = this.clock.nowMillis();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("streamClosed [now={}, status={}]", new Object[]{BoxesRunTime.boxToLong((long)timestamp), status});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.onStreamEnd.apply$mcVJ$sp(timestamp);
    }

    public GrpcEngineClientStreamTracer(Clock clock, Function1<Object, BoxedUnit> onStreamStart, Function1<Object, BoxedUnit> onRequestStart, Function1<Object, BoxedUnit> onResponseEnd, Function1<Object, BoxedUnit> onStreamEnd) {
        this.clock = clock;
        this.onStreamStart = onStreamStart;
        this.onRequestStart = onRequestStart;
        this.onResponseEnd = onResponseEnd;
        this.onStreamEnd = onStreamEnd;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

