/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.grpc.engine;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.session.Session;
import io.gatling.grpc.engine.GrpcManagedChannelBuilder;
import io.gatling.grpc.engine.GrpcManagedChannelSupport$;
import io.gatling.grpc.engine.GrpcSslContextSupport;
import io.gatling.grpc.protocol.GrpcProtocol;
import io.gatling.grpc.protocol.GrpcServerConfiguration;
import io.grpc.ChannelCredentials;
import io.grpc.ManagedChannel;
import io.netty.channel.EventLoopGroup;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005Eq!\u0002\t\u0012\u0011\u0003Qb!\u0002\u000f\u0012\u0011\u0003i\u0002\"\u0002\u0013\u0002\t\u0003)\u0003b\u0002\u0014\u0002\u0005\u0004%Ia\n\u0005\u0007g\u0005\u0001\u000b\u0011\u0002\u0015\u0007\tq\t\"\u0001\u000e\u0005\t\u007f\u0015\u0011\t\u0011)A\u0005\u0001\"A1)\u0002B\u0001B\u0003%A\t\u0003\u0005J\u000b\t\u0005\t\u0015!\u0003K\u0011\u0015!S\u0001\"\u0001N\u0011\u0015\u0011V\u0001\"\u0003T\u0011\u001d\tWA1A\u0005\n\tDaAZ\u0003!\u0002\u0013\u0019\u0007\"B4\u0006\t\u0003A\u0007bBA\u0001\u000b\u0011\u0005\u00111\u0001\u0005\b\u0003\u001b)A\u0011AA\b\u0003e9%\u000f]2NC:\fw-\u001a3DQ\u0006tg.\u001a7TkB\u0004xN\u001d;\u000b\u0005I\u0019\u0012AB3oO&tWM\u0003\u0002\u0015+\u0005!qM\u001d9d\u0015\t1r#A\u0004hCRd\u0017N\\4\u000b\u0003a\t!![8\u0004\u0001A\u00111$A\u0007\u0002#\tIrI\u001d9d\u001b\u0006t\u0017mZ3e\u0007\"\fgN\\3m'V\u0004\bo\u001c:u'\t\ta\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\t\u0011d\u0012:qG\u000eC\u0017M\u001c8fYN\fE\u000f\u001e:jEV$XMT1nKV\t\u0001\u0006\u0005\u0002*a9\u0011!F\f\t\u0003W\u0001j\u0011\u0001\f\u0006\u0003[e\ta\u0001\u0010:p_Rt\u0014BA\u0018!\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011G\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=\u0002\u0013AG$sa\u000e\u001c\u0005.\u00198oK2\u001c\u0018\t\u001e;sS\n,H/\u001a(b[\u0016\u00043cA\u0003\u001fkA\u0011a'P\u0007\u0002o)\u0011\u0001(O\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003um\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002y\u0005\u00191m\\7\n\u0005y:$!D*ue&\u001cG\u000fT8hO&tw-A\u0004ck&dG-\u001a:\u0011\u0005m\t\u0015B\u0001\"\u0012\u0005e9%\u000f]2NC:\fw-\u001a3DQ\u0006tg.\u001a7Ck&dG-\u001a:\u0002\u0011A\u0014x\u000e^8d_2\u0004\"!R$\u000e\u0003\u0019S!aQ\n\n\u0005!3%\u0001D$sa\u000e\u0004&o\u001c;pG>d\u0017!E:tY\u000e{g\u000e^3yiN+\b\u000f]8siB\u00111dS\u0005\u0003\u0019F\u0011Qc\u0012:qGN\u001bHnQ8oi\u0016DHoU;qa>\u0014H\u000f\u0006\u0003O\u001fB\u000b\u0006CA\u000e\u0006\u0011\u0015y\u0014\u00021\u0001A\u0011\u0015\u0019\u0015\u00021\u0001E\u0011\u0015I\u0015\u00021\u0001K\u00035\u0019\b.\u0019:fI\u000eC\u0017M\u001c8fYR\u0011A\u000b\u0018\t\u0004?U;\u0016B\u0001,!\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001LW\u0007\u00023*\u0011AcF\u0005\u00037f\u0013a\"T1oC\u001e,Gm\u00115b]:,G\u000eC\u0003^\u0015\u0001\u0007a,A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003\u000b~K!\u0001\u0019$\u0003/\u001d\u0013\boY*feZ,'oQ8oM&<WO]1uS>t\u0017AD:iCJ,Gm\u00115b]:,Gn]\u000b\u0002GB!\u0011\u0006\u001a\u0015X\u0013\t)'GA\u0002NCB\fqb\u001d5be\u0016$7\t[1o]\u0016d7\u000fI\u0001\bG\"\fgN\\3m)\rIG0 \t\u0004U>\fX\"A6\u000b\u00051l\u0017A\u0003<bY&$\u0017\r^5p]*\u0011a.F\u0001\bG>lWn\u001c8t\u0013\t\u00018N\u0001\u0006WC2LG-\u0019;j_:\u0004Ba\b:u/&\u00111\u000f\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005UTX\"\u0001<\u000b\u0005]D\u0018aB:fgNLwN\u001c\u0006\u0003sV\tAaY8sK&\u00111P\u001e\u0002\b'\u0016\u001c8/[8o\u0011\u00159X\u00021\u0001u\u0011\u0015qX\u00021\u0001\u0000\u0003\u0011q\u0017-\\3\u0011\u0007})\u0006&\u0001\u0005tQV$Hm\\<o)\u0011\t)!a\u0003\u0011\u0007}\t9!C\u0002\u0002\n\u0001\u0012A!\u00168ji\")qO\u0004a\u0001i\u000612\u000f[;uI><hn\u00155be\u0016$7\t[1o]\u0016d7\u000f\u0006\u0002\u0002\u0006\u0001")
public final class GrpcManagedChannelSupport
implements StrictLogging {
    private final GrpcManagedChannelBuilder builder;
    private final GrpcProtocol protocol;
    private final GrpcSslContextSupport sslContextSupport;
    private final Map<String, ManagedChannel> sharedChannels;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Option<ManagedChannel> sharedChannel(GrpcServerConfiguration configuration) {
        if (configuration.enginePart().shareChannel()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Creating new gRPC shared channel for {}", (Object)configuration.name());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (configuration.enginePart().channelCredentials().expression().isDefined()) {
                throw new IllegalStateException("When using shareChannel, cannot configure channelCredentials using an expression, only a constant");
            }
            return new Some((Object)this.builder.newChannel(configuration, (Option<EventLoopGroup>)None$.MODULE$, this.sslContextSupport.sslContext(configuration.name()), configuration.enginePart().channelCredentials().constant()));
        }
        return None$.MODULE$;
    }

    private Map<String, ManagedChannel> sharedChannels() {
        return this.sharedChannels;
    }

    public Validation<Tuple2<Session, ManagedChannel>> channel(Session session, Option<String> name) {
        Validation<String> validation = this.protocol.resolveServerConfigurationName(name);
        if (validation instanceof Success) {
            Validation validation2;
            Map map;
            Success success = (Success)validation;
            String resolvedName = (String)success.value();
            Option option = this.sharedChannels().get((Object)resolvedName);
            if (option instanceof Some) {
                Some some = (Some)option;
                ManagedChannel channel2 = (ManagedChannel)some.value();
                return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)new Tuple2((Object)session, (Object)channel2)));
            }
            Option option2 = session.attributes().get((Object)GrpcManagedChannelSupport$.MODULE$.io$gatling$grpc$engine$GrpcManagedChannelSupport$$GrpcChannelsAttributeName());
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Object channels = some.value();
                map = (Map)channels;
            } else {
                map = Predef$.MODULE$.Map().empty();
            }
            Map channels = map;
            Option option3 = channels.get((Object)resolvedName);
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                ManagedChannel channel3 = (ManagedChannel)some.value();
                validation2 = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)channel3));
            } else {
                GrpcServerConfiguration resolvedServerConfiguration = this.protocol.resolveServerConfiguration(name);
                validation2 = resolvedServerConfiguration.enginePart().channelCredentials().resolve(session).map((Function1 & Serializable)channelCredentials -> $this.builder.newChannel(resolvedServerConfiguration, (Option<EventLoopGroup>)new Some((Object)session.eventLoop()), $this.sslContextSupport.sslContext(resolvedName), (Option<ChannelCredentials>)channelCredentials));
            }
            Validation channel4 = validation2;
            return channel4.map((Function1 & Serializable)channel -> {
                Map updatedChannels = (Map)channels.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resolvedName), channel));
                return new Tuple2((Object)session.set(GrpcManagedChannelSupport$.MODULE$.io$gatling$grpc$engine$GrpcManagedChannelSupport$$GrpcChannelsAttributeName(), (Object)updatedChannels), channel);
            });
        }
        if (validation instanceof Failure) {
            Failure failure = (Failure)validation;
            return failure;
        }
        throw new MatchError(validation);
    }

    public void shutdown(Session session) {
        Option option = session.attributes().get((Object)GrpcManagedChannelSupport$.MODULE$.io$gatling$grpc$engine$GrpcManagedChannelSupport$$GrpcChannelsAttributeName());
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            Object channels = some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(((Map)channels).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ((Map)channels).values().foreach((Function1 & Serializable)x$2 -> x$2.shutdownNow());
            return;
        }
    }

    public void shutdownSharedChannels() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Shutting down gRPC shared channel: {}", this.sharedChannels());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.sharedChannels().values().foreach((Function1 & Serializable)x$3 -> x$3.shutdownNow());
    }

    public GrpcManagedChannelSupport(GrpcManagedChannelBuilder builder, GrpcProtocol protocol, GrpcSslContextSupport sslContextSupport) {
        this.builder = builder;
        this.protocol = protocol;
        this.sslContextSupport = sslContextSupport;
        StrictLogging.$init$((StrictLogging)this);
        this.sharedChannels = (Map)protocol.serverConfigurationsByName().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                GrpcServerConfiguration configuration = (GrpcServerConfiguration)tuple2._2();
                return this.sharedChannel(configuration).map((Function1 & Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), x$1));
            }
            throw new MatchError((Object)tuple2);
        });
        Statics.releaseFence();
    }
}

