/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.grpc.engine;

import io.gatling.grpc.protocol.GrpcProtocol;
import io.gatling.grpc.protocol.GrpcServerConfiguration;
import io.gatling.grpc.protocol.NegotiationType;
import io.gatling.grpc.protocol.TrustManagerType;
import io.gatling.grpc.protocol.TrustManagerType$InsecureTrustManager$;
import io.gatling.grpc.protocol.TrustManagerType$StandardTrustManager$;
import io.grpc.netty.GrpcSslContexts;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import javax.net.ssl.TrustManagerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;

public final class GrpcSslContextSupport$ {
    public static final GrpcSslContextSupport$ MODULE$ = new GrpcSslContextSupport$();

    private Option<SslContextBuilder> newSslContextBuilder(GrpcServerConfiguration configuration) {
        NegotiationType negotiationType = configuration.enginePart().negotiationType();
        if (negotiationType instanceof NegotiationType.UseTransportSecurity) {
            NegotiationType.UseTransportSecurity useTransportSecurity = (NegotiationType.UseTransportSecurity)negotiationType;
            TrustManagerType trustManagerType = useTransportSecurity.trustManager();
            SslContextBuilder builder = GrpcSslContexts.forClient();
            TrustManagerType trustManagerType2 = trustManagerType;
            if (TrustManagerType$StandardTrustManager$.MODULE$.equals(trustManagerType2)) {
                return new Some((Object)builder);
            }
            if (TrustManagerType$InsecureTrustManager$.MODULE$.equals(trustManagerType2)) {
                return new Some((Object)builder.trustManager(InsecureTrustManagerFactory.INSTANCE));
            }
            if (trustManagerType2 instanceof TrustManagerType.CustomCertificateTrustManager) {
                TrustManagerType.CustomCertificateTrustManager customCertificateTrustManager = (TrustManagerType.CustomCertificateTrustManager)trustManagerType2;
                TrustManagerFactory trustManagerFactory = customCertificateTrustManager.trustManagerFactory();
                return new Some((Object)builder.trustManager(trustManagerFactory));
            }
            throw new MatchError((Object)trustManagerType2);
        }
        return None$.MODULE$;
    }

    public Map<String, SslContextBuilder> io$gatling$grpc$engine$GrpcSslContextSupport$$newSslContextBuilders(GrpcProtocol protocol) {
        return (Map)protocol.serverConfigurationsByName().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                GrpcServerConfiguration configuration = (GrpcServerConfiguration)tuple2._2();
                return MODULE$.newSslContextBuilder(configuration).map((Function1 & Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), x$1));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private GrpcSslContextSupport$() {
    }
}

