/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.grpc.engine;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Validation;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.util.BoundedMutableDequeue;
import io.gatling.grpc.action.GrpcInboundMessage;
import io.gatling.grpc.action.builder.GrpcAttributes;
import io.gatling.grpc.check.GrpcMessageResponse;
import io.gatling.grpc.check.GrpcStreamEndResponse;
import io.gatling.grpc.engine.CancelledStream$;
import io.gatling.grpc.engine.ClosedStream$;
import io.gatling.grpc.engine.FromLastMessageReceivedPolicy$;
import io.gatling.grpc.engine.FromLastMessageSentPolicy$;
import io.gatling.grpc.engine.FromStreamStartPolicy$;
import io.gatling.grpc.engine.GrpcEngineClientStreamTracer;
import io.gatling.grpc.engine.GrpcStream$;
import io.gatling.grpc.engine.HalfClosedStream$;
import io.gatling.grpc.engine.MessageResponseTimePolicy;
import io.gatling.grpc.engine.NewStream$;
import io.gatling.grpc.engine.OpenStream$;
import io.gatling.grpc.engine.StreamListenerState;
import io.gatling.grpc.engine.response.GrpcResponseLogger$;
import io.gatling.grpc.engine.response.GrpcStreamResponseProcessor$;
import io.gatling.grpc.enterprise.GrpcStatsEngineAdapter;
import io.gatling.grpc.protocol.GrpcProtocolRequestPart;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientStreamTracer;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\u0011Mq!\u0002,X\u0011\u0003\u0001g!\u00022X\u0011\u0003\u0019\u0007\"\u00026\u0002\t\u0003Y\u0007\"\u00027\u0002\t\u0003igA\u0002B\u0004\u0003\t\u0013I\u0001\u0003\u0006\u0002Z\u0011\u0011)\u001a!C\u0001\u0005GA!Ba\f\u0005\u0005#\u0005\u000b\u0011\u0002B\u0013\u0011)\ti\n\u0002BK\u0002\u0013\u0005\u0011q\u0014\u0005\u000b\u0003{#!\u0011#Q\u0001\n\u0005\u0005\u0006B\u00026\u0005\t\u0003\u0011\t\u0004C\u0005\u00038\u0011\t\t\u0011\"\u0001\u0003:!I!q\b\u0003\u0012\u0002\u0013\u0005!\u0011\t\u0005\n\u0005/\"\u0011\u0013!C\u0001\u00053B\u0011B!\u0018\u0005\u0003\u0003%\tEa\u0018\t\u0013\t=D!!A\u0005\u0002\tE\u0004\"\u0003B=\t\u0005\u0005I\u0011\u0001B>\u0011%\u0011y\bBA\u0001\n\u0003\u0012\t\tC\u0005\u0003\u0010\u0012\t\t\u0011\"\u0001\u0003\u0012\"I!1\u0014\u0003\u0002\u0002\u0013\u0005#Q\u0014\u0005\n\u0005C#\u0011\u0011!C!\u0005GC\u0011B!*\u0005\u0003\u0003%\tEa*\t\u0013\t%F!!A\u0005B\t-v!CBl\u0003\u0005\u0005\t\u0012ABm\r%\u00119!AA\u0001\u0012\u0003\u0019Y\u000e\u0003\u0004k/\u0011\u00051\u0011\u001f\u0005\n\u0005K;\u0012\u0011!C#\u0005OC\u0001\u0002\\\f\u0002\u0002\u0013\u000551\u001f\u0005\n\u0007s<\u0012\u0011!CA\u0007wD\u0011\u0002\"\u0003\u0018\u0003\u0003%I\u0001b\u0003\u0007\r\u0005]\u0012AAA\u001d\u0011)\ti%\bB\u0001B\u0003%\u0011q\n\u0005\u000b\u0003?j\"\u0011!Q\u0001\n\u0005\u0005\u0004BCA7;\t\u0005\t\u0015!\u0003\u0002p!Q\u00111P\u000f\u0003\u0002\u0003\u0006I!! \t\u0015\u0005MUD!A!\u0002\u0013\ti\b\u0003\u0006\u0002\u0016v\u0011\t\u0011)A\u0005\u0003/C1\"!(\u001e\u0005\u0003\u0007I\u0011A\u0001\u0002 \"Y\u0011qV\u000f\u0003\u0002\u0004%\t!AAY\u0011)\ti,\bB\u0001B\u0003&\u0011\u0011\u0015\u0005\u000b\u0003\u007fk\"\u0011!Q\u0001\n\u0005\u0005\u0007b\u00026\u001e\t\u0003\t\u00111\u001b\u0005\u000b\u0003Sl\u0002\u0019!C\u0001\u0003\u0005-\bBCAz;\u0001\u0007I\u0011A\u0001\u0002v\"A\u0011\u0011`\u000f!B\u0013\ti\u000f\u0003\u0006\u0002|v\u0001\r\u0011\"\u0001\u0002\u0003{D!Ba,\u001e\u0001\u0004%\t!\u0001BY\u0011!\u0011),\bQ!\n\u0005}\b\"\u0003B\\;\u0001\u0007I\u0011\u0002B]\u0011%\u0011\t-\ba\u0001\n\u0013\u0011\u0019\r\u0003\u0005\u0003Hv\u0001\u000b\u0015\u0002B^\u0011%\u0011I-\bb\u0001\n\u0013\u0011Y\r\u0003\u0005\u0003Zv\u0001\u000b\u0011\u0002Bg\u00111\u0011Y.\ba\u0001\u0002\u0004%\t!\u0001Bo\u00111\u0011)/\ba\u0001\u0002\u0004%\t!\u0001Bt\u0011-\u0011Y/\ba\u0001\u0002\u0003\u0006KAa8\t\u0013\t5X\u00041A\u0005\n\te\u0006\"\u0003Bx;\u0001\u0007I\u0011\u0002By\u0011!\u0011)0\bQ!\n\tm\u0006\"\u0003B|;\t\u0007I\u0011\u0002Bf\u0011!\u0011I0\bQ\u0001\n\t5\u0007\"\u0003B~;\u0001\u0007I\u0011\u0002B]\u0011%\u0011i0\ba\u0001\n\u0013\u0011y\u0010\u0003\u0005\u0004\u0004u\u0001\u000b\u0015\u0002B^\u0011)\u0019)!\bb\u0001\n\u0003\t1q\u0001\u0005\t\u0007/i\u0002\u0015!\u0003\u0004\n!91\u0011D\u000f\u0005B\rm\u0001bBB\u0010;\u0011\u00053\u0011\u0005\u0005\b\u0007GiB\u0011IB\u0013\u0011\u001d\u0019Y#\bC!\u0007[Aqa!\u0010\u001e\t\u0013\u0019y\u0004C\u0004\u0004Fu!Iaa\u0012\t\u000f\r-S\u0004\"\u0003\u0004N!911K\u000f\u0005\n\rUc\u0001\u00022X\u0005aD!\"!\u0003J\u0005\u0003\u0005\u000b\u0011BA\u0006\u0011)\t\t$\u0013B\u0001B\u0003%\u00111\u0007\u0005\u000b\u0003\u007fK%\u0011!Q\u0001\n\ru\u0003B\u00026J\t\u0003\u0019\t\u0007C\u0004\u0004l%#\t!a;\t\u000f\r5\u0014\n\"\u0001\u0002 \"91qN%\u0005\u0002\rE\u0004bBB=\u0013\u0012\u00051\u0011\u0005\u0005\b\u0007wJE\u0011AB?\u0011\u001d\u00199)\u0013C\u0001\u0007CAqa!#J\t\u0003\u0019Y\tC\u0004\u0004\u0012&#\taa%\u0002\u0015\u001d\u0013\boY*ue\u0016\fWN\u0003\u0002Y3\u00061QM\\4j]\u0016T!AW.\u0002\t\u001d\u0014\bo\u0019\u0006\u00039v\u000bqaZ1uY&twMC\u0001_\u0003\tIwn\u0001\u0001\u0011\u0005\u0005\fQ\"A,\u0003\u0015\u001d\u0013\boY*ue\u0016\fWn\u0005\u0002\u0002IB\u0011Q\r[\u0007\u0002M*\tq-A\u0003tG\u0006d\u0017-\u0003\u0002jM\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u00011\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\u000b9\u001cij!)\u0015+=\u001c\u0019ka-\u00048\u000ee61XBc\u0007\u001f\u001c\tna5\u0004VB\u0019\u0001/^<\u000e\u0003ET!A]:\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002u7\u000691m\\7n_:\u001c\u0018B\u0001<r\u0005)1\u0016\r\\5eCRLwN\u001c\t\u0007C&\u001bYja(\u0016\u000be\fI\"!\f\u0014\u0007%#'\u0010E\u0002|\u0003\u000bi\u0011\u0001 \u0006\u0003{z\fAb]2bY\u0006dwnZ4j]\u001eT1a`A\u0001\u0003!!\u0018\u0010]3tC\u001a,'BAA\u0002\u0003\r\u0019w.\\\u0005\u0004\u0003\u000fa(!D*ue&\u001cG\u000fT8hO&tw-\u0001\u0003dC2d\u0007\u0003CA\u0007\u0003#\t)\"a\u000b\u000e\u0005\u0005=!B\u0001.^\u0013\u0011\t\u0019\"a\u0004\u0003\u0015\rc\u0017.\u001a8u\u0007\u0006dG\u000e\u0005\u0003\u0002\u0018\u0005eA\u0002\u0001\u0003\b\u00037I%\u0019AA\u000f\u0005\u0011\u0011V-\u001d+\u0012\t\u0005}\u0011Q\u0005\t\u0004K\u0006\u0005\u0012bAA\u0012M\n9aj\u001c;iS:<\u0007cA3\u0002(%\u0019\u0011\u0011\u00064\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002\u0018\u00055BaBA\u0018\u0013\n\u0007\u0011Q\u0004\u0002\u0006%\u0016\u001c\b\u000fV\u0001\tY&\u001cH/\u001a8feB)\u0011QG\u000f\u0002,9\u0011\u0011\r\u0001\u0002\t\u0019&\u001cH/\u001a8feV!\u00111HA&'\u0011i\u0012Q\b>\u0011\r\u0005}\u0012QIA%\u001d\u0011\ti!!\u0011\n\t\u0005\r\u0013qB\u0001\u000b\u00072LWM\u001c;DC2d\u0017\u0002BA\u001c\u0003\u000fRA!a\u0011\u0002\u0010A!\u0011qCA&\t\u001d\ty#\bb\u0001\u0003;\tab\u001a:qG\u0006#HO]5ckR,7\u000f\u0005\u0004\u0002R\u0005m\u0013\u0011J\u0007\u0003\u0003'RA!!\u0016\u0002X\u00059!-^5mI\u0016\u0014(bAA-3\u00061\u0011m\u0019;j_:LA!!\u0018\u0002T\tqqI\u001d9d\u0003R$(/\u001b2vi\u0016\u001c\u0018aD4sa\u000e\u001cF/\u0019;t\u000b:<\u0017N\\3\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001aZ\u0003))g\u000e^3saJL7/Z\u0005\u0005\u0003W\n)G\u0001\fHeB\u001c7\u000b^1ug\u0016sw-\u001b8f\u0003\u0012\f\u0007\u000f^3s\u0003\u0015\u0019Gn\\2l!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bAA;g\u0006!Q\u000f^5m\u0013\u0011\tI(a\u001d\u0003\u000b\rcwnY6\u0002#M$(/Z1n%\u0016\fX/Z:u\u001d\u0006lW\r\u0005\u0003\u0002\u0000\u00055e\u0002BAA\u0003\u0013\u00032!a!g\u001b\t\t)IC\u0002\u0002\b~\u000ba\u0001\u0010:p_Rt\u0014bAAFM\u00061\u0001K]3eK\u001aLA!a$\u0002\u0012\n11\u000b\u001e:j]\u001eT1!a#g\u0003IiWm]:bO\u0016\u0014V-];fgRt\u0015-\\3\u000235,7o]1hKJ+7\u000f]8og\u0016$\u0016.\\3Q_2L7-\u001f\t\u0004C\u0006e\u0015bAAN/\nIR*Z:tC\u001e,'+Z:q_:\u001cX\rV5nKB{G.[2z\u0003\u001d\u0019Xm]:j_:,\"!!)\u0011\t\u0005\r\u00161V\u0007\u0003\u0003KSA!!(\u0002(*\u0019\u0011\u0011V.\u0002\t\r|'/Z\u0005\u0005\u0003[\u000b)KA\u0004TKN\u001c\u0018n\u001c8\u0002\u0017M,7o]5p]~#S-\u001d\u000b\u0005\u0003g\u000bI\fE\u0002f\u0003kK1!a.g\u0005\u0011)f.\u001b;\t\u0013\u0005mV%!AA\u0002\u0005\u0005\u0016a\u0001=%c\u0005A1/Z:tS>t\u0007%A\u000fv]6\fGo\u00195fI&s'm\\;oI6+7o]1hK\n+hMZ3s!\u0019\t\u0019-a2\u0002L6\u0011\u0011Q\u0019\u0006\u0005\u0003k\n9+\u0003\u0003\u0002J\u0006\u0015'!\u0006\"pk:$W\rZ'vi\u0006\u0014G.\u001a#fcV,W/\u001a\t\u0007\u0003\u001b\fy-!\u0013\u000e\u0005\u0005]\u0013\u0002BAi\u0003/\u0012!c\u0012:qG&s'm\\;oI6+7o]1hKR\u0011\u0012Q[Am\u00037\fi.a8\u0002b\u0006\r\u0018Q]At!\u0015\t9.HA%\u001b\u0005\t\u0001bBA'Q\u0001\u0007\u0011q\n\u0005\b\u0003?B\u0003\u0019AA1\u0011\u001d\ti\u0007\u000ba\u0001\u0003_Bq!a\u001f)\u0001\u0004\ti\bC\u0004\u0002\u0014\"\u0002\r!! \t\u000f\u0005U\u0005\u00061\u0001\u0002\u0018\"9\u0011Q\u0014\u0015A\u0002\u0005\u0005\u0006bBA`Q\u0001\u0007\u0011\u0011Y\u0001\u0006gR\fG/Z\u000b\u0003\u0003[\u00042!YAx\u0013\r\t\tp\u0016\u0002\u0014'R\u0014X-Y7MSN$XM\\3s'R\fG/Z\u0001\ngR\fG/Z0%KF$B!a-\u0002x\"I\u00111\u0018\u0016\u0002\u0002\u0003\u0007\u0011Q^\u0001\u0007gR\fG/\u001a\u0011\u0002'\r\fG\u000e\u001c2bG.|en\u0015;sK\u0006lWI\u001c3\u0016\u0005\u0005}\b#B3\u0003\u0002\t\u0015\u0011b\u0001B\u0002M\n1q\n\u001d;j_:\u00042!a6\u0005\u0005!\u0019\u0015\r\u001c7cC\u000e\\7C\u0002\u0003e\u0005\u0017\u0011\t\u0002E\u0002f\u0005\u001bI1Aa\u0004g\u0005\u001d\u0001&o\u001c3vGR\u0004BAa\u0005\u0003\u001e9!!Q\u0003B\r\u001d\u0011\t\u0019Ia\u0006\n\u0003\u001dL1Aa\u0007g\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\b\u0003\"\ta1+\u001a:jC2L'0\u00192mK*\u0019!1\u00044\u0016\u0005\t\u0015\u0002\u0003\u0002B\u0014\u0005Wi!A!\u000b\u000b\t\u0005e\u0013qU\u0005\u0005\u0005[\u0011IC\u0001\u0004BGRLwN\\\u0001\bC\u000e$\u0018n\u001c8!)\u0019\u0011)Aa\r\u00036!9\u0011\u0011L\u0005A\u0002\t\u0015\u0002bBAO\u0013\u0001\u0007\u0011\u0011U\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0003\u0006\tm\"Q\b\u0005\n\u00033R\u0001\u0013!a\u0001\u0005KA\u0011\"!(\u000b!\u0003\u0005\r!!)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\t\u0016\u0005\u0005K\u0011)e\u000b\u0002\u0003HA!!\u0011\nB*\u001b\t\u0011YE\u0003\u0003\u0003N\t=\u0013!C;oG\",7m[3e\u0015\r\u0011\tFZ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B+\u0005\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u0017+\t\u0005\u0005&QI\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u0005\u0004\u0003\u0002B2\u0005[j!A!\u001a\u000b\t\t\u001d$\u0011N\u0001\u0005Y\u0006twM\u0003\u0002\u0003l\u0005!!.\u0019<b\u0013\u0011\tyI!\u001a\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tM\u0004cA3\u0003v%\u0019!q\u000f4\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\"Q\u0010\u0005\n\u0003w{\u0011\u0011!a\u0001\u0005g\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u0007\u0003bA!\"\u0003\f\u0006\u0015RB\u0001BD\u0015\r\u0011IIZ\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BG\u0005\u000f\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!1\u0013BM!\r)'QS\u0005\u0004\u0005/3'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003w\u000b\u0012\u0011!a\u0001\u0003K\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!\u0011\rBP\u0011%\tYLEA\u0001\u0002\u0004\u0011\u0019(\u0001\u0005iCND7i\u001c3f)\t\u0011\u0019(\u0001\u0005u_N#(/\u001b8h)\t\u0011\t'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005'\u0013i\u000bC\u0005\u0002<V\t\t\u00111\u0001\u0002&\u000592-\u00197mE\u0006\u001c7n\u00148TiJ,\u0017-\\#oI~#S-\u001d\u000b\u0005\u0003g\u0013\u0019\fC\u0005\u0002<6\n\t\u00111\u0001\u0002\u0000\u0006!2-\u00197mE\u0006\u001c7n\u00148TiJ,\u0017-\\#oI\u0002\nab\u001d;beR$\u0016.\\3ti\u0006l\u0007/\u0006\u0002\u0003<B\u0019QM!0\n\u0007\t}fM\u0001\u0003M_:<\u0017AE:uCJ$H+[7fgR\fW\u000e]0%KF$B!a-\u0003F\"I\u00111\u0018\u0019\u0002\u0002\u0003\u0007!1X\u0001\u0010gR\f'\u000f\u001e+j[\u0016\u001cH/Y7qA\u0005\t\"/Z9vKN$H+[7fgR\fW\u000e]:\u0016\u0005\t5\u0007C\u0002Bh\u0005+\u0014Y,\u0004\u0002\u0003R*!!1\u001bBD\u0003\u001diW\u000f^1cY\u0016LAAa6\u0003R\n)\u0011+^3vK\u0006\u0011\"/Z9vKN$H+[7fgR\fW\u000e]:!\u0003\u001dAW-\u00193feN,\"Aa8\u0011\t\u00055!\u0011]\u0005\u0005\u0005G\fyA\u0001\u0005NKR\fG-\u0019;b\u0003-AW-\u00193feN|F%Z9\u0015\t\u0005M&\u0011\u001e\u0005\n\u0003w+\u0014\u0011!a\u0001\u0005?\f\u0001\u0002[3bI\u0016\u00148\u000fI\u0001\u001aaJ,g/[8vgJ+7\u000f]8og\u0016$\u0016.\\3ti\u0006l\u0007/A\u000fqe\u00164\u0018n\\;t%\u0016\u001c\bo\u001c8tKRKW.Z:uC6\u0004x\fJ3r)\u0011\t\u0019La=\t\u0013\u0005m\u0006(!AA\u0002\tm\u0016A\u00079sKZLw.^:SKN\u0004xN\\:f)&lWm\u001d;b[B\u0004\u0013A\u0005:fgB|gn]3US6,7\u000f^1naN\f1C]3ta>t7/\u001a+j[\u0016\u001cH/Y7qg\u0002\nA\"\u001a8e)&lWm\u001d;b[B\f\u0001#\u001a8e)&lWm\u001d;b[B|F%Z9\u0015\t\u0005M6\u0011\u0001\u0005\n\u0003wk\u0014\u0011!a\u0001\u0005w\u000bQ\"\u001a8e)&lWm\u001d;b[B\u0004\u0013!\u0004;sC\u000e,'OR1di>\u0014\u00180\u0006\u0002\u0004\nA!11BB\t\u001d\u0011\tia!\u0004\n\t\r=\u0011qB\u0001\u0013\u00072LWM\u001c;TiJ,\u0017-\u001c+sC\u000e,'/\u0003\u0003\u0004\u0014\rU!a\u0002$bGR|'/\u001f\u0006\u0005\u0007\u001f\ty!\u0001\bue\u0006\u001cWM\u001d$bGR|'/\u001f\u0011\u0002\u0013=t\u0007*Z1eKJ\u001cH\u0003BAZ\u0007;AqAa7B\u0001\u0004\u0011y.A\u0004p]J+\u0017\rZ=\u0015\u0005\u0005M\u0016!C8o\u001b\u0016\u001c8/Y4f)\u0011\t\u0019la\n\t\u000f\r%2\t1\u0001\u0002J\u00059Q.Z:tC\u001e,\u0017aB8o\u00072|7/\u001a\u000b\u0007\u0003g\u001byc!\u000f\t\u000f\rEB\t1\u0001\u00044\u000511\u000f^1ukN\u0004B!!\u0004\u00046%!1qGA\b\u0005\u0019\u0019F/\u0019;vg\"911\b#A\u0002\t}\u0017\u0001\u0003;sC&dWM]:\u0002\u001b1|wm\u0015;sK\u0006lw\n]3o)\u0011\t\u0019l!\u0011\t\u000f\r\rS\t1\u0001\u0003<\u0006IA/[7fgR\fW\u000e]\u0001\u000fY><W*Z:tC\u001e,7+\u001a8u)\u0011\t\u0019l!\u0013\t\u000f\r\rc\t1\u0001\u0003<\u0006\u0011Bn\\4NKN\u001c\u0018mZ3SK\u000e,\u0017N^3e)\u0019\t\u0019la\u0014\u0004R!91\u0011F$A\u0002\u0005%\u0003bBB\"\u000f\u0002\u0007!1X\u0001\u0010Y><7\u000b\u001e:fC6\u001cEn\\:fIRA\u00111WB,\u00073\u001aY\u0006C\u0004\u00042!\u0003\raa\r\t\u000f\rm\u0002\n1\u0001\u0003`\"911\t%A\u0002\tm\u0006CBAb\u0003\u000f\u001cy\u0006\u0005\u0004\u0002N\u0006=\u00171\u0006\u000b\t\u0007G\u001a)ga\u001a\u0004jA1\u0011-SA\u000b\u0003WAq!!\u0003N\u0001\u0004\tY\u0001C\u0004\u000225\u0003\r!a\r\t\u000f\u0005}V\n1\u0001\u0004^\u0005iA.[:uK:,'o\u0015;bi\u0016\fq\u0002\\5ti\u0016tWM]*fgNLwN\\\u0001\u0006gR\f'\u000f\u001e\u000b\t\u0003g\u001b\u0019h!\u001e\u0004x!9!1\u001c)A\u0002\t}\u0007bBAJ!\u0002\u0007\u0011Q\u0010\u0005\b\u0003;\u0003\u0006\u0019AAQ\u0003\u0019\u0019\u0017M\\2fY\u0006Y1/\u001a8e\u001b\u0016\u001c8/Y4f)!\t\u0019la \u0004\u0004\u000e\u0015\u0005bBBA%\u0002\u0007\u0011QC\u0001\be\u0016\fX/Z:u\u0011\u001d\tiJ\u0015a\u0001\u0003CCq!a%S\u0001\u0004\ti(A\u0005iC247\t\\8tK\u0006Q\"/Z9vKN$8)\u00197mE\u0006\u001c7n\u00148TiJ,\u0017-\\#oIR1\u00111WBG\u0007\u001fCq!!\u0017U\u0001\u0004\u0011)\u0003C\u0004\u0002\u001eR\u0003\r!!)\u0002?\r|G\u000e\\3diVsW.\u0019;dQ\u0016$\u0017J\u001c2pk:$W*Z:tC\u001e,7\u000f\u0006\u0002\u0004\u0016B1!1CBL\u0007?JAa!'\u0003\"\t!A*[:u!\u0011\t9b!(\u0005\u000f\u0005m1A1\u0001\u0002\u001eA!\u0011qCBQ\t\u001d\tyc\u0001b\u0001\u0003;Aqa!*\u0004\u0001\u0004\u00199+\u0001\fheB\u001c\u0007K]8u_\u000e|G.\u0011;ue&\u0014W\u000f^3t!\u0011\u0019Ika,\u000e\u0005\r-&bABW3\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u00042\u000e-&aF$sa\u000e\u0004&o\u001c;pG>d'+Z9vKN$\b+\u0019:u\u0011\u001d\tie\u0001a\u0001\u0007k\u0003b!!\u0015\u0002\\\r}\u0005bBA0\u0007\u0001\u0007\u0011\u0011\r\u0005\b\u0003[\u001a\u0001\u0019AA8\u0011\u001d\u0019il\u0001a\u0001\u0007\u007f\u000bqa\u00195b]:,G\u000e\u0005\u0003\u0002\u000e\r\u0005\u0017\u0002BBb\u0003\u001f\u0011qa\u00115b]:,G\u000eC\u0004\u0004H\u000e\u0001\ra!3\u0002!5,G\u000f[8e\t\u0016\u001c8M]5qi>\u0014\b\u0003CA\u0007\u0007\u0017\u001cYja(\n\t\r5\u0017q\u0002\u0002\u0011\u001b\u0016$\bn\u001c3EKN\u001c'/\u001b9u_JDq!a\u001f\u0004\u0001\u0004\ti\bC\u0004\u0002\u0014\u000e\u0001\r!! \t\u000f\u0005U5\u00011\u0001\u0002\u0018\"9\u0011QT\u0002A\u0002\u0005\u0005\u0016\u0001C\"bY2\u0014\u0017mY6\u0011\u0007\u0005]wcE\u0003\u0018\u0007;\u001cI\u000f\u0005\u0006\u0004`\u000e\u0015(QEAQ\u0005\u000bi!a!9\u000b\u0007\r\rh-A\u0004sk:$\u0018.\\3\n\t\r\u001d8\u0011\u001d\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BBv\u0007_l!a!<\u000b\u0007y\u0013I'\u0003\u0003\u0003 \r5HCABm)\u0019\u0011)a!>\u0004x\"9\u0011\u0011\f\u000eA\u0002\t\u0015\u0002bBAO5\u0001\u0007\u0011\u0011U\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019i\u0010\"\u0002\u0011\u000b\u0015\u0014\taa@\u0011\u000f\u0015$\tA!\n\u0002\"&\u0019A1\u00014\u0003\rQ+\b\u000f\\33\u0011%!9aGA\u0001\u0002\u0004\u0011)!A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"\u0001\"\u0004\u0011\t\t\rDqB\u0005\u0005\t#\u0011)G\u0001\u0004PE*,7\r\u001e")
public final class GrpcStream<ReqT, RespT>
implements StrictLogging {
    private final ClientCall<ReqT, RespT> call;
    private final Listener<RespT> listener;
    private final BoundedMutableDequeue<GrpcInboundMessage<RespT>> unmatchedInboundMessageBuffer;
    private Logger logger;

    public static <ReqT, RespT> Validation<GrpcStream<ReqT, RespT>> apply(GrpcProtocolRequestPart grpcProtocolAttributes, GrpcAttributes<RespT> grpcAttributes, GrpcStatsEngineAdapter grpcStatsEngine, Clock clock, Channel channel, MethodDescriptor<ReqT, RespT> methodDescriptor, String streamRequestName, String messageRequestName, MessageResponseTimePolicy messageResponseTimePolicy, Session session) {
        return GrpcStream$.MODULE$.apply(grpcProtocolAttributes, grpcAttributes, grpcStatsEngine, clock, channel, methodDescriptor, streamRequestName, messageRequestName, messageResponseTimePolicy, session);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public StreamListenerState listenerState() {
        return this.listener.state();
    }

    public Session listenerSession() {
        return this.listener.session();
    }

    public void start(Metadata headers, String messageRequestName, Session session) {
        StreamListenerState streamListenerState = this.listener.state();
        if (NewStream$.MODULE$.equals(streamListenerState)) {
            this.listener.state_$eq(OpenStream$.MODULE$);
            this.call.start(this.listener, headers);
            this.call.request(Integer.MAX_VALUE);
            GrpcResponseLogger$.MODULE$.logStreamStart(messageRequestName, headers, session);
            return;
        }
        throw new IllegalStateException("Cannot start gRPC stream; current state is " + streamListenerState);
    }

    public void cancel() {
        StreamListenerState streamListenerState = this.listener.state();
        if (ClosedStream$.MODULE$.equals(streamListenerState) ? true : CancelledStream$.MODULE$.equals(streamListenerState)) {
            throw new IllegalStateException("Cannot cancel gRPC stream; current state is " + streamListenerState);
        }
        this.listener.state_$eq(CancelledStream$.MODULE$);
        this.call.cancel("gRPC call cancelled from the Gatling gRPC DSL", null);
    }

    public void sendMessage(ReqT request, Session session, String messageRequestName) {
        StreamListenerState streamListenerState = this.listener.state();
        if (OpenStream$.MODULE$.equals(streamListenerState)) {
            this.unmatchedInboundMessageBuffer.clear();
            this.call.sendMessage(request);
            GrpcResponseLogger$.MODULE$.logRequestMessage(messageRequestName, request, session);
            return;
        }
        throw new IllegalStateException("Cannot send message on gRPC stream; current state is " + streamListenerState);
    }

    public void halfClose() {
        StreamListenerState streamListenerState = this.listener.state();
        if (OpenStream$.MODULE$.equals(streamListenerState)) {
            this.listener.state_$eq(HalfClosedStream$.MODULE$);
            this.call.halfClose();
            return;
        }
        throw new IllegalStateException("Cannot half-close gRPC stream; current state is " + streamListenerState);
    }

    public void requestCallbackOnStreamEnd(Action action, Session session) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("requestCallbackOnStreamEnd [action={}, session={}, state={}]", new Object[]{action, session, this.listener.state()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        StreamListenerState streamListenerState = this.listener.state();
        if (OpenStream$.MODULE$.equals(streamListenerState) ? true : (HalfClosedStream$.MODULE$.equals(streamListenerState) ? true : CancelledStream$.MODULE$.equals(streamListenerState))) {
            this.listener.callbackOnStreamEnd_$eq((Option<Callback>)new Some((Object)new Callback(action, session)));
            return;
        }
        throw new IllegalStateException("Cannot await end of gRPC stream; current state is " + streamListenerState);
    }

    public List<GrpcInboundMessage<RespT>> collectUnmatchedInboundMessages() {
        return this.unmatchedInboundMessageBuffer.removeAll();
    }

    public GrpcStream(ClientCall<ReqT, RespT> call, Listener<RespT> listener, BoundedMutableDequeue<GrpcInboundMessage<RespT>> unmatchedInboundMessageBuffer) {
        this.call = call;
        this.listener = listener;
        this.unmatchedInboundMessageBuffer = unmatchedInboundMessageBuffer;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }

    public static final class Callback
    implements Product,
    Serializable {
        private final Action action;
        private final Session session;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Action action() {
            return this.action;
        }

        public Session session() {
            return this.session;
        }

        public Callback copy(Action action, Session session) {
            return new Callback(action, session);
        }

        public Action copy$default$1() {
            return this.action();
        }

        public Session copy$default$2() {
            return this.session();
        }

        public String productPrefix() {
            return "Callback";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.action();
                }
                case 1: {
                    return this.session();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Callback;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "action";
                }
                case 1: {
                    return "session";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 189044115, true);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Callback)) return false;
            boolean bl = true;
            if (!bl) return false;
            Callback callback = (Callback)x$1;
            Action action = this.action();
            Action action2 = callback.action();
            if (action == null) {
                if (action2 != null) {
                    return false;
                }
            } else if (!action.equals(action2)) return false;
            Session session = this.session();
            Session session2 = callback.session();
            if (session == null) {
                if (session2 == null) return true;
                return false;
            } else {
                if (!session.equals(session2)) return false;
                return true;
            }
        }

        public Callback(Action action, Session session) {
            this.action = action;
            this.session = session;
            Product.$init$((Product)this);
        }
    }

    public static final class Listener<RespT>
    extends ClientCall.Listener<RespT>
    implements StrictLogging {
        private final GrpcAttributes<RespT> grpcAttributes;
        private final GrpcStatsEngineAdapter grpcStatsEngine;
        public final Clock io$gatling$grpc$engine$GrpcStream$Listener$$clock;
        private final String streamRequestName;
        private final String messageRequestName;
        private final MessageResponseTimePolicy messageResponseTimePolicy;
        private Session session;
        private final BoundedMutableDequeue<GrpcInboundMessage<RespT>> unmatchedInboundMessageBuffer;
        private StreamListenerState state;
        private Option<Callback> callbackOnStreamEnd;
        private long io$gatling$grpc$engine$GrpcStream$Listener$$startTimestamp;
        private final Queue<Object> io$gatling$grpc$engine$GrpcStream$Listener$$requestTimestamps;
        private Metadata headers;
        private long previousResponseTimestamp;
        private final Queue<Object> io$gatling$grpc$engine$GrpcStream$Listener$$responseTimestamps;
        private long io$gatling$grpc$engine$GrpcStream$Listener$$endTimestamp;
        private final ClientStreamTracer.Factory tracerFactory;
        private Logger logger;

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        public Session session() {
            return this.session;
        }

        public void session_$eq(Session x$1) {
            this.session = x$1;
        }

        public StreamListenerState state() {
            return this.state;
        }

        public void state_$eq(StreamListenerState x$1) {
            this.state = x$1;
        }

        public Option<Callback> callbackOnStreamEnd() {
            return this.callbackOnStreamEnd;
        }

        public void callbackOnStreamEnd_$eq(Option<Callback> x$1) {
            this.callbackOnStreamEnd = x$1;
        }

        private long startTimestamp() {
            return this.io$gatling$grpc$engine$GrpcStream$Listener$$startTimestamp;
        }

        public void io$gatling$grpc$engine$GrpcStream$Listener$$startTimestamp_$eq(long x$1) {
            this.io$gatling$grpc$engine$GrpcStream$Listener$$startTimestamp = x$1;
        }

        public Queue<Object> io$gatling$grpc$engine$GrpcStream$Listener$$requestTimestamps() {
            return this.io$gatling$grpc$engine$GrpcStream$Listener$$requestTimestamps;
        }

        public Metadata headers() {
            return this.headers;
        }

        public void headers_$eq(Metadata x$1) {
            this.headers = x$1;
        }

        private long previousResponseTimestamp() {
            return this.previousResponseTimestamp;
        }

        private void previousResponseTimestamp_$eq(long x$1) {
            this.previousResponseTimestamp = x$1;
        }

        public Queue<Object> io$gatling$grpc$engine$GrpcStream$Listener$$responseTimestamps() {
            return this.io$gatling$grpc$engine$GrpcStream$Listener$$responseTimestamps;
        }

        private long endTimestamp() {
            return this.io$gatling$grpc$engine$GrpcStream$Listener$$endTimestamp;
        }

        public void io$gatling$grpc$engine$GrpcStream$Listener$$endTimestamp_$eq(long x$1) {
            this.io$gatling$grpc$engine$GrpcStream$Listener$$endTimestamp = x$1;
        }

        public ClientStreamTracer.Factory tracerFactory() {
            return this.tracerFactory;
        }

        public void onHeaders(Metadata headers) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("onHeaders [headers={}]", (Object)headers);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.headers_$eq(headers);
        }

        public void onReady() {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("onReady");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }

        public void onMessage(RespT message) {
            BoxedUnit boxedUnit;
            long l;
            try {
                l = BoxesRunTime.unboxToLong((Object)this.io$gatling$grpc$engine$GrpcStream$Listener$$responseTimestamps().dequeue());
            }
            catch (NoSuchElementException e) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("onMessage called while there was no message timestamp to dequeue");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                throw new IllegalStateException("GrpcStream.Listener.onMessage called while there was no message timestamp to dequeue", e);
            }
            long timestamp = l;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("onMessage [timestamp={}, message={}]", new Object[]{BoxesRunTime.boxToLong((long)timestamp), message});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.logMessageReceived(message, timestamp);
            this.previousResponseTimestamp_$eq(timestamp);
            this.unmatchedInboundMessageBuffer.addOne(new GrpcInboundMessage<RespT>(timestamp, message));
        }

        public void onClose(Status status, Metadata trailers) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("onClose [timestamp={}, status={}, trailers={}]", new Object[]{BoxesRunTime.boxToLong((long)this.endTimestamp()), status, trailers});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.state_$eq(ClosedStream$.MODULE$);
            if (this.endTimestamp() < 0L) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("onClose called while endTimestamp had not been registered");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                throw new IllegalStateException("GrpcStreamListener.onClose called while endTimestamp had not been registered");
            }
            this.logStreamClosed(status, trailers, this.endTimestamp());
            this.callbackOnStreamEnd().foreach((Function1 & Serializable)cb -> {
                Listener.$anonfun$onClose$1(cb);
                return BoxedUnit.UNIT;
            });
        }

        public void io$gatling$grpc$engine$GrpcStream$Listener$$logStreamOpen(long timestamp) {
            GrpcStreamResponseProcessor$.MODULE$.logRequest(this.grpcStatsEngine, this.session(), this.streamRequestName, timestamp);
        }

        public void io$gatling$grpc$engine$GrpcStream$Listener$$logMessageSent(long timestamp) {
            GrpcStreamResponseProcessor$.MODULE$.logRequest(this.grpcStatsEngine, this.session(), this.messageRequestName, timestamp);
        }

        private void logMessageReceived(RespT message, long timestamp) {
            long l;
            MessageResponseTimePolicy messageResponseTimePolicy = this.messageResponseTimePolicy;
            if (FromStreamStartPolicy$.MODULE$.equals(messageResponseTimePolicy)) {
                l = this.startTimestamp();
            } else if (FromLastMessageSentPolicy$.MODULE$.equals(messageResponseTimePolicy)) {
                l = BoxesRunTime.unboxToLong((Object)this.io$gatling$grpc$engine$GrpcStream$Listener$$requestTimestamps().lastOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.startTimestamp()));
            } else if (FromLastMessageReceivedPolicy$.MODULE$.equals(messageResponseTimePolicy)) {
                l = this.previousResponseTimestamp() > 0L ? this.previousResponseTimestamp() : this.startTimestamp();
            } else {
                throw new MatchError((Object)messageResponseTimePolicy);
            }
            long initialTimestamp = l;
            this.session_$eq(GrpcStreamResponseProcessor$.MODULE$.logMessage(this.grpcAttributes, this.grpcStatsEngine, new GrpcMessageResponse<RespT>(message), this.messageRequestName, this.session(), initialTimestamp, timestamp));
        }

        private void logStreamClosed(Status status, Metadata trailers, long timestamp) {
            this.session_$eq(GrpcStreamResponseProcessor$.MODULE$.logStreamEnd(this.grpcAttributes, this.grpcStatsEngine, new GrpcStreamEndResponse(this.headers(), status, trailers), this.session(), this.streamRequestName, this.startTimestamp(), timestamp));
        }

        public static final /* synthetic */ void $anonfun$onClose$1(Callback cb) {
            cb.action().$bang(cb.session());
        }

        public Listener(GrpcAttributes<RespT> grpcAttributes, GrpcStatsEngineAdapter grpcStatsEngine, Clock clock, String streamRequestName, String messageRequestName, MessageResponseTimePolicy messageResponseTimePolicy, Session session, BoundedMutableDequeue<GrpcInboundMessage<RespT>> unmatchedInboundMessageBuffer) {
            this.grpcAttributes = grpcAttributes;
            this.grpcStatsEngine = grpcStatsEngine;
            this.io$gatling$grpc$engine$GrpcStream$Listener$$clock = clock;
            this.streamRequestName = streamRequestName;
            this.messageRequestName = messageRequestName;
            this.messageResponseTimePolicy = messageResponseTimePolicy;
            this.session = session;
            this.unmatchedInboundMessageBuffer = unmatchedInboundMessageBuffer;
            StrictLogging.$init$((StrictLogging)this);
            this.state = NewStream$.MODULE$;
            this.callbackOnStreamEnd = None$.MODULE$;
            this.io$gatling$grpc$engine$GrpcStream$Listener$$startTimestamp = -1L;
            this.io$gatling$grpc$engine$GrpcStream$Listener$$requestTimestamps = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
            this.previousResponseTimestamp = -1L;
            this.io$gatling$grpc$engine$GrpcStream$Listener$$responseTimestamps = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
            this.io$gatling$grpc$engine$GrpcStream$Listener$$endTimestamp = -1L;
            this.tracerFactory = new ClientStreamTracer.Factory(this){
                private final /* synthetic */ Listener $outer;

                public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
                    return new GrpcEngineClientStreamTracer(this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$clock, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)timestamp -> {
                        $this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$startTimestamp_$eq(timestamp);
                        $this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$logStreamOpen(timestamp);
                    }, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)timestamp -> {
                        $this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$requestTimestamps().enqueue((Object)BoxesRunTime.boxToLong((long)timestamp));
                        $this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$logMessageSent(timestamp);
                    }, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)timestamp -> $this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$responseTimestamps().enqueue((Object)BoxesRunTime.boxToLong((long)timestamp)), (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable)x$2 -> $this.$outer.io$gatling$grpc$engine$GrpcStream$Listener$$endTimestamp_$eq(x$2));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$newClientStreamTracer$1(io.gatling.grpc.engine.GrpcStream$Listener$$anon$1 long ), $anonfun$newClientStreamTracer$2(io.gatling.grpc.engine.GrpcStream$Listener$$anon$1 long ), $anonfun$newClientStreamTracer$3(io.gatling.grpc.engine.GrpcStream$Listener$$anon$1 long ), $anonfun$newClientStreamTracer$4(io.gatling.grpc.engine.GrpcStream$Listener$$anon$1 long )}, serializedLambda);
                }
            };
            Statics.releaseFence();
        }
    }
}

