/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.grpc.protocol;

import io.gatling.commons.validation.Validation;
import io.gatling.core.session.Session;
import io.gatling.grpc.protocol.GrpcHeader;
import io.gatling.grpc.protocol.GrpcHeaders;
import io.gatling.grpc.protocol.GrpcProtocolChannelCredentials;
import io.gatling.grpc.protocol.GrpcProtocolChannelCredentials$;
import io.gatling.grpc.protocol.GrpcProtocolEnginePart;
import io.gatling.grpc.protocol.GrpcProtocolRequestPart;
import io.gatling.grpc.protocol.GrpcServerConfiguration;
import io.gatling.grpc.protocol.GrpcServerConfigurationBuilder$;
import io.gatling.grpc.protocol.NegotiationType;
import io.gatling.grpc.protocol.NegotiationType$UsePlaintext$;
import io.gatling.grpc.protocol.ServerLocation;
import io.gatling.grpc.protocol.TrustManagerType;
import io.gatling.grpc.protocol.TrustManagerType$InsecureTrustManager$;
import io.gatling.grpc.protocol.TrustManagerType$StandardTrustManager$;
import io.gatling.internal.quicklens.package;
import io.gatling.shared.util.Ssl$;
import io.grpc.CallCredentials;
import io.grpc.ChannelCredentials;
import io.grpc.Metadata;
import io.grpc.internal.JsonParser;
import io.grpc.internal.PickRandomLoadBalancerProvider$;
import java.io.Serializable;
import java.util.Map;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\t-s!B\u0017/\u0011\u00039d!B\u001d/\u0011\u0003Q\u0004\"\u0002%\u0002\t\u0003I\u0005b\u0002&\u0002\u0005\u0004%\ta\u0013\u0005\b\u0005W\t\u0001\u0015!\u0003M\u0011%\u0011i#AA\u0001\n\u0003\u0013y\u0003C\u0005\u00034\u0005\t\t\u0011\"!\u00036!I!\u0011I\u0001\u0002\u0002\u0013%!1\t\u0004\u0005s9\u0012U\nC\u0005`\u0011\t\u0015\r\u0011\"\u00011A\"AA\r\u0003B\tB\u0003%\u0011\rC\u0003I\u0011\u0011\u0005Q\r\u0003\u0004h\u0011\u0011Ec\u0006\u001b\u0005\b\u0003\u001bAA\u0011AA\b\u0011\u001d\t\u0019\u0005\u0003C\u0001\u0003\u000bBq!a\u0011\t\t\u0003\t\t\u0006C\u0004\u0002V!!\t!a\u0016\t\u000f\u0005]\u0004\u0002\"\u0001\u0002z!9\u0011q\u0010\u0005\u0005\u0002\u0005\u0005\u0005BBAD\u0011\u0011\u00051\n\u0003\u0004\u0002\n\"!\ta\u0013\u0005\b\u0003\u0017CA\u0011AAG\u0011\u0019\t\u0019\n\u0003C\u0001\u0017\"1\u0011Q\u0013\u0005\u0005\u0002-Ca!a&\t\t\u0003Y\u0005bBAM\u0011\u0011\u0005\u00111\u0014\u0005\b\u0003CCA\u0011AAR\u0011\u001d\t\t\u000b\u0003C\u0001\u0003SCa!!-\t\t\u0003Y\u0005BBAZ\u0011\u0011\u00051\n\u0003\u0004\u00026\"!\ta\u0013\u0005\b\u0003oCA\u0011AA]\u0011\u0019\ty\f\u0003C\u0001A\"I\u0011\u0011\u0019\u0005\u0002\u0002\u0013\u0005\u00111\u0019\u0005\n\u0003\u000fD\u0011\u0013!C\u0001\u0003\u0013D\u0001\"a8\t\u0017\u0003%\t\u0001\u0019\u0005\n\u0003CD\u0011\u0011!C!\u0003GD\u0011\"a<\t\u0003\u0003%\t!!=\t\u0013\u0005M\b\"!A\u0005\u0002\u0005U\b\"CA~\u0011\u0005\u0005I\u0011IA\u007f\u0011%\u0011Y\u0001CA\u0001\n\u0003\u0011i\u0001C\u0005\u0003\u0018!\t\t\u0011\"\u0011\u0003\u001a!I!Q\u0004\u0005\u0002\u0002\u0013\u0005#q\u0004\u0005\n\u0005CA\u0011\u0011!C!\u0005GA\u0011B!\n\t\u0003\u0003%\tEa\n\u0002=\u001d\u0013\boY*feZ,'oQ8oM&<WO]1uS>t')^5mI\u0016\u0014(BA\u00181\u0003!\u0001(o\u001c;pG>d'BA\u00193\u0003\u00119'\u000f]2\u000b\u0005M\"\u0014aB4bi2Lgn\u001a\u0006\u0002k\u0005\u0011\u0011n\\\u0002\u0001!\tA\u0014!D\u0001/\u0005y9%\u000f]2TKJ4XM]\"p]\u001aLw-\u001e:bi&|gNQ;jY\u0012,'oE\u0002\u0002w\u0005\u0003\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012a!\u00118z%\u00164\u0007C\u0001\"G\u001b\u0005\u0019%BA\u001bE\u0015\u0005)\u0015\u0001\u00026bm\u0006L!aR\"\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u00059\u0014!\u0004#fM\u0006,H\u000e\u001e'fO\u0006\u001c\u00170F\u0001M!\tA\u0004bE\u0003\tw9\u000bF\u000bE\u00029\u001f2K!\u0001\u0015\u0018\u0003\u0017\u001d\u0013\bo\u0019%fC\u0012,'o\u001d\t\u0003yIK!aU\u001f\u0003\u000fA\u0013x\u000eZ;diB\u0011Q+\u0018\b\u0003-ns!a\u0016.\u000e\u0003aS!!\u0017\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0014B\u0001/>\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00120\u000b\u0005qk\u0014aE:feZ,'oQ8oM&<WO]1uS>tW#A1\u0011\u0005a\u0012\u0017BA2/\u0005]9%\u000f]2TKJ4XM]\"p]\u001aLw-\u001e:bi&|g.\u0001\u000btKJ4XM]\"p]\u001aLw-\u001e:bi&|g\u000e\t\u000b\u0003\u0019\u001aDQaX\u0006A\u0002\u0005\f\u0001\u0002[3bI\u0016\u00148o\u0018\u000b\u0003\u0019&DQA\u001b\u0007A\u0002-\f!\"\u00193e\u0011\u0016\fG-\u001a:t!\u0015aDN\\A\u0001\u0013\tiWHA\u0005Gk:\u001cG/[8ocA\u0019Qk\\9\n\u0005At&\u0001\u0002'jgR\u0004$A]<\u0011\u0007a\u001aX/\u0003\u0002u]\tQqI\u001d9d\u0011\u0016\fG-\u001a:\u0011\u0005Y<H\u0002\u0001\u0003\nq&\f\t\u0011!A\u0003\u0002e\u00141a\u0018\u00132#\tQX\u0010\u0005\u0002=w&\u0011A0\u0010\u0002\b\u001d>$\b.\u001b8h!\tad0\u0003\u0002\u0000{\t\u0019\u0011I\\=\u0011\tU{\u00171\u0001\u0019\u0005\u0003\u000b\tI\u0001\u0005\u00039g\u0006\u001d\u0001c\u0001<\u0002\n\u0011Q\u00111B5\u0002\u0002\u0003\u0005)\u0011A=\u0003\u0007}##'A\bdC2d7I]3eK:$\u0018.\u00197t)\ra\u0015\u0011\u0003\u0005\b\u0003'i\u0001\u0019AA\u000b\u0003-\u0019'/\u001a3f]RL\u0017\r\\:\u0011\r\u0005]\u00111GA\u001d\u001d\u0011\tI\"a\f\u000f\t\u0005m\u0011\u0011\u0006\b\u0005\u0003;\t)C\u0004\u0003\u0002 \u0005\rbbA,\u0002\"%\tQ'\u0003\u00024i%\u0019\u0011q\u0005\u001a\u0002\t\r|'/Z\u0005\u0005\u0003W\ti#A\u0004tKN\u001c\u0018n\u001c8\u000b\u0007\u0005\u001d\"'C\u0002]\u0003cQA!a\u000b\u0002.%!\u0011QGA\u001c\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0006\u00049\u0006E\u0002\u0003BA\u001e\u0003\u007fi!!!\u0010\u000b\u0005E\"\u0014\u0002BA!\u0003{\u0011qbQ1mY\u000e\u0013X\rZ3oi&\fGn]\u0001\u0013G\"\fgN\\3m\u0007J,G-\u001a8uS\u0006d7\u000fF\u0002M\u0003\u000fBq!a\u0005\u000f\u0001\u0004\tI\u0005\u0005\u0004\u0002\u0018\u0005M\u00121\n\t\u0005\u0003w\ti%\u0003\u0003\u0002P\u0005u\"AE\"iC:tW\r\\\"sK\u0012,g\u000e^5bYN$2\u0001TA*\u0011\u001d\t\u0019b\u0004a\u0001\u0003\u0017\n!BZ8s\u0003\u0012$'/Z:t)\u0015a\u0015\u0011LA7\u0011\u001d\tY\u0006\u0005a\u0001\u0003;\nA\u0001[8tiB!\u0011qLA4\u001d\u0011\t\t'a\u0019\u0011\u0005]k\u0014bAA3{\u00051\u0001K]3eK\u001aLA!!\u001b\u0002l\t11\u000b\u001e:j]\u001eT1!!\u001a>\u0011\u001d\ty\u0007\u0005a\u0001\u0003c\nA\u0001]8siB\u0019A(a\u001d\n\u0007\u0005UTHA\u0002J]R\f\u0011BZ8s)\u0006\u0014x-\u001a;\u0015\u00071\u000bY\bC\u0004\u0002~E\u0001\r!!\u0018\u0002\rQ\f'oZ3u\u0003Eyg/\u001a:sS\u0012,\u0017)\u001e;i_JLG/\u001f\u000b\u0004\u0019\u0006\r\u0005bBAC%\u0001\u0007\u0011QL\u0001\nCV$\bn\u001c:jif\fAb\u001d5be\u0016\u001c\u0005.\u00198oK2\fqb\u001d5be\u0016\u001c6\u000f\\\"p]R,\u0007\u0010^\u0001\u000fkN,7\t[1o]\u0016d\u0007k\\8m)\ra\u0015q\u0012\u0005\b\u0003#+\u0002\u0019AA9\u0003!\u0001xn\u001c7TSj,\u0017\u0001D;tKBc\u0017-\u001b8uKb$\u0018aF;tK&s7/Z2ve\u0016$&/^:u\u001b\u0006t\u0017mZ3s\u0003])8/Z*uC:$\u0017M\u001d3UeV\u001cH/T1oC\u001e,'/\u0001\u0011vg\u0016\u001cUo\u001d;p[\u000e+'\u000f^5gS\u000e\fG/\u001a+skN$X*\u00198bO\u0016\u0014Hc\u0001'\u0002\u001e\"9\u0011qT\rA\u0002\u0005u\u0013aD2feRLg-[2bi\u0016\u0004\u0016\r\u001e5\u00029U\u001cXmQ;ti>lGj\\1e\u0005\u0006d\u0017M\\2j]\u001e\u0004v\u000e\\5dsR\u0019A*!*\t\u000f\u0005\u001d&\u00041\u0001\u0002^\u00051\u0001o\u001c7jGf$R\u0001TAV\u0003[Cq!a*\u001c\u0001\u0004\ti\u0006C\u0004\u00020n\u0001\r!!\u0018\u0002!)\u001cxN\u001c)pY&\u001c\u0017pQ8oM&<\u0017aH;tKBK7m\u001b$jeN$Hj\\1e\u0005\u0006d\u0017M\\2j]\u001e\u0004v\u000e\\5ds\u0006\u0001So]3QS\u000e\\'+\u00198e_6du.\u00193CC2\fgnY5oOB{G.[2z\u0003\u0001*8/\u001a*pk:$'k\u001c2j]2{\u0017\r\u001a\"bY\u0006t7-\u001b8h!>d\u0017nY=\u0002CUtW.\u0019;dQ\u0016$\u0017J\u001c2pk:$W*Z:tC\u001e,')\u001e4gKJ\u001c\u0016N_3\u0015\u00071\u000bY\fC\u0004\u0002>~\u0001\r!!\u001d\u0002\u00075\f\u00070A\u0003ck&dG-\u0001\u0003d_BLHc\u0001'\u0002F\"9q,\tI\u0001\u0002\u0004\t\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0017T3!YAgW\t\ty\r\u0005\u0003\u0002R\u0006mWBAAj\u0015\u0011\t).a6\u0002\u0013Ut7\r[3dW\u0016$'bAAm{\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00171\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001H:feZ,'oQ8oM&<WO]1uS>tG%Y2dKN\u001cH\u0005M\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\b\u0003BAt\u0003[l!!!;\u000b\u0007\u0005-H)\u0001\u0003mC:<\u0017\u0002BA5\u0003S\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001d\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019Q0a>\t\u0013\u0005eh%!AA\u0002\u0005E\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0000B)!\u0011\u0001B\u0004{6\u0011!1\u0001\u0006\u0004\u0005\u000bi\u0014AC2pY2,7\r^5p]&!!\u0011\u0002B\u0002\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t=!Q\u0003\t\u0004y\tE\u0011b\u0001B\n{\t9!i\\8mK\u0006t\u0007\u0002CA}Q\u0005\u0005\t\u0019A?\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003K\u0014Y\u0002C\u0005\u0002z&\n\t\u00111\u0001\u0002r\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002r\u0005AAo\\*ue&tw\r\u0006\u0002\u0002f\u00061Q-];bYN$BAa\u0004\u0003*!A\u0011\u0011 \u0017\u0002\u0002\u0003\u0007Q0\u0001\bEK\u001a\fW\u000f\u001c;MK\u001e\f7-\u001f\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00071\u0013\t\u0004C\u0003`\u000b\u0001\u0007\u0011-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t]\"Q\b\t\u0005y\te\u0012-C\u0002\u0003<u\u0012aa\u00149uS>t\u0007\u0002\u0003B \r\u0005\u0005\t\u0019\u0001'\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003FA!\u0011q\u001dB$\u0013\u0011\u0011I%!;\u0003\r=\u0013'.Z2u\u0001")
public final class GrpcServerConfigurationBuilder
implements GrpcHeaders<GrpcServerConfigurationBuilder>,
Product,
Serializable {
    private final GrpcServerConfiguration serverConfiguration;

    public static Option<GrpcServerConfiguration> unapply(GrpcServerConfigurationBuilder x$0) {
        return GrpcServerConfigurationBuilder$.MODULE$.unapply(x$0);
    }

    public static GrpcServerConfigurationBuilder apply(GrpcServerConfiguration serverConfiguration) {
        return GrpcServerConfigurationBuilder$.MODULE$.apply(serverConfiguration);
    }

    public static GrpcServerConfigurationBuilder DefaultLegacy() {
        return GrpcServerConfigurationBuilder$.MODULE$.DefaultLegacy();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public GrpcHeaders asciiHeader(String key, Function1 value) {
        return GrpcHeaders.asciiHeader$(this, key, value);
    }

    @Override
    public GrpcHeaders asciiHeaders(scala.collection.immutable.Map map) {
        return GrpcHeaders.asciiHeaders$(this, map);
    }

    @Override
    public GrpcHeaders binaryHeader(String key, Function1 value) {
        return GrpcHeaders.binaryHeader$(this, key, value);
    }

    @Override
    public GrpcHeaders binaryHeaders(scala.collection.immutable.Map map) {
        return GrpcHeaders.binaryHeaders$(this, map);
    }

    @Override
    public GrpcHeaders header(Metadata.Key key, Function1 value) {
        return GrpcHeaders.header$(this, key, value);
    }

    public GrpcServerConfiguration serverConfiguration$access$0() {
        return this.serverConfiguration;
    }

    public GrpcServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    @Override
    public GrpcServerConfigurationBuilder headers_(Function1<List<GrpcHeader<?>>, List<GrpcHeader<?>>> addHeaders) {
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            GrpcProtocolRequestPart x$1 = fresh$macro$1.serverConfiguration().requestPart().copy((List)fresh$macro$2.apply(fresh$macro$1.serverConfiguration().requestPart().headers()), fresh$macro$1.serverConfiguration().requestPart().copy$default$2(), fresh$macro$1.serverConfiguration().requestPart().copy$default$3());
            String x$2 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$3 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolEnginePart x$4 = fresh$macro$1.serverConfiguration().copy$default$3();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$2, x$3, x$4, x$1));
        }).using(addHeaders);
    }

    public GrpcServerConfigurationBuilder callCredentials(Function1<Session, Validation<CallCredentials>> credentials) {
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            Option x$1 = (Option)fresh$macro$2.apply(fresh$macro$1.serverConfiguration().requestPart().callCredentials());
            List<GrpcHeader<?>> x$2 = fresh$macro$1.serverConfiguration().requestPart().copy$default$1();
            int x$3 = fresh$macro$1.serverConfiguration().requestPart().copy$default$3();
            GrpcProtocolRequestPart x$4 = fresh$macro$1.serverConfiguration().requestPart().copy(x$2, (Option<Function1<Session, Validation<CallCredentials>>>)x$1, x$3);
            String x$5 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$6 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolEnginePart x$7 = fresh$macro$1.serverConfiguration().copy$default$3();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$5, x$6, x$7, x$4));
        }).setTo((Object)new Some(credentials));
    }

    public GrpcServerConfigurationBuilder channelCredentials(Function1<Session, Validation<ChannelCredentials>> credentials) {
        GrpcServerConfigurationBuilder fresh$macro$3 = this.useStandardTrustManager();
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            GrpcProtocolChannelCredentials x$1 = (GrpcProtocolChannelCredentials)fresh$macro$2.apply((Object)fresh$macro$1.serverConfiguration().enginePart().channelCredentials());
            int x$2 = fresh$macro$1.serverConfiguration().enginePart().copy$default$1();
            String x$3 = fresh$macro$1.serverConfiguration().enginePart().copy$default$2();
            Option<Map<String, Object>> x$4 = fresh$macro$1.serverConfiguration().enginePart().copy$default$3();
            NegotiationType x$5 = fresh$macro$1.serverConfiguration().enginePart().copy$default$4();
            boolean x$6 = fresh$macro$1.serverConfiguration().enginePart().copy$default$5();
            boolean x$7 = fresh$macro$1.serverConfiguration().enginePart().copy$default$6();
            Option<String> x$8 = fresh$macro$1.serverConfiguration().enginePart().copy$default$7();
            GrpcProtocolEnginePart x$9 = fresh$macro$1.serverConfiguration().enginePart().copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1);
            String x$10 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$11 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$12 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$10, x$11, x$9, x$12));
        }).setTo((Object)GrpcProtocolChannelCredentials$.MODULE$.expression(credentials));
    }

    public GrpcServerConfigurationBuilder channelCredentials(ChannelCredentials credentials) {
        GrpcServerConfigurationBuilder fresh$macro$3 = this.useStandardTrustManager();
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            GrpcProtocolChannelCredentials x$1 = (GrpcProtocolChannelCredentials)fresh$macro$2.apply((Object)fresh$macro$1.serverConfiguration().enginePart().channelCredentials());
            int x$2 = fresh$macro$1.serverConfiguration().enginePart().copy$default$1();
            String x$3 = fresh$macro$1.serverConfiguration().enginePart().copy$default$2();
            Option<Map<String, Object>> x$4 = fresh$macro$1.serverConfiguration().enginePart().copy$default$3();
            NegotiationType x$5 = fresh$macro$1.serverConfiguration().enginePart().copy$default$4();
            boolean x$6 = fresh$macro$1.serverConfiguration().enginePart().copy$default$5();
            boolean x$7 = fresh$macro$1.serverConfiguration().enginePart().copy$default$6();
            Option<String> x$8 = fresh$macro$1.serverConfiguration().enginePart().copy$default$7();
            GrpcProtocolEnginePart x$9 = fresh$macro$1.serverConfiguration().enginePart().copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1);
            String x$10 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$11 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$12 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$10, x$11, x$9, x$12));
        }).setTo((Object)GrpcProtocolChannelCredentials$.MODULE$.constant(credentials));
    }

    public GrpcServerConfigurationBuilder forAddress(String host, int port) {
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            Option x$1 = (Option)fresh$macro$2.apply(fresh$macro$1.serverConfiguration().location());
            String x$2 = fresh$macro$1.serverConfiguration().copy$default$1();
            GrpcProtocolEnginePart x$3 = fresh$macro$1.serverConfiguration().copy$default$3();
            GrpcProtocolRequestPart x$4 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$2, (Option<ServerLocation>)x$1, x$3, x$4));
        }).setTo((Object)new Some((Object)new ServerLocation.Address(host, port)));
    }

    public GrpcServerConfigurationBuilder forTarget(String target) {
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            Option x$1 = (Option)fresh$macro$2.apply(fresh$macro$1.serverConfiguration().location());
            String x$2 = fresh$macro$1.serverConfiguration().copy$default$1();
            GrpcProtocolEnginePart x$3 = fresh$macro$1.serverConfiguration().copy$default$3();
            GrpcProtocolRequestPart x$4 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$2, (Option<ServerLocation>)x$1, x$3, x$4));
        }).setTo((Object)new Some((Object)new ServerLocation.Target(target)));
    }

    public GrpcServerConfigurationBuilder overrideAuthority(String authority) {
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            Option x$1 = (Option)fresh$macro$2.apply(fresh$macro$1.serverConfiguration().enginePart().overrideAuthority());
            int x$2 = fresh$macro$1.serverConfiguration().enginePart().copy$default$1();
            String x$3 = fresh$macro$1.serverConfiguration().enginePart().copy$default$2();
            Option<Map<String, Object>> x$4 = fresh$macro$1.serverConfiguration().enginePart().copy$default$3();
            NegotiationType x$5 = fresh$macro$1.serverConfiguration().enginePart().copy$default$4();
            boolean x$6 = fresh$macro$1.serverConfiguration().enginePart().copy$default$5();
            boolean x$7 = fresh$macro$1.serverConfiguration().enginePart().copy$default$6();
            GrpcProtocolChannelCredentials x$8 = fresh$macro$1.serverConfiguration().enginePart().copy$default$8();
            GrpcProtocolEnginePart x$9 = fresh$macro$1.serverConfiguration().enginePart().copy(x$2, x$3, x$4, x$5, x$6, x$7, (Option<String>)x$1, x$8);
            String x$10 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$11 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$12 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$10, x$11, x$9, x$12));
        }).setTo((Object)new Some((Object)authority));
    }

    public GrpcServerConfigurationBuilder shareChannel() {
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            boolean x$1 = BoxesRunTime.unboxToBoolean((Object)fresh$macro$2.apply((Object)BoxesRunTime.boxToBoolean((boolean)fresh$macro$1.serverConfiguration().enginePart().shareChannel())));
            int x$2 = fresh$macro$1.serverConfiguration().enginePart().copy$default$1();
            String x$3 = fresh$macro$1.serverConfiguration().enginePart().copy$default$2();
            Option<Map<String, Object>> x$4 = fresh$macro$1.serverConfiguration().enginePart().copy$default$3();
            NegotiationType x$5 = fresh$macro$1.serverConfiguration().enginePart().copy$default$4();
            boolean x$6 = fresh$macro$1.serverConfiguration().enginePart().copy$default$6();
            Option<String> x$7 = fresh$macro$1.serverConfiguration().enginePart().copy$default$7();
            GrpcProtocolChannelCredentials x$8 = fresh$macro$1.serverConfiguration().enginePart().copy$default$8();
            GrpcProtocolEnginePart x$9 = fresh$macro$1.serverConfiguration().enginePart().copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8);
            String x$10 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$11 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$12 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$10, x$11, x$9, x$12));
        }).setTo((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public GrpcServerConfigurationBuilder shareSslContext() {
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            boolean x$1 = BoxesRunTime.unboxToBoolean((Object)fresh$macro$2.apply((Object)BoxesRunTime.boxToBoolean((boolean)fresh$macro$1.serverConfiguration().enginePart().shareSslContext())));
            int x$2 = fresh$macro$1.serverConfiguration().enginePart().copy$default$1();
            String x$3 = fresh$macro$1.serverConfiguration().enginePart().copy$default$2();
            Option<Map<String, Object>> x$4 = fresh$macro$1.serverConfiguration().enginePart().copy$default$3();
            NegotiationType x$5 = fresh$macro$1.serverConfiguration().enginePart().copy$default$4();
            boolean x$6 = fresh$macro$1.serverConfiguration().enginePart().copy$default$5();
            Option<String> x$7 = fresh$macro$1.serverConfiguration().enginePart().copy$default$7();
            GrpcProtocolChannelCredentials x$8 = fresh$macro$1.serverConfiguration().enginePart().copy$default$8();
            GrpcProtocolEnginePart x$9 = fresh$macro$1.serverConfiguration().enginePart().copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8);
            String x$10 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$11 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$12 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$10, x$11, x$9, x$12));
        }).setTo((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public GrpcServerConfigurationBuilder useChannelPool(int poolSize) {
        Predef$.MODULE$.require(poolSize > 0, (Function0 & Serializable)() -> "poolSize must be strictly positive");
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            GrpcProtocolEnginePart x$1 = fresh$macro$1.serverConfiguration().enginePart().copy(fresh$macro$2.apply$mcII$sp(fresh$macro$1.serverConfiguration().enginePart().channelPoolSize()), fresh$macro$1.serverConfiguration().enginePart().copy$default$2(), fresh$macro$1.serverConfiguration().enginePart().copy$default$3(), fresh$macro$1.serverConfiguration().enginePart().copy$default$4(), fresh$macro$1.serverConfiguration().enginePart().copy$default$5(), fresh$macro$1.serverConfiguration().enginePart().copy$default$6(), fresh$macro$1.serverConfiguration().enginePart().copy$default$7(), fresh$macro$1.serverConfiguration().enginePart().copy$default$8());
            String x$2 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$3 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$4 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$2, x$3, x$1, x$4));
        }).setTo((Object)BoxesRunTime.boxToInteger((int)poolSize));
    }

    public GrpcServerConfigurationBuilder usePlaintext() {
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            NegotiationType x$1 = (NegotiationType)fresh$macro$2.apply((Object)fresh$macro$1.serverConfiguration().enginePart().negotiationType());
            int x$2 = fresh$macro$1.serverConfiguration().enginePart().copy$default$1();
            String x$3 = fresh$macro$1.serverConfiguration().enginePart().copy$default$2();
            Option<Map<String, Object>> x$4 = fresh$macro$1.serverConfiguration().enginePart().copy$default$3();
            boolean x$5 = fresh$macro$1.serverConfiguration().enginePart().copy$default$5();
            boolean x$6 = fresh$macro$1.serverConfiguration().enginePart().copy$default$6();
            Option<String> x$7 = fresh$macro$1.serverConfiguration().enginePart().copy$default$7();
            GrpcProtocolChannelCredentials x$8 = fresh$macro$1.serverConfiguration().enginePart().copy$default$8();
            GrpcProtocolEnginePart x$9 = fresh$macro$1.serverConfiguration().enginePart().copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8);
            String x$10 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$11 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$12 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$10, x$11, x$9, x$12));
        }).setTo((Object)NegotiationType$UsePlaintext$.MODULE$);
    }

    public GrpcServerConfigurationBuilder useInsecureTrustManager() {
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            NegotiationType x$1 = (NegotiationType)fresh$macro$2.apply((Object)fresh$macro$1.serverConfiguration().enginePart().negotiationType());
            int x$2 = fresh$macro$1.serverConfiguration().enginePart().copy$default$1();
            String x$3 = fresh$macro$1.serverConfiguration().enginePart().copy$default$2();
            Option<Map<String, Object>> x$4 = fresh$macro$1.serverConfiguration().enginePart().copy$default$3();
            boolean x$5 = fresh$macro$1.serverConfiguration().enginePart().copy$default$5();
            boolean x$6 = fresh$macro$1.serverConfiguration().enginePart().copy$default$6();
            Option<String> x$7 = fresh$macro$1.serverConfiguration().enginePart().copy$default$7();
            GrpcProtocolChannelCredentials x$8 = fresh$macro$1.serverConfiguration().enginePart().copy$default$8();
            GrpcProtocolEnginePart x$9 = fresh$macro$1.serverConfiguration().enginePart().copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8);
            String x$10 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$11 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$12 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$10, x$11, x$9, x$12));
        }).setTo((Object)new NegotiationType.UseTransportSecurity(TrustManagerType$InsecureTrustManager$.MODULE$));
    }

    public GrpcServerConfigurationBuilder useStandardTrustManager() {
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            NegotiationType x$1 = (NegotiationType)fresh$macro$2.apply((Object)fresh$macro$1.serverConfiguration().enginePart().negotiationType());
            int x$2 = fresh$macro$1.serverConfiguration().enginePart().copy$default$1();
            String x$3 = fresh$macro$1.serverConfiguration().enginePart().copy$default$2();
            Option<Map<String, Object>> x$4 = fresh$macro$1.serverConfiguration().enginePart().copy$default$3();
            boolean x$5 = fresh$macro$1.serverConfiguration().enginePart().copy$default$5();
            boolean x$6 = fresh$macro$1.serverConfiguration().enginePart().copy$default$6();
            Option<String> x$7 = fresh$macro$1.serverConfiguration().enginePart().copy$default$7();
            GrpcProtocolChannelCredentials x$8 = fresh$macro$1.serverConfiguration().enginePart().copy$default$8();
            GrpcProtocolEnginePart x$9 = fresh$macro$1.serverConfiguration().enginePart().copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8);
            String x$10 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$11 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$12 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$10, x$11, x$9, x$12));
        }).setTo((Object)new NegotiationType.UseTransportSecurity(TrustManagerType$StandardTrustManager$.MODULE$));
    }

    public GrpcServerConfigurationBuilder useCustomCertificateTrustManager(String certificatePath) {
        TrustManagerFactory trustManagerFactory = Ssl$.MODULE$.newTrustManagerFactory((Option)None$.MODULE$, certificatePath, "", (Option)None$.MODULE$);
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            NegotiationType x$1 = (NegotiationType)fresh$macro$2.apply((Object)fresh$macro$1.serverConfiguration().enginePart().negotiationType());
            int x$2 = fresh$macro$1.serverConfiguration().enginePart().copy$default$1();
            String x$3 = fresh$macro$1.serverConfiguration().enginePart().copy$default$2();
            Option<Map<String, Object>> x$4 = fresh$macro$1.serverConfiguration().enginePart().copy$default$3();
            boolean x$5 = fresh$macro$1.serverConfiguration().enginePart().copy$default$5();
            boolean x$6 = fresh$macro$1.serverConfiguration().enginePart().copy$default$6();
            Option<String> x$7 = fresh$macro$1.serverConfiguration().enginePart().copy$default$7();
            GrpcProtocolChannelCredentials x$8 = fresh$macro$1.serverConfiguration().enginePart().copy$default$8();
            GrpcProtocolEnginePart x$9 = fresh$macro$1.serverConfiguration().enginePart().copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8);
            String x$10 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$11 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$12 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$10, x$11, x$9, x$12));
        }).setTo((Object)new NegotiationType.UseTransportSecurity(new TrustManagerType.CustomCertificateTrustManager(trustManagerFactory)));
    }

    public GrpcServerConfigurationBuilder useCustomLoadBalancingPolicy(String policy) {
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        GrpcServerConfigurationBuilder fresh$macro$6 = (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            String x$1 = (String)fresh$macro$2.apply((Object)fresh$macro$1.serverConfiguration().enginePart().defaultLoadBalancingPolicy());
            int x$2 = fresh$macro$1.serverConfiguration().enginePart().copy$default$1();
            Option<Map<String, Object>> x$3 = fresh$macro$1.serverConfiguration().enginePart().copy$default$3();
            NegotiationType x$4 = fresh$macro$1.serverConfiguration().enginePart().copy$default$4();
            boolean x$5 = fresh$macro$1.serverConfiguration().enginePart().copy$default$5();
            boolean x$6 = fresh$macro$1.serverConfiguration().enginePart().copy$default$6();
            Option<String> x$7 = fresh$macro$1.serverConfiguration().enginePart().copy$default$7();
            GrpcProtocolChannelCredentials x$8 = fresh$macro$1.serverConfiguration().enginePart().copy$default$8();
            GrpcProtocolEnginePart x$9 = fresh$macro$1.serverConfiguration().enginePart().copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8);
            String x$10 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$11 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$12 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$10, x$11, x$9, x$12));
        }).setTo((Object)policy);
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$6, (Function2 & Serializable)(fresh$macro$4, fresh$macro$5) -> {
            Option x$13 = (Option)fresh$macro$5.apply(fresh$macro$4.serverConfiguration().enginePart().defaultLoadBalancingPolicyConfig());
            int x$14 = fresh$macro$4.serverConfiguration().enginePart().copy$default$1();
            String x$15 = fresh$macro$4.serverConfiguration().enginePart().copy$default$2();
            NegotiationType x$16 = fresh$macro$4.serverConfiguration().enginePart().copy$default$4();
            boolean x$17 = fresh$macro$4.serverConfiguration().enginePart().copy$default$5();
            boolean x$18 = fresh$macro$4.serverConfiguration().enginePart().copy$default$6();
            Option<String> x$19 = fresh$macro$4.serverConfiguration().enginePart().copy$default$7();
            GrpcProtocolChannelCredentials x$20 = fresh$macro$4.serverConfiguration().enginePart().copy$default$8();
            GrpcProtocolEnginePart x$21 = fresh$macro$4.serverConfiguration().enginePart().copy(x$14, x$15, (Option<Map<String, Object>>)x$13, x$16, x$17, x$18, x$19, x$20);
            String x$22 = fresh$macro$4.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$23 = fresh$macro$4.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$24 = fresh$macro$4.serverConfiguration().copy$default$4();
            return fresh$macro$4.copy(fresh$macro$4.serverConfiguration().copy(x$22, x$23, x$21, x$24));
        }).setTo((Object)None$.MODULE$);
    }

    public GrpcServerConfigurationBuilder useCustomLoadBalancingPolicy(String policy, String jsonPolicyConfig) {
        Object object = JsonParser.parse((String)jsonPolicyConfig);
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException("jsonPolicyConfig must be a JSON object");
        }
        Map map = (Map)object;
        Map policyConfig = map;
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        GrpcServerConfigurationBuilder fresh$macro$6 = (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            String x$1 = (String)fresh$macro$2.apply((Object)fresh$macro$1.serverConfiguration().enginePart().defaultLoadBalancingPolicy());
            int x$2 = fresh$macro$1.serverConfiguration().enginePart().copy$default$1();
            Option<Map<String, Object>> x$3 = fresh$macro$1.serverConfiguration().enginePart().copy$default$3();
            NegotiationType x$4 = fresh$macro$1.serverConfiguration().enginePart().copy$default$4();
            boolean x$5 = fresh$macro$1.serverConfiguration().enginePart().copy$default$5();
            boolean x$6 = fresh$macro$1.serverConfiguration().enginePart().copy$default$6();
            Option<String> x$7 = fresh$macro$1.serverConfiguration().enginePart().copy$default$7();
            GrpcProtocolChannelCredentials x$8 = fresh$macro$1.serverConfiguration().enginePart().copy$default$8();
            GrpcProtocolEnginePart x$9 = fresh$macro$1.serverConfiguration().enginePart().copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8);
            String x$10 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$11 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$12 = fresh$macro$1.serverConfiguration().copy$default$4();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$10, x$11, x$9, x$12));
        }).setTo((Object)policy);
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$6, (Function2 & Serializable)(fresh$macro$4, fresh$macro$5) -> {
            Option x$13 = (Option)fresh$macro$5.apply(fresh$macro$4.serverConfiguration().enginePart().defaultLoadBalancingPolicyConfig());
            int x$14 = fresh$macro$4.serverConfiguration().enginePart().copy$default$1();
            String x$15 = fresh$macro$4.serverConfiguration().enginePart().copy$default$2();
            NegotiationType x$16 = fresh$macro$4.serverConfiguration().enginePart().copy$default$4();
            boolean x$17 = fresh$macro$4.serverConfiguration().enginePart().copy$default$5();
            boolean x$18 = fresh$macro$4.serverConfiguration().enginePart().copy$default$6();
            Option<String> x$19 = fresh$macro$4.serverConfiguration().enginePart().copy$default$7();
            GrpcProtocolChannelCredentials x$20 = fresh$macro$4.serverConfiguration().enginePart().copy$default$8();
            GrpcProtocolEnginePart x$21 = fresh$macro$4.serverConfiguration().enginePart().copy(x$14, x$15, (Option<Map<String, Object>>)x$13, x$16, x$17, x$18, x$19, x$20);
            String x$22 = fresh$macro$4.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$23 = fresh$macro$4.serverConfiguration().copy$default$2();
            GrpcProtocolRequestPart x$24 = fresh$macro$4.serverConfiguration().copy$default$4();
            return fresh$macro$4.copy(fresh$macro$4.serverConfiguration().copy(x$22, x$23, x$21, x$24));
        }).setTo((Object)new Some((Object)policyConfig));
    }

    public GrpcServerConfigurationBuilder usePickFirstLoadBalancingPolicy() {
        return this.useCustomLoadBalancingPolicy("pick_first");
    }

    public GrpcServerConfigurationBuilder usePickRandomLoadBalancingPolicy() {
        return this.useCustomLoadBalancingPolicy(PickRandomLoadBalancerProvider$.MODULE$.PolicyName());
    }

    public GrpcServerConfigurationBuilder useRoundRobinLoadBalancingPolicy() {
        return this.useCustomLoadBalancingPolicy("round_robin");
    }

    public GrpcServerConfigurationBuilder unmatchedInboundMessageBufferSize(int max) {
        GrpcServerConfigurationBuilder fresh$macro$3 = this;
        return (GrpcServerConfigurationBuilder)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable)(fresh$macro$1, fresh$macro$2) -> {
            int x$1 = fresh$macro$2.apply$mcII$sp(fresh$macro$1.serverConfiguration().requestPart().unmatchedInboundMessageBufferSize());
            List<GrpcHeader<?>> x$2 = fresh$macro$1.serverConfiguration().requestPart().copy$default$1();
            Option<Function1<Session, Validation<CallCredentials>>> x$3 = fresh$macro$1.serverConfiguration().requestPart().copy$default$2();
            GrpcProtocolRequestPart x$4 = fresh$macro$1.serverConfiguration().requestPart().copy(x$2, x$3, x$1);
            String x$5 = fresh$macro$1.serverConfiguration().copy$default$1();
            Option<ServerLocation> x$6 = fresh$macro$1.serverConfiguration().copy$default$2();
            GrpcProtocolEnginePart x$7 = fresh$macro$1.serverConfiguration().copy$default$3();
            return fresh$macro$1.copy(fresh$macro$1.serverConfiguration().copy(x$5, x$6, x$7, x$4));
        }).setTo((Object)BoxesRunTime.boxToInteger((int)max));
    }

    public GrpcServerConfiguration build() {
        return this.serverConfiguration();
    }

    public GrpcServerConfigurationBuilder copy(GrpcServerConfiguration serverConfiguration) {
        return new GrpcServerConfigurationBuilder(serverConfiguration);
    }

    public GrpcServerConfiguration copy$default$1() {
        return this.serverConfiguration();
    }

    public String productPrefix() {
        return "GrpcServerConfigurationBuilder";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.serverConfiguration$access$0();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GrpcServerConfigurationBuilder;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "serverConfiguration";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -1306993239, true);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GrpcServerConfigurationBuilder)) return false;
        boolean bl = true;
        if (!bl) return false;
        GrpcServerConfigurationBuilder grpcServerConfigurationBuilder = (GrpcServerConfigurationBuilder)x$1;
        GrpcServerConfiguration grpcServerConfiguration = this.serverConfiguration$access$0();
        GrpcServerConfiguration grpcServerConfiguration2 = grpcServerConfigurationBuilder.serverConfiguration$access$0();
        if (grpcServerConfiguration != null) {
            if (!((Object)grpcServerConfiguration).equals(grpcServerConfiguration2)) return false;
            return true;
        }
        if (grpcServerConfiguration2 == null) return true;
        return false;
    }

    public GrpcServerConfigurationBuilder(GrpcServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
        GrpcHeaders.$init$(this);
        Product.$init$((Product)this);
    }
}

