/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client;

import io.gatling.http.client.Param;
import io.gatling.http.client.Request;
import io.gatling.http.client.SignatureCalculator;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.http.client.ahc.uri.UriEncoder;
import io.gatling.http.client.ahc.util.HttpUtils;
import io.gatling.http.client.ahc.util.MiscUtils;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.realm.BasicRealm;
import io.gatling.http.client.realm.Realm;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.resolver.DefaultNameResolver;
import io.netty.resolver.NameResolver;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class RequestBuilder {
    private static final AsciiString ACCEPT_ALL_HEADER_VALUE = new AsciiString((CharSequence)"*/*");
    private static NameResolver<InetAddress> DEFAULT_NAME_RESOLVER = new DefaultNameResolver((EventExecutor)ImmediateEventExecutor.INSTANCE);
    private final HttpMethod method;
    private final Uri uri;
    private List<Param> queryParams;
    private HttpHeaders headers = new DefaultHttpHeaders(false);
    private List<Cookie> cookies;
    private RequestBodyBuilder<?> bodyBuilder;
    private long requestTimeout;
    private String virtualHost;
    private InetAddress localAddress;
    private Realm realm;
    private ProxyServer proxyServer;
    private SignatureCalculator signatureCalculator;
    private NameResolver<InetAddress> nameResolver = DEFAULT_NAME_RESOLVER;
    private boolean http2Enabled;
    private boolean alpnRequired;
    private boolean http2PriorKnowledge;
    private boolean fixUrlEncoding = true;
    private Charset defaultCharset = StandardCharsets.UTF_8;

    public RequestBuilder(HttpMethod httpMethod, Uri uri) {
        this.method = httpMethod;
        this.uri = uri;
    }

    public RequestBuilder(Request request, Uri uri) {
        this.method = request.getMethod();
        this.uri = uri;
        this.headers = request.getHeaders();
        this.cookies = request.getCookies();
        this.bodyBuilder = request.getBody() != null ? request.getBody().newBuilder() : null;
        this.requestTimeout = request.getRequestTimeout();
        this.virtualHost = request.getVirtualHost();
        this.localAddress = request.getLocalAddress();
        this.realm = request.getRealm();
        this.proxyServer = request.getProxyServer();
        this.signatureCalculator = request.getSignatureCalculator();
        this.nameResolver = request.getNameResolver();
        this.http2Enabled = request.isHttp2Enabled();
        this.alpnRequired = request.isAlpnRequired();
        this.http2PriorKnowledge = request.isHttp2PriorKnowledge();
    }

    public Uri getUri() {
        return this.uri;
    }

    public RequestBuilder setQueryParams(List<Param> list) {
        this.queryParams = list;
        return this;
    }

    public RequestBuilder setHeaders(HttpHeaders httpHeaders) {
        this.headers = httpHeaders;
        return this;
    }

    public RequestBuilder addHeader(CharSequence charSequence, Object object) {
        this.headers.add(charSequence, object);
        return this;
    }

    public RequestBuilder setCookies(List<Cookie> list) {
        this.cookies = list;
        return this;
    }

    public RequestBuilder setBodyBuilder(RequestBodyBuilder<?> requestBodyBuilder) {
        this.bodyBuilder = requestBodyBuilder;
        return this;
    }

    public RequestBuilder setRequestTimeout(long l) {
        this.requestTimeout = l;
        return this;
    }

    public RequestBuilder setVirtualHost(String string) {
        this.virtualHost = string;
        return this;
    }

    public RequestBuilder setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
        return this;
    }

    public RequestBuilder setRealm(Realm realm) {
        this.realm = realm;
        return this;
    }

    public RequestBuilder setProxyServer(ProxyServer proxyServer) {
        this.proxyServer = proxyServer;
        return this;
    }

    public RequestBuilder setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
        return this;
    }

    public RequestBuilder setNameResolver(NameResolver<InetAddress> nameResolver) {
        this.nameResolver = nameResolver;
        return this;
    }

    public RequestBuilder setHttp2Enabled(boolean bl) {
        this.http2Enabled = bl;
        return this;
    }

    public RequestBuilder setAlpnRequired(boolean bl) {
        this.alpnRequired = bl;
        return this;
    }

    public RequestBuilder setHttp2PriorKnowledge(boolean bl) {
        this.http2PriorKnowledge = bl;
        return this;
    }

    public RequestBuilder setFixUrlEncoding(boolean bl) {
        this.fixUrlEncoding = bl;
        return this;
    }

    public RequestBuilder setDefaultCharset(Charset charset) {
        this.defaultCharset = charset;
        return this;
    }

    public Request build() {
        String string;
        Uri uri = UriEncoder.uriEncoder(this.fixUrlEncoding).encode(this.uri, this.queryParams);
        if (!this.headers.contains((CharSequence)HttpHeaderNames.ACCEPT)) {
            this.headers.set((CharSequence)HttpHeaderNames.ACCEPT, (Object)ACCEPT_ALL_HEADER_VALUE);
        }
        if (this.realm instanceof BasicRealm) {
            this.headers.add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)((BasicRealm)this.realm).getAuthorizationHeader());
        }
        if ((string = this.headers.get((CharSequence)HttpHeaderNames.ACCEPT_ENCODING)) != null) {
            this.headers.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpUtils.filterOutBrotliFromAcceptEncoding(string));
        }
        if (MiscUtils.isNonEmpty(this.cookies)) {
            this.headers.set((CharSequence)HttpHeaderNames.COOKIE, (Object)ClientCookieEncoder.LAX.encode(this.cookies));
        }
        if (!this.headers.contains((CharSequence)HttpHeaderNames.ORIGIN)) {
            this.headers.set((CharSequence)HttpHeaderNames.ORIGIN, (Object)HttpUtils.originHeader(this.uri));
        }
        if (!this.headers.contains((CharSequence)HttpHeaderNames.HOST)) {
            this.headers.set((CharSequence)HttpHeaderNames.HOST, (Object)(this.virtualHost != null ? this.virtualHost : HttpUtils.hostHeader(this.uri)));
        }
        RequestBody<?> requestBody = null;
        if (this.bodyBuilder != null) {
            Object object;
            Charset charset = this.defaultCharset;
            String string2 = this.headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            if (string2 != null) {
                object = HttpUtils.extractContentTypeCharsetAttribute(string2);
                if (object != null) {
                    charset = object;
                } else {
                    string2 = string2 + "; charset=" + charset.name();
                }
            }
            if ((object = (requestBody = this.bodyBuilder.build(string2, charset)).getContentType()) != null) {
                this.headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, object);
            }
        }
        return new Request(this.method, uri, this.headers, this.cookies != null ? this.cookies : Collections.emptyList(), requestBody, this.requestTimeout, this.virtualHost, this.localAddress, this.realm, this.proxyServer, this.signatureCalculator, this.nameResolver, this.http2Enabled, this.alpnRequired, this.http2PriorKnowledge);
    }
}

