/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.HttpListener;
import io.gatling.http.client.impl.RequestTimeoutException;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public interface RequestTimeout {
    public static RequestTimeout scheduleRequestTimeout(long l, HttpListener httpListener, EventLoop eventLoop) {
        return l > 0L ? new DefaultRequestTimeout(l, httpListener, eventLoop) : NoopRequestTimeout.INSTANCE;
    }

    public boolean isDone();

    public void cancel();

    public void setChannel(Channel var1);

    public static class NoopRequestTimeout
    implements RequestTimeout {
        private static final NoopRequestTimeout INSTANCE = new NoopRequestTimeout();

        private NoopRequestTimeout() {
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void setChannel(Channel channel) {
        }
    }

    public static class DefaultRequestTimeout
    implements RequestTimeout {
        private final long timeout;
        private final ScheduledFuture<?> f;
        private final HttpListener listener;
        private Channel channel;
        private InetSocketAddress remoteAddress;

        private DefaultRequestTimeout(long l, HttpListener httpListener, EventLoop eventLoop) {
            this.timeout = l;
            this.listener = httpListener;
            this.f = eventLoop.schedule(this::execute, l, TimeUnit.MILLISECONDS);
        }

        private void execute() {
            this.listener.onThrowable(new RequestTimeoutException(this.timeout, this.remoteAddress));
            if (this.channel != null) {
                this.channel.close();
            }
        }

        @Override
        public boolean isDone() {
            return this.f.isDone();
        }

        @Override
        public void cancel() {
            this.f.cancel(true);
        }

        @Override
        public void setChannel(Channel channel) {
            this.channel = channel;
            this.remoteAddress = (InetSocketAddress)channel.remoteAddress();
        }
    }
}

