/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.multipart;

import io.gatling.http.client.ahc.util.HttpUtils;
import io.gatling.http.client.ahc.util.MiscUtils;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBody;
import io.gatling.http.client.body.multipart.Part;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class MultipartFormDataRequestBodyBuilder
extends RequestBodyBuilder<List<Part<?>>> {
    public MultipartFormDataRequestBodyBuilder(List<Part<?>> list) {
        super(list);
    }

    @Override
    public RequestBody<List<Part<?>>> build(String string, Charset charset) {
        byte[] byArray;
        String string2 = HttpUtils.extractContentTypeBoundaryAttribute(string);
        if (string2 != null) {
            byArray = string2.getBytes(StandardCharsets.US_ASCII);
        } else {
            byArray = HttpUtils.computeMultipartBoundary();
            string = HttpUtils.patchContentTypeWithBoundaryAttribute((CharSequence)MiscUtils.withDefault(string, HttpHeaderValues.MULTIPART_FORM_DATA), byArray);
        }
        return new MultipartFormDataRequestBody((List)this.content, string, charset, byArray);
    }
}

