/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client;

import io.gatling.http.client.SignatureCalculator;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.realm.Realm;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.resolver.NameResolver;
import java.net.InetAddress;
import java.util.List;

public class Request {
    private final HttpMethod method;
    private final Uri uri;
    private final HttpHeaders headers;
    private final List<Cookie> cookies;
    private final RequestBody<?> body;
    private final long requestTimeout;
    private final String virtualHost;
    private final InetAddress localAddress;
    private final Realm realm;
    private final ProxyServer proxyServer;
    private final SignatureCalculator signatureCalculator;
    private final NameResolver<InetAddress> nameResolver;
    private final boolean http2Enabled;
    private final boolean alpnRequired;
    private final boolean http2PriorKnowledge;
    private final String wsSubprotocol;

    public Request(HttpMethod httpMethod, Uri uri, HttpHeaders httpHeaders, List<Cookie> list, RequestBody<?> requestBody, long l, String string, InetAddress inetAddress, Realm realm, ProxyServer proxyServer, SignatureCalculator signatureCalculator, NameResolver<InetAddress> nameResolver, boolean bl, boolean bl2, boolean bl3, String string2) {
        this.method = httpMethod;
        this.uri = uri;
        this.headers = httpHeaders;
        this.cookies = list;
        this.body = requestBody;
        this.requestTimeout = l;
        this.virtualHost = string;
        this.localAddress = inetAddress;
        this.realm = realm;
        this.proxyServer = proxyServer;
        this.signatureCalculator = signatureCalculator;
        this.nameResolver = nameResolver;
        this.http2Enabled = bl;
        this.alpnRequired = bl2;
        this.http2PriorKnowledge = bl3;
        this.wsSubprotocol = string2;
    }

    public Request copyWithAlpnRequiredAndPriorKnowledge(boolean bl, boolean bl2) {
        return new Request(this.method, this.uri, this.headers, this.cookies, this.body, this.requestTimeout, this.virtualHost, this.localAddress, this.realm, this.proxyServer, this.signatureCalculator, this.nameResolver, this.http2Enabled, bl, bl2, this.wsSubprotocol);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Uri getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public RequestBody<?> getBody() {
        return this.body;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    public SignatureCalculator getSignatureCalculator() {
        return this.signatureCalculator;
    }

    public NameResolver<InetAddress> getNameResolver() {
        return this.nameResolver;
    }

    public boolean isHttp2Enabled() {
        return this.http2Enabled;
    }

    public boolean isAlpnRequired() {
        return this.alpnRequired;
    }

    public boolean isHttp2PriorKnowledge() {
        return this.http2PriorKnowledge;
    }

    public String getWsSubprotocol() {
        return this.wsSubprotocol;
    }

    public String toString() {
        return "Request{method=" + this.method + ", uri=" + this.uri + ", headers=" + this.headers + ", cookies=" + this.cookies + ", body=" + this.body + ", requestTimeout=" + this.requestTimeout + ", virtualHost='" + this.virtualHost + '\'' + ", localAddress=" + this.localAddress + ", realm=" + this.realm + ", proxyServer=" + this.proxyServer + ", signatureCalculator=" + this.signatureCalculator + ", nameResolver=" + this.nameResolver + ", http2Enabled=" + this.http2Enabled + ", alpnRequired=" + this.alpnRequired + ", http2PriorKnowledge=" + this.http2PriorKnowledge + ", wsSubprotocol=" + this.wsSubprotocol + '}';
    }
}

