/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.realm;

import io.gatling.http.client.ahc.util.MessageDigestUtils;
import io.gatling.http.client.ahc.util.MiscUtils;
import io.gatling.http.client.ahc.util.StringUtils;
import io.gatling.netty.util.ahc.StringBuilderPool;
import io.netty.handler.codec.http.HttpMethod;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.concurrent.ThreadLocalRandom;

class DigestAuth {
    private static final String EMPTY_ENTITY_MD5 = "d41d8cd98f00b204e9800998ecf8427e";
    private final String username;
    private final String password;
    private final String realm;
    private final String nonce;
    private final String opaque;
    private final String algorithm;
    private final String qop;
    private final String nc;
    private final HttpMethod requestMethod;
    private final String realmUri;

    DigestAuth(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, HttpMethod httpMethod, String string9) {
        this.username = string;
        this.password = string2;
        this.realm = string3;
        this.nonce = string4;
        this.opaque = string5;
        this.algorithm = string6;
        this.qop = string7;
        this.nc = string8;
        this.requestMethod = httpMethod;
        this.realmUri = string9;
    }

    public String computeAuthorization() {
        MessageDigest messageDigest = MessageDigestUtils.pooledMd5MessageDigest();
        String string = DigestAuth.newCnonce(messageDigest);
        String string2 = this.newResponse(messageDigest, string);
        StringBuilder stringBuilder = new StringBuilder().append("Digest ");
        DigestAuth.append(stringBuilder, "username", this.username, true);
        DigestAuth.append(stringBuilder, "realm", this.realm, true);
        DigestAuth.append(stringBuilder, "nonce", this.nonce, true);
        DigestAuth.append(stringBuilder, "uri", this.realmUri, true);
        if (MiscUtils.isNonEmpty(this.algorithm)) {
            DigestAuth.append(stringBuilder, "algorithm", this.algorithm, false);
        }
        DigestAuth.append(stringBuilder, "response", string2, true);
        if (this.opaque != null) {
            DigestAuth.append(stringBuilder, "opaque", this.opaque, true);
        }
        if (this.qop != null) {
            DigestAuth.append(stringBuilder, "qop", this.qop, false);
            DigestAuth.append(stringBuilder, "nc", this.nc, false);
            DigestAuth.append(stringBuilder, "cnonce", string, true);
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        return new String(StringUtils.charSequence2Bytes(stringBuilder, StandardCharsets.ISO_8859_1));
    }

    private static String newCnonce(MessageDigest messageDigest) {
        byte[] byArray = new byte[8];
        ThreadLocalRandom.current().nextBytes(byArray);
        byArray = messageDigest.digest(byArray);
        return StringUtils.toHexString(byArray);
    }

    private String newResponse(MessageDigest messageDigest, String string) {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
        byte[] byArray = this.ha1(stringBuilder, messageDigest, string);
        byte[] byArray2 = this.ha2(stringBuilder, this.realmUri, messageDigest);
        StringUtils.appendBase16(stringBuilder, byArray);
        this.appendMiddlePart(stringBuilder, string);
        StringUtils.appendBase16(stringBuilder, byArray2);
        byte[] byArray3 = this.md5FromRecycledStringBuilder(stringBuilder, messageDigest);
        return StringUtils.toHexString(byArray3);
    }

    private byte[] md5FromRecycledStringBuilder(StringBuilder stringBuilder, MessageDigest messageDigest) {
        messageDigest.update(StringUtils.charSequence2ByteBuffer(stringBuilder, StandardCharsets.ISO_8859_1));
        stringBuilder.setLength(0);
        return messageDigest.digest();
    }

    private byte[] ha1(StringBuilder stringBuilder, MessageDigest messageDigest, String string) {
        stringBuilder.append(this.username).append(':').append(this.realm).append(':').append(this.password);
        byte[] byArray = this.md5FromRecycledStringBuilder(stringBuilder, messageDigest);
        if (this.algorithm == null || this.algorithm.equals("MD5")) {
            return byArray;
        }
        if ("MD5-sess".equals(this.algorithm)) {
            StringUtils.appendBase16(stringBuilder, byArray);
            stringBuilder.append(':').append(this.nonce).append(':').append(string);
            return this.md5FromRecycledStringBuilder(stringBuilder, messageDigest);
        }
        throw new UnsupportedOperationException("Digest algorithm not supported: " + this.algorithm);
    }

    private byte[] ha2(StringBuilder stringBuilder, String string, MessageDigest messageDigest) {
        stringBuilder.append(this.requestMethod.name()).append(':').append(string);
        if ("auth-int".equals(this.qop)) {
            stringBuilder.append(':').append(EMPTY_ENTITY_MD5);
        } else if (this.qop != null && !this.qop.equals("auth")) {
            throw new UnsupportedOperationException("Digest qop not supported: " + this.qop);
        }
        return this.md5FromRecycledStringBuilder(stringBuilder, messageDigest);
    }

    private void appendMiddlePart(StringBuilder stringBuilder, String string) {
        stringBuilder.append(':').append(this.nonce).append(':');
        if ("auth".equals(this.qop) || "auth-int".equals(this.qop)) {
            stringBuilder.append(this.nc).append(':').append(string).append(':').append(this.qop).append(':');
        }
    }

    private static void append(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        stringBuilder.append(string).append('=');
        if (bl) {
            stringBuilder.append('\"').append(string2).append('\"');
        } else {
            stringBuilder.append(string2);
        }
        stringBuilder.append(", ");
    }
}

