/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.HttpListener;
import io.gatling.http.client.Request;
import io.gatling.http.client.impl.RequestTimeout;
import io.gatling.http.client.impl.request.WritableRequest;
import io.gatling.http.client.pool.ChannelPoolKey;
import io.netty.handler.ssl.SslContext;
import io.netty.util.ReferenceCounted;

public class HttpTx {
    final Request request;
    final HttpListener listener;
    final RequestTimeout requestTimeout;
    final ChannelPoolKey key;
    private final SslContext sslContext;
    private final SslContext alpnSslContext;
    int remainingTries;
    boolean closeConnection;
    WritableRequest pendingRequestExpectingContinue;

    HttpTx(Request request, HttpListener httpListener, RequestTimeout requestTimeout, ChannelPoolKey channelPoolKey, int n, SslContext sslContext, SslContext sslContext2) {
        this.request = request;
        this.listener = httpListener;
        this.requestTimeout = requestTimeout;
        this.key = channelPoolKey;
        this.remainingTries = n;
        this.sslContext = sslContext;
        this.alpnSslContext = sslContext2;
    }

    SslContext sslContext() {
        if (this.request.isAlpnRequired()) {
            if (this.alpnSslContext == null) {
                throw new UnsupportedOperationException("ALNP is not available (this path shouldn't be possible, please report).");
            }
            return this.alpnSslContext;
        }
        return this.sslContext;
    }

    void releasePendingRequestExpectingContinue() {
        if (this.pendingRequestExpectingContinue != null) {
            Object object = this.pendingRequestExpectingContinue.getContent();
            if (object instanceof ReferenceCounted) {
                ((ReferenceCounted)object).release();
            }
            this.pendingRequestExpectingContinue = null;
        }
    }
}

