/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.impl.Http2AppHandler;
import io.gatling.http.client.impl.Http2Content;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;

public class NotAggregatingInboundHttp2ToHttpAdapter
extends Http2EventAdapter {
    private final Http2Connection connection;
    private final Promise<Void> whenAlpn;

    NotAggregatingInboundHttp2ToHttpAdapter(Http2Connection http2Connection, Promise<Void> promise) {
        ObjectUtil.checkNotNull((Object)http2Connection, (String)"connection");
        this.connection = http2Connection;
        this.whenAlpn = promise;
    }

    public int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) throws Http2Exception {
        Http2Stream http2Stream = this.connection.stream(n);
        if (http2Stream == null) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)("Data Frame received for unknown stream id " + n), (Object[])new Object[0]);
        }
        int n3 = byteBuf.readableBytes();
        channelHandlerContext.fireChannelRead((Object)new Http2Content((HttpContent)new DefaultHttpContent(byteBuf), n, bl));
        return n3 + n2;
    }

    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) throws Http2Exception {
        HttpResponse httpResponse = HttpConversionUtil.toHttpResponse((int)n, (Http2Headers)http2Headers, (boolean)false);
        channelHandlerContext.fireChannelRead((Object)httpResponse);
        if (bl) {
            channelHandlerContext.fireChannelRead((Object)new Http2Content((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT, n, true));
        }
    }

    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) throws Http2Exception {
        this.onHeadersRead(channelHandlerContext, n, http2Headers, n3, bl2);
    }

    public void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) {
        channelHandlerContext.fireUserEventTriggered((Object)new Http2AppHandler.GoAwayFrame(n, l));
    }

    public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
        if (!this.whenAlpn.isDone()) {
            this.whenAlpn.setSuccess(null);
        }
    }
}

