/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl.request;

import io.gatling.http.client.Request;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.impl.request.WritableRequest;
import io.gatling.http.client.proxy.HttpProxyServer;
import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.uri.Uri;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.util.function.Function;

public final class WritableRequestBuilder {
    private static String requestUrl(Uri uri, ProxyServer proxyServer, boolean bl) {
        return bl || proxyServer instanceof HttpProxyServer && !uri.isSecured() ? uri.toUrl() : uri.toRelativeUrl();
    }

    private static WritableRequest buildRequestWithoutBody(HttpMethod httpMethod, String string, HttpHeaders httpHeaders) {
        if (!httpHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && (HttpMethod.POST.equals((Object)httpMethod) || HttpMethod.PUT.equals((Object)httpMethod) || HttpMethod.PATCH.equals((Object)httpMethod))) {
            httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        }
        return new WritableRequest((HttpRequest)new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, string, Unpooled.EMPTY_BUFFER, httpHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE), null);
    }

    private static WritableRequest buildFullRequest(HttpMethod httpMethod, String string, HttpHeaders httpHeaders, ByteBuf byteBuf, long l) {
        if (!httpHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)l);
        }
        return new WritableRequest((HttpRequest)new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, string, byteBuf, httpHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE), null);
    }

    private static WritableRequest buildRequestWithChunkedBody(HttpMethod httpMethod, String string, HttpHeaders httpHeaders, Object object, long l) {
        if (!httpHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && !httpHeaders.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
            if (l >= 0L) {
                httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)l);
            } else {
                httpHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
        }
        return new WritableRequest((HttpRequest)new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, string, httpHeaders), object);
    }

    public static WritableRequest buildRequest(Request request, ByteBufAllocator byteBufAllocator, boolean bl) throws Exception {
        return WritableRequestBuilder.buildRequest0(WritableRequestBuilder.signRequest(request), byteBufAllocator, bl);
    }

    private static Request signRequest(Request request) {
        Function<Request, Request> function = request.getSignatureCalculator();
        return function != null ? function.apply(request.copyWithCopiedHeaders()) : request;
    }

    private static WritableRequest buildRequest0(Request request, ByteBufAllocator byteBufAllocator, boolean bl) throws Exception {
        WritableContent writableContent;
        HttpMethod httpMethod = request.getMethod();
        String string = WritableRequestBuilder.requestUrl(request.getUri(), request.getProxyServer(), bl);
        HttpHeaders httpHeaders = request.getHeaders();
        RequestBody requestBody = request.getBody();
        WritableContent writableContent2 = writableContent = requestBody != null ? requestBody.build(byteBufAllocator) : null;
        if (writableContent == null) {
            return WritableRequestBuilder.buildRequestWithoutBody(httpMethod, string, httpHeaders);
        }
        long l = writableContent.getContentLength();
        Object object = writableContent.getContent();
        if (object instanceof ByteBuf && !httpHeaders.contains((CharSequence)HttpHeaderNames.EXPECT, (CharSequence)HttpHeaderValues.CONTINUE, true)) {
            return WritableRequestBuilder.buildFullRequest(httpMethod, string, httpHeaders, (ByteBuf)object, l);
        }
        return WritableRequestBuilder.buildRequestWithChunkedBody(httpMethod, string, httpHeaders, object, l);
    }
}

