/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.HttpClientConfig;
import io.gatling.http.client.ssl.Tls;
import io.gatling.http.client.uri.Uri;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public final class SslHandlers {
    public static SslHandler newSslHandler(SslContext sslContext, ByteBufAllocator byteBufAllocator, Uri uri, String string, HttpClientConfig httpClientConfig) {
        int n;
        String string2;
        if (string != null) {
            int n2 = string.indexOf(58);
            if (n2 == -1) {
                string2 = string;
                n = uri.getSchemeDefaultPort();
            } else {
                string2 = string.substring(0, n2);
                n = Integer.parseInt(string.substring(n2 + 1));
            }
        } else {
            string2 = uri.getHost();
            n = uri.getExplicitPort();
        }
        return SslHandlers.createSslHandler(sslContext, string2, n, byteBufAllocator, httpClientConfig);
    }

    private static SslHandler createSslHandler(SslContext sslContext, String string, int n, ByteBufAllocator byteBufAllocator, HttpClientConfig httpClientConfig) {
        SSLParameters sSLParameters;
        SSLEngine sSLEngine = httpClientConfig.isEnableSni() ? sslContext.newEngine(byteBufAllocator, Tls.domain(string), n) : sslContext.newEngine(byteBufAllocator);
        sSLEngine.setUseClientMode(true);
        if (httpClientConfig.isEnableHostnameVerification()) {
            sSLParameters = sSLEngine.getSSLParameters();
            sSLParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sSLEngine.setSSLParameters(sSLParameters);
        }
        sSLParameters = new SslHandler(sSLEngine);
        if (httpClientConfig.getHandshakeTimeout() > 0L) {
            sSLParameters.setHandshakeTimeoutMillis(httpClientConfig.getHandshakeTimeout());
        }
        return sSLParameters;
    }
}

