/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.multipart.impl;

import io.gatling.http.client.body.multipart.impl.PartImpl;
import io.gatling.http.client.body.multipart.impl.PartImplState;
import io.gatling.http.client.util.MiscUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.stream.ChunkedInput;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultipartChunkedInput
implements ChunkedInput<HttpContent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipartChunkedInput.class);
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private final List<PartImpl> parts;
    private final long contentLength;
    private final int chunkSize;
    private final AtomicBoolean closed = new AtomicBoolean();
    private boolean endOfInput;
    private long progress = 0L;
    private int currentPartIndex;
    private boolean done = false;

    public MultipartChunkedInput(List<PartImpl> list) {
        this.parts = list;
        this.contentLength = MultipartChunkedInput.computeContentLength(list);
        this.chunkSize = this.contentLength > 0L ? (int)Math.min(this.contentLength, 8192L) : 8192;
    }

    private static long computeContentLength(List<PartImpl> list) {
        try {
            long l = 0L;
            for (PartImpl partImpl : list) {
                long l2 = partImpl.length();
                if (l2 < 0L) {
                    return -1L;
                }
                l += l2;
            }
            return l;
        }
        catch (Exception exception) {
            LOGGER.error("An exception occurred while getting the length of the parts", (Throwable)exception);
            return 0L;
        }
    }

    @Deprecated
    public HttpContent readChunk(ChannelHandlerContext channelHandlerContext) throws Exception {
        return this.readChunk(channelHandlerContext.alloc());
    }

    public HttpContent readChunk(ByteBufAllocator byteBufAllocator) throws Exception {
        if (this.endOfInput) {
            return null;
        }
        ByteBuf byteBuf = byteBufAllocator.heapBuffer(this.chunkSize);
        ChunkedInputState chunkedInputState = this.copyInto(byteBuf);
        this.progress += (long)byteBuf.writerIndex();
        switch (chunkedInputState.ordinal()) {
            case 2: {
                this.endOfInput = true;
                return new DefaultHttpContent(byteBuf);
            }
            case 1: {
                byteBuf.release();
                return null;
            }
            case 0: {
                return new DefaultHttpContent(byteBuf);
            }
        }
        throw new IllegalStateException("Unknown state: " + String.valueOf((Object)chunkedInputState));
    }

    private ChunkedInputState copyInto(ByteBuf byteBuf) throws IOException {
        if (this.done) {
            return ChunkedInputState.STOP;
        }
        while (byteBuf.isWritable() && !this.done) {
            PartImpl partImpl = this.parts.get(this.currentPartIndex);
            partImpl.copyInto(byteBuf);
            if (partImpl.getState() != PartImplState.DONE) continue;
            ++this.currentPartIndex;
            if (this.currentPartIndex != this.parts.size()) continue;
            this.done = true;
        }
        return ChunkedInputState.CONTINUE;
    }

    public boolean isEndOfInput() {
        return this.endOfInput;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            for (PartImpl partImpl : this.parts) {
                MiscUtils.closeSilently(partImpl);
            }
        }
    }

    public long length() {
        return this.contentLength;
    }

    public long progress() {
        return this.progress;
    }

    public String toString() {
        return "MultipartChunkedInput{part.sizes=" + this.parts.size() + ", contentLength=" + this.contentLength + "}";
    }

    private static enum ChunkedInputState {
        CONTINUE,
        SUSPEND,
        STOP;

    }
}

