/*
 * Copyright 2011-2025 GatlingCorp (https://gatling.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.gatling.http.client.body.stringchunks;

import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.string.StringRequestBody;
import io.gatling.netty.util.StringWithCachedBytes;
import java.nio.charset.Charset;
import java.util.List;

public final class StringChunksRequestBodyBuilder
    extends RequestBodyBuilder.Base<List<StringWithCachedBytes>> {

  public StringChunksRequestBodyBuilder(List<StringWithCachedBytes> content) {
    super(content);
  }

  @Override
  public RequestBody build(String contentType, Charset charset, Charset defaultCharset) {
    if (charset == null || charset.equals(defaultCharset)) {
      return new StringChunksRequestBody(content, defaultCharset);
    } else {
      // cached bytes are not for the correct encoding
      return new StringRequestBody(StringWithCachedBytes.toString(content), charset);
    }
  }
}
