/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl.chunk;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public final class ForkedChunkedWriteHandler
extends ChannelDuplexHandler {
    private static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION = new ClosedChannelException();
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private Queue<PendingWrite> queue;
    private volatile ChannelHandlerContext ctx;

    private void allocateQueue() {
        if (this.queue == null) {
            this.queue = new ArrayDeque<PendingWrite>();
        }
    }

    private boolean queueIsEmpty() {
        return this.queue == null || this.queue.isEmpty();
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    public void resumeTransfer() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            return;
        }
        if (channelHandlerContext.executor().inEventLoop()) {
            this.resumeTransfer0(channelHandlerContext);
        } else {
            channelHandlerContext.executor().execute(() -> this.resumeTransfer0(channelHandlerContext));
        }
    }

    private void resumeTransfer0(ChannelHandlerContext channelHandlerContext) {
        try {
            this.doFlush(channelHandlerContext);
        }
        catch (Exception exception) {
            logger.warn("Unexpected exception while sending chunks.", (Throwable)exception);
        }
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (!this.queueIsEmpty() || object instanceof ChunkedInput) {
            this.allocateQueue();
            this.queue.add(new PendingWrite(object, channelPromise));
        } else {
            channelHandlerContext.write(object, channelPromise);
        }
    }

    public void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.doFlush(channelHandlerContext);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.doFlush(channelHandlerContext);
        channelHandlerContext.fireChannelInactive();
    }

    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isWritable()) {
            this.doFlush(channelHandlerContext);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    private void discard(Throwable throwable) {
        PendingWrite pendingWrite;
        if (this.queueIsEmpty()) {
            return;
        }
        while ((pendingWrite = this.queue.poll()) != null) {
            Object object = pendingWrite.msg;
            if (object instanceof ChunkedInput) {
                boolean bl;
                ChunkedInput chunkedInput = (ChunkedInput)object;
                try {
                    bl = chunkedInput.isEndOfInput();
                    ForkedChunkedWriteHandler.closeInput(chunkedInput);
                }
                catch (Exception exception) {
                    ForkedChunkedWriteHandler.closeInput(chunkedInput);
                    pendingWrite.fail(exception);
                    logger.warn("ChunkedInput failed", (Throwable)exception);
                    continue;
                }
                if (!bl) {
                    if (throwable == null) {
                        throwable = CLOSED_CHANNEL_EXCEPTION;
                    }
                    pendingWrite.fail(throwable);
                    continue;
                }
                pendingWrite.success();
                continue;
            }
            if (throwable == null) {
                throwable = CLOSED_CHANNEL_EXCEPTION;
            }
            pendingWrite.fail(throwable);
        }
    }

    private void doFlush(ChannelHandlerContext channelHandlerContext) {
        PendingWrite pendingWrite;
        Channel channel = channelHandlerContext.channel();
        if (!channel.isActive()) {
            this.discard(null);
            return;
        }
        if (this.queueIsEmpty()) {
            channelHandlerContext.flush();
            return;
        }
        boolean bl = true;
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        while (channel.isWritable() && (pendingWrite = this.queue.peek()) != null) {
            if (pendingWrite.promise.isDone()) {
                this.queue.remove();
                continue;
            }
            Object object = pendingWrite.msg;
            if (object instanceof ChunkedInput) {
                boolean bl2;
                boolean bl3;
                ChunkedInput chunkedInput = (ChunkedInput)object;
                Object object2 = null;
                try {
                    object2 = chunkedInput.readChunk(byteBufAllocator);
                    bl3 = chunkedInput.isEndOfInput();
                    bl2 = object2 == null && !bl3;
                }
                catch (Throwable throwable) {
                    this.queue.remove();
                    if (object2 != null) {
                        ReferenceCountUtil.release((Object)object2);
                    }
                    ForkedChunkedWriteHandler.closeInput(chunkedInput);
                    pendingWrite.fail(throwable);
                    break;
                }
                if (bl2) break;
                if (object2 == null) {
                    object2 = Unpooled.EMPTY_BUFFER;
                }
                if (bl3) {
                    this.queue.remove();
                }
                ChannelFuture channelFuture2 = channelHandlerContext.writeAndFlush(object2);
                if (bl3) {
                    if (channelFuture2.isDone()) {
                        ForkedChunkedWriteHandler.handleEndOfInputFuture(channelFuture2, chunkedInput, pendingWrite);
                    } else {
                        channelFuture2.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> ForkedChunkedWriteHandler.handleEndOfInputFuture(channelFuture, chunkedInput, pendingWrite)));
                    }
                } else {
                    boolean bl4;
                    boolean bl5 = bl4 = !channel.isWritable();
                    if (channelFuture2.isDone()) {
                        this.handleFuture(channelFuture2, chunkedInput, pendingWrite, bl4);
                    } else {
                        channelFuture2.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> this.handleFuture((ChannelFuture)channelFuture, (ChunkedInput<?>)chunkedInput, pendingWrite, bl4)));
                    }
                }
                bl = false;
            } else {
                this.queue.remove();
                channelHandlerContext.write(object, pendingWrite.promise);
                bl = true;
            }
            if (channel.isActive()) continue;
            this.discard(new ClosedChannelException());
            break;
        }
        if (bl) {
            channelHandlerContext.flush();
        }
    }

    private static void handleEndOfInputFuture(ChannelFuture channelFuture, ChunkedInput<?> chunkedInput, PendingWrite pendingWrite) {
        if (!channelFuture.isSuccess()) {
            ForkedChunkedWriteHandler.closeInput(chunkedInput);
            pendingWrite.fail(channelFuture.cause());
        } else {
            ForkedChunkedWriteHandler.closeInput(chunkedInput);
            pendingWrite.success();
        }
    }

    private void handleFuture(ChannelFuture channelFuture, ChunkedInput<?> chunkedInput, PendingWrite pendingWrite, boolean bl) {
        if (!channelFuture.isSuccess()) {
            ForkedChunkedWriteHandler.closeInput(chunkedInput);
            pendingWrite.fail(channelFuture.cause());
        } else if (bl && channelFuture.channel().isWritable()) {
            this.resumeTransfer();
        }
    }

    private static void closeInput(ChunkedInput<?> chunkedInput) {
        try {
            chunkedInput.close();
        }
        catch (Throwable throwable) {
            logger.warn("Failed to close a ChunkedInput.", throwable);
        }
    }

    private static final class PendingWrite {
        final Object msg;
        final ChannelPromise promise;

        PendingWrite(Object object, ChannelPromise channelPromise) {
            this.msg = object;
            this.promise = channelPromise;
        }

        void fail(Throwable throwable) {
            ReferenceCountUtil.release((Object)this.msg);
            this.promise.tryFailure(throwable);
        }

        void success() {
            if (this.promise.isDone()) {
                return;
            }
            this.promise.trySuccess();
        }
    }
}

