/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.bytearray;

import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.body.bytearray.ByteArrayRequestBodyBuilder;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.Base64;

public final class ByteArrayRequestBody
extends RequestBody.Base<byte[]> {
    private final String fileName;
    private final Charset charset;

    public ByteArrayRequestBody(byte[] byArray, String string, Charset charset) {
        super(byArray);
        this.fileName = string;
        this.charset = charset;
    }

    @Override
    public WritableContent build(ByteBufAllocator byteBufAllocator) {
        return new WritableContent(Unpooled.wrappedBuffer((byte[])((byte[])this.content)), ((byte[])this.content).length);
    }

    @Override
    public RequestBodyBuilder newBuilder() {
        return new ByteArrayRequestBodyBuilder((byte[])this.content, this.fileName);
    }

    @Override
    public byte[] getBytes() {
        return (byte[])this.content;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String print(int n) {
        return "ByteArrayRequestBody{content (Base64)=" + this.truncate(Base64.getEncoder().encodeToString((byte[])this.content), n) + "}";
    }
}

