/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.HttpClientConfig;
import io.gatling.http.client.WebSocketListener;
import io.gatling.http.client.impl.HttpAppHandler;
import io.gatling.http.client.impl.HttpTx;
import io.gatling.http.client.impl.request.WritableRequest;
import io.gatling.http.client.impl.request.WritableRequestBuilder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketHandler.class);
    private final HttpClientConfig config;
    private HttpTx tx;
    private WebSocketListener wsListener;
    private WebSocketClientHandshaker handshaker;
    private boolean remotelyClosed;

    WebSocketHandler(HttpClientConfig httpClientConfig) {
        this.config = httpClientConfig;
    }

    private void setActive(HttpTx httpTx) {
        this.tx = httpTx;
        this.wsListener = (WebSocketListener)httpTx.listener;
    }

    private void crash(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl) {
        LOGGER.debug("Crash", throwable);
        if (this.tx == null) {
            return;
        }
        this.wsListener.onThrowable(throwable);
        this.tx.requestTimeout.cancel();
        this.tx = null;
        if (bl) {
            channelHandlerContext.close();
        }
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof HttpTx) {
            HttpTx httpTx = (HttpTx)object;
            this.setActive(httpTx);
            if (httpTx.requestTimeout.isDone()) {
                return;
            }
            try {
                WritableRequest writableRequest = WritableRequestBuilder.buildRequest(httpTx.request, channelHandlerContext.alloc(), this.config, false);
                this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)httpTx.request.getUri().toJavaNetURI(), (WebSocketVersion)WebSocketVersion.V13, (String)httpTx.request.getWsSubprotocol(), (boolean)true, (HttpHeaders)writableRequest.getRequest().headers(), (int)Integer.MAX_VALUE);
                this.handshaker.handshake(channelHandlerContext.channel());
            }
            catch (Exception exception) {
                this.crash(channelHandlerContext, exception, true);
            }
        } else {
            LOGGER.debug("ctx.write msg={}", object);
            channelHandlerContext.write(object, channelPromise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        LOGGER.debug("Read msg={}", object);
        Channel channel = channelHandlerContext.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            if (this.tx == null || this.tx.requestTimeout.isDone()) {
                return;
            }
            try {
                FullHttpResponse fullHttpResponse = (FullHttpResponse)object;
                try {
                    this.handshaker.finishHandshake(channel, fullHttpResponse);
                    this.tx.requestTimeout.cancel();
                    this.wsListener.onHttpResponse(fullHttpResponse.status(), fullHttpResponse.headers());
                    this.wsListener.openWebSocket(channel);
                }
                finally {
                    fullHttpResponse.release();
                }
            }
            catch (WebSocketHandshakeException webSocketHandshakeException) {
                this.crash(channelHandlerContext, webSocketHandshakeException, true);
            }
            return;
        }
        WebSocketFrame webSocketFrame = (WebSocketFrame)object;
        try {
            if (webSocketFrame instanceof TextWebSocketFrame) {
                this.wsListener.onTextFrame((TextWebSocketFrame)webSocketFrame);
            } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
                this.wsListener.onBinaryFrame((BinaryWebSocketFrame)webSocketFrame);
            } else if (webSocketFrame instanceof PingWebSocketFrame) {
                channelHandlerContext.writeAndFlush((Object)new PongWebSocketFrame(webSocketFrame.content().retain()));
            } else if (webSocketFrame instanceof PongWebSocketFrame) {
                this.wsListener.onPongFrame((PongWebSocketFrame)webSocketFrame);
            } else if (webSocketFrame instanceof CloseWebSocketFrame) {
                this.remotelyClosed = true;
                this.wsListener.onCloseFrame((CloseWebSocketFrame)webSocketFrame);
                channel.close();
            }
        }
        finally {
            webSocketFrame.release();
        }
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        LOGGER.debug("channelInactive");
        if (!this.remotelyClosed) {
            this.crash(channelHandlerContext, HttpAppHandler.PREMATURE_CLOSE, false);
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        LOGGER.debug("exceptionCaught", throwable);
        this.crash(channelHandlerContext, throwable, true);
    }
}

