/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.HttpClient;
import io.gatling.http.client.HttpClientConfig;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.Request;
import io.gatling.http.client.body.is.InputStreamRequestBody;
import io.gatling.http.client.impl.AllowClientNoContextWebSocketClientCompressionHandler;
import io.gatling.http.client.impl.ChunkedInboundHttp2ToHttpAdapter;
import io.gatling.http.client.impl.DigestAuthHandler;
import io.gatling.http.client.impl.Http2AppHandler;
import io.gatling.http.client.impl.HttpAppHandler;
import io.gatling.http.client.impl.HttpTx;
import io.gatling.http.client.impl.NoopHandler;
import io.gatling.http.client.impl.RequestTimeout;
import io.gatling.http.client.impl.SslHandlers;
import io.gatling.http.client.impl.WebSocketHandler;
import io.gatling.http.client.pool.ChannelPool;
import io.gatling.http.client.pool.ChannelPoolKey;
import io.gatling.http.client.pool.RemoteKey;
import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.proxy.SockProxyServer;
import io.gatling.http.client.realm.DigestRealm;
import io.gatling.http.client.realm.Realm;
import io.gatling.http.client.ssl.Tls;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.Pair;
import io.gatling.netty.util.Transports;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClient
implements HttpClient {
    private static final Logger LOGGER;
    private static final String PINNED_HANDLER = "pinned";
    private static final String PROXY_HANDLER = "proxy";
    private static final String SSL_HANDLER = "ssl";
    public static final String HTTP_CLIENT_CODEC = "http";
    private static final String HTTP2_HANDLER = "http2";
    private static final String INFLATER_HANDLER = "inflater";
    private static final String CHUNKED_WRITER_HANDLER = "chunked-writer";
    private static final String DIGEST_AUTH_HANDLER = "digest";
    private static final String WS_OBJECT_AGGREGATOR = "ws-object-aggregator";
    private static final String WS_COMPRESSION = "ws-compression";
    private static final String WS_FRAME_AGGREGATOR = "ws-frame-aggregator";
    private static final String APP_WS_HANDLER = "app-ws";
    private static final String ALPN_HANDLER = "alpn";
    private static final String APP_HTTP2_HANDLER = "app-http2";
    public static final String APP_HTTP_HANDLER = "app-http";
    private final AtomicBoolean closed = new AtomicBoolean();
    private final HttpClientConfig config;
    private final EventExecutor channelGroupEventExecutor;
    private final ChannelGroup channelGroup;
    private final FastThreadLocal<EventLoopResources> eventLoopResources = new FastThreadLocal();
    private static final Exception IGNORE_REQUEST_TIMEOUT_REACHED_WHILE_TRYING_TO_CONNECT;

    private HttpClientCodec newHttpClientCodec() {
        return new HttpClientCodec(4096, Integer.MAX_VALUE, 8192, false, false, 128);
    }

    private HttpContentDecompressor newHttpContentDecompressor() {
        return new HttpContentDecompressor(){

            protected String getTargetContentEncoding(String string) {
                return string;
            }
        };
    }

    public DefaultHttpClient(HttpClientConfig httpClientConfig) {
        this.config = httpClientConfig;
        this.channelGroupEventExecutor = new DefaultEventExecutor();
        this.channelGroup = new DefaultChannelGroup(this.channelGroupEventExecutor);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.channelGroup.close().awaitUninterruptibly();
            this.channelGroupEventExecutor.shutdownGracefully(0L, 1L, TimeUnit.SECONDS);
            ReferenceCountUtil.release((Object)this.config.getDefaultSslContext());
            ReferenceCountUtil.release((Object)this.config.getDefaultAlpnSslContext());
        }
    }

    @Override
    public void sendRequest(Request request, long l, EventLoop eventLoop, HttpListener httpListener, SslContext sslContext, SslContext sslContext2) {
        if (this.isClosed()) {
            return;
        }
        if (sslContext == null) {
            sslContext = this.config.getDefaultSslContext();
            sslContext2 = this.config.getDefaultAlpnSslContext();
        }
        HttpTx httpTx = this.buildTx(request, l, httpListener, sslContext, sslContext2);
        if (eventLoop.inEventLoop()) {
            this.sendTx(httpTx, eventLoop);
        } else if (!eventLoop.isShutdown()) {
            eventLoop.execute(() -> this.sendTx(httpTx, eventLoop));
        }
    }

    @Override
    public void sendHttp2Requests(Pair<Request, HttpListener>[] pairArray, long l, EventLoop eventLoop, SslContext sslContext, SslContext sslContext2) {
        if (this.isClosed()) {
            return;
        }
        for (Pair<Request, HttpListener> pair : pairArray) {
            pair.getRight().onSend();
        }
        Request request = pairArray[0].getLeft();
        if (request.getUri().isSecured() && request.isHttp2Enabled() && !this.config.isEnableSni()) {
            for (Pair<Request, HttpListener> pair : pairArray) {
                HttpListener httpListener = pair.getRight();
                httpListener.onThrowable(new UnsupportedOperationException("HTTP/2 can't work if SNI is disabled."));
            }
            return;
        }
        if (sslContext == null) {
            sslContext = this.config.getDefaultSslContext();
            sslContext2 = this.config.getDefaultAlpnSslContext();
        }
        ArrayList<HttpTx> arrayList = new ArrayList<HttpTx>();
        for (Pair<Request, HttpListener> pair : pairArray) {
            Request request2 = pair.getLeft();
            HttpListener httpListener = pair.getRight();
            arrayList.add(this.buildTx(request2, l, httpListener, sslContext, sslContext2));
        }
        if (eventLoop.inEventLoop()) {
            this.sendHttp2Txs(arrayList, eventLoop);
        } else if (!eventLoop.isShutdown()) {
            eventLoop.execute(() -> this.sendHttp2Txs(arrayList, eventLoop));
        }
    }

    private EventLoopResources eventLoopResources(EventLoop eventLoop) {
        EventLoopResources eventLoopResources = (EventLoopResources)this.eventLoopResources.get();
        if (eventLoopResources == null) {
            eventLoopResources = new EventLoopResources(eventLoop);
            this.eventLoopResources.set((Object)eventLoopResources);
        }
        return eventLoopResources;
    }

    private HttpTx buildTx(Request request, long l, HttpListener httpListener, SslContext sslContext, SslContext sslContext2) {
        RequestTimeout requestTimeout = RequestTimeout.requestTimeout(request.getRequestTimeout(), httpListener);
        ChannelPoolKey channelPoolKey = new ChannelPoolKey(l, RemoteKey.newKey(request.getUri(), request.getVirtualHost(), request.getProxyServer()));
        return new HttpTx(request, httpListener, requestTimeout, channelPoolKey, sslContext, sslContext2);
    }

    boolean canRetry(HttpTx httpTx) {
        return httpTx.channelState == HttpTx.ChannelState.POOLED && (!(httpTx.request.getBody() instanceof InputStreamRequestBody) || !((InputStreamRequestBody)httpTx.request.getBody()).isConsumed());
    }

    void retry(HttpTx httpTx, EventLoop eventLoop) {
        if (this.isClosed()) {
            return;
        }
        httpTx.channelState = HttpTx.ChannelState.RETRY;
        LOGGER.debug("Retrying with new HTTP/1.1 connection");
        this.sendTx(httpTx, eventLoop);
    }

    void retryHttp2(List<HttpTx> list, EventLoop eventLoop) {
        if (this.isClosed()) {
            return;
        }
        for (HttpTx httpTx : list) {
            httpTx.channelState = HttpTx.ChannelState.RETRY;
        }
        LOGGER.debug("Retrying with new HTTP/2 connection");
        this.sendHttp2Txs(list, eventLoop);
    }

    private void sendTx(HttpTx httpTx, EventLoop eventLoop) {
        EventLoopResources eventLoopResources = this.eventLoopResources(eventLoop);
        Request request = httpTx.request;
        HttpListener httpListener = httpTx.listener;
        RequestTimeout requestTimeout = httpTx.requestTimeout;
        Channel channel = request.getUri().isWebSocket() ? null : eventLoopResources.channelPool.poll(httpTx.key);
        httpListener.onSend();
        if (request.getUri().isSecured() && request.isHttp2Enabled() && !this.config.isEnableSni()) {
            httpListener.onThrowable(new UnsupportedOperationException("HTTP/2 can't work if SNI is disabled."));
            return;
        }
        httpTx.requestTimeout.start(eventLoop);
        if (channel != null && httpTx.channelState != HttpTx.ChannelState.RETRY) {
            this.sendTxWithChannel(httpTx, channel);
        } else {
            this.resolveRemoteAddresses(request, eventLoop, httpListener, requestTimeout).addListener(future -> {
                if (requestTimeout.isDone()) {
                    return;
                }
                if (future.isSuccess()) {
                    List list = (List)future.getNow();
                    if (request.isHttp2Enabled() && httpTx.channelState != HttpTx.ChannelState.RETRY) {
                        String string = httpTx.request.getUri().getHost();
                        Channel channel = eventLoopResources.channelPool.pollCoalescedChannel(httpTx.key.clientId, string, list);
                        if (channel != null) {
                            httpTx.listener.onProtocolAwareness(true);
                            this.sendTxWithChannel(httpTx, channel);
                        } else {
                            this.sendTxWithNewChannel(httpTx, eventLoopResources, eventLoop, list);
                        }
                    } else {
                        this.sendTxWithNewChannel(httpTx, eventLoopResources, eventLoop, list);
                    }
                }
            });
        }
    }

    private void sendHttp2Txs(List<HttpTx> list, EventLoop eventLoop) {
        HttpTx httpTx = list.get(0);
        EventLoopResources eventLoopResources = this.eventLoopResources(eventLoop);
        Request request = httpTx.request;
        HttpListener httpListener = httpTx.listener;
        RequestTimeout requestTimeout = httpTx.requestTimeout;
        for (HttpTx httpTx2 : list) {
            httpTx2.requestTimeout.start(eventLoop);
        }
        this.resolveRemoteAddresses(request, eventLoop, httpListener, requestTimeout).addListener(future -> {
            if (requestTimeout.isDone()) {
                return;
            }
            if (future.isSuccess()) {
                List list2 = (List)future.getNow();
                String string = httpTx.request.getUri().getHost();
                Channel channel = eventLoopResources.channelPool.pollCoalescedChannel(httpTx.key.clientId, string, list2);
                if (channel != null) {
                    this.sendHttp2TxsWithChannel(list, channel);
                } else {
                    this.sendHttp2TxsWithNewChannel(list, eventLoopResources, eventLoop, list2);
                }
            }
        });
    }

    private void sendTxWithChannel(HttpTx httpTx, Channel channel) {
        if (this.isClosed()) {
            return;
        }
        if (ChannelPool.isHttp2(channel)) {
            httpTx.listener.onProtocolAwareness(true);
        }
        httpTx.requestTimeout.setChannel(channel);
        Realm realm = httpTx.request.getRealm();
        if (realm instanceof DigestRealm) {
            channel.pipeline().addBefore(APP_HTTP_HANDLER, DIGEST_AUTH_HANDLER, (ChannelHandler)new DigestAuthHandler(httpTx, (DigestRealm)realm, this.config));
        }
        channel.write((Object)httpTx);
    }

    private void sendHttp2TxsWithChannel(List<HttpTx> list, Channel channel) {
        if (this.isClosed()) {
            return;
        }
        for (HttpTx httpTx : list) {
            httpTx.requestTimeout.setChannel(channel);
            httpTx.listener.onProtocolAwareness(true);
            channel.write((Object)httpTx);
        }
    }

    private Future<List<InetSocketAddress>> resolveRemoteAddresses(Request request, EventLoop eventLoop, HttpListener httpListener, RequestTimeout requestTimeout) {
        if (request.getProxyServer() != null) {
            ProxyServer proxyServer = request.getProxyServer();
            Uri uri = request.getUri();
            InetSocketAddress inetSocketAddress = proxyServer instanceof SockProxyServer || uri.isSecured() || uri.isWebSocket() ? InetSocketAddress.createUnresolved(request.getUri().getHost(), request.getUri().getExplicitPort()) : request.getProxyServer().getAddress();
            return ImmediateEventExecutor.INSTANCE.newSucceededFuture(Collections.singletonList(inetSocketAddress));
        }
        Promise promise = eventLoop.newPromise();
        request.getNameResolver().resolveAll(request.getUri().getHost(), (Promise<List<InetAddress>>)eventLoop.newPromise(), httpListener).addListener(future -> {
            if (future.isSuccess()) {
                List list = ((List)future.getNow()).stream().map(inetAddress -> new InetSocketAddress((InetAddress)inetAddress, request.getUri().getExplicitPort())).collect(Collectors.toList());
                promise.setSuccess(list);
            } else {
                if (!requestTimeout.isDone()) {
                    httpListener.onThrowable(future.cause());
                }
                promise.setFailure(future.cause());
                requestTimeout.cancel();
            }
        });
        return promise;
    }

    private void sendTxWithNewChannel(HttpTx httpTx, EventLoopResources eventLoopResources, EventLoop eventLoop, List<InetSocketAddress> list) {
        httpTx.channelState = HttpTx.ChannelState.NEW;
        this.openNewChannel(httpTx.request, eventLoop, eventLoopResources, list, httpTx.listener, httpTx.requestTimeout).addListener(future -> {
            if (future.isSuccess()) {
                Channel channel = (Channel)future.getNow();
                if (httpTx.requestTimeout.isDone()) {
                    channel.close();
                    return;
                }
                this.channelGroup.add((Object)channel);
                eventLoopResources.channelPool.register(channel, httpTx.key);
                if (httpTx.request.getUri().isSecured()) {
                    LOGGER.debug("Installing SslHandler for {}", (Object)httpTx.request.getUri());
                    this.installSslHandler(httpTx, channel).addListener(future2 -> {
                        if (httpTx.requestTimeout.isDone() || !future2.isSuccess()) {
                            channel.close();
                            return;
                        }
                        if (httpTx.request.isAlpnRequired()) {
                            LOGGER.debug("Installing Http2Handler for {}", (Object)httpTx.request.getUri());
                            this.installHttp2Handler(httpTx, channel, eventLoopResources.channelPool).addListener(future -> {
                                if (httpTx.requestTimeout.isDone() || !future.isSuccess()) {
                                    channel.close();
                                    return;
                                }
                                this.sendTxWithChannel(httpTx, channel);
                            });
                        } else {
                            this.sendTxWithChannel(httpTx, channel);
                        }
                    });
                } else {
                    this.sendTxWithChannel(httpTx, channel);
                }
            }
        });
    }

    private void sendHttp2TxsWithNewChannel(List<HttpTx> list, EventLoopResources eventLoopResources, EventLoop eventLoop, List<InetSocketAddress> list2) {
        HttpTx httpTx = list.get(0);
        this.openNewChannel(httpTx.request, eventLoop, eventLoopResources, list2, httpTx.listener, httpTx.requestTimeout).addListener(future -> {
            if (future.isSuccess()) {
                Channel channel = (Channel)future.getNow();
                if (httpTx.requestTimeout.isDone()) {
                    channel.close();
                    return;
                }
                this.channelGroup.add((Object)channel);
                eventLoopResources.channelPool.register(channel, httpTx.key);
                LOGGER.debug("Installing SslHandler for {}", (Object)httpTx.request.getUri());
                this.installSslHandler(httpTx, channel).addListener(future2 -> {
                    if (httpTx.requestTimeout.isDone() || !future2.isSuccess()) {
                        channel.close();
                        return;
                    }
                    LOGGER.debug("Installing Http2Handler for {}", (Object)httpTx.request.getUri());
                    this.installHttp2Handler(httpTx, channel, eventLoopResources.channelPool).addListener(future -> {
                        if (httpTx.requestTimeout.isDone() || !future.isSuccess()) {
                            channel.close();
                            return;
                        }
                        this.sendHttp2TxsWithChannel(list, channel);
                    });
                });
            }
        });
    }

    private Bootstrap bootstrap(Request request, EventLoopResources eventLoopResources) {
        Uri uri = request.getUri();
        ProxyServer proxyServer = request.getProxyServer();
        if (proxyServer != null) {
            if (uri.isWebSocket()) {
                return eventLoopResources.getWsBootstrapWithProxy(proxyServer);
            }
            if (proxyServer instanceof SockProxyServer || uri.isSecured()) {
                return eventLoopResources.getHttp1BootstrapWithProxy(proxyServer);
            }
        }
        if (uri.isWebSocket()) {
            return eventLoopResources.wsBootstrap;
        }
        if (request.isAlpnRequired() && request.getUri().isSecured()) {
            return eventLoopResources.http2Bootstrap;
        }
        return eventLoopResources.http1Bootstrap;
    }

    private static InetSocketAddress localAddressWithRandomPort(InetAddress inetAddress) {
        return inetAddress != null ? new InetSocketAddress(inetAddress, 0) : null;
    }

    private Future<Channel> openNewChannel(Request request, EventLoop eventLoop, EventLoopResources eventLoopResources, List<InetSocketAddress> list, HttpListener httpListener, RequestTimeout requestTimeout) {
        Bootstrap bootstrap = this.bootstrap(request, eventLoopResources);
        Promise promise = eventLoop.newPromise();
        this.openNewChannelRec(list, DefaultHttpClient.localAddressWithRandomPort(request.getLocalIpV4Address()), DefaultHttpClient.localAddressWithRandomPort(request.getLocalIpV6Address()), 0, (Promise<Channel>)promise, bootstrap, httpListener, requestTimeout);
        return promise;
    }

    private void openNewChannelRec(List<InetSocketAddress> list, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, int n, Promise<Channel> promise, Bootstrap bootstrap, HttpListener httpListener, RequestTimeout requestTimeout) {
        InetSocketAddress inetSocketAddress3;
        if (this.isClosed()) {
            return;
        }
        InetSocketAddress inetSocketAddress4 = list.get(n);
        boolean bl = false;
        if (inetSocketAddress == null && inetSocketAddress2 == null) {
            inetSocketAddress3 = null;
        } else if (inetSocketAddress4.getAddress() instanceof Inet6Address) {
            if (inetSocketAddress2 == null) {
                inetSocketAddress3 = null;
                bl = true;
            } else {
                inetSocketAddress3 = inetSocketAddress2;
            }
        } else {
            InetSocketAddress inetSocketAddress5 = inetSocketAddress3 = NetUtil.isIpV6AddressesPreferred() && inetSocketAddress2 != null ? inetSocketAddress2 : inetSocketAddress;
        }
        if (bl) {
            int n2 = n + 1;
            if (n2 < list.size()) {
                this.openNewChannelRec(list, inetSocketAddress, null, n2, promise, bootstrap, httpListener, requestTimeout);
            } else {
                requestTimeout.cancel();
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Can't connect to IPv6 remote " + inetSocketAddress4 + " + from IPv4 local one " + inetSocketAddress);
                httpListener.onThrowable(unsupportedOperationException);
                promise.setFailure((Throwable)unsupportedOperationException);
            }
        } else {
            ChannelFuture channelFuture = bootstrap.connect((SocketAddress)inetSocketAddress4, (SocketAddress)inetSocketAddress3);
            channelFuture.addListener(future -> {
                if (future.isSuccess()) {
                    promise.setSuccess((Object)channelFuture.channel());
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Failed to connect to remoteAddress=" + inetSocketAddress4 + " from localAddress=" + inetSocketAddress3, future.cause());
                    }
                    if (requestTimeout.isDone()) {
                        promise.setFailure((Throwable)IGNORE_REQUEST_TIMEOUT_REACHED_WHILE_TRYING_TO_CONNECT);
                        return;
                    }
                    int n2 = n + 1;
                    if (n2 < list.size()) {
                        this.openNewChannelRec(list, inetSocketAddress, inetSocketAddress2, n2, promise, bootstrap, httpListener, requestTimeout);
                    } else {
                        requestTimeout.cancel();
                        httpListener.onThrowable(future.cause());
                        promise.setFailure(future.cause());
                    }
                }
            });
        }
    }

    private Future<Channel> installSslHandler(HttpTx httpTx, Channel channel) {
        try {
            SslHandler sslHandler = SslHandlers.newSslHandler(httpTx.sslContext(), channel.alloc(), httpTx.request.getUri(), httpTx.request.getVirtualHost(), this.config);
            ChannelPipeline channelPipeline = channel.pipeline();
            String string = channelPipeline.get(PROXY_HANDLER) != null ? PROXY_HANDLER : PINNED_HANDLER;
            channelPipeline.addAfter(string, SSL_HANDLER, (ChannelHandler)sslHandler);
            return sslHandler.handshakeFuture().addListener(future -> {
                if (httpTx.requestTimeout.isDone()) {
                    return;
                }
                if (future.isSuccess()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("TLS handshake successful: protocol={} cipher suite={}", (Object)sslHandler.engine().getSession().getProtocol(), (Object)sslHandler.engine().getSession().getCipherSuite());
                    }
                } else {
                    httpTx.requestTimeout.cancel();
                    httpTx.listener.onThrowable(future.cause());
                }
            });
        }
        catch (RuntimeException runtimeException) {
            httpTx.requestTimeout.cancel();
            httpTx.listener.onThrowable(runtimeException);
            return new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE).setFailure((Throwable)runtimeException);
        }
    }

    private Future<Channel> installHttp2Handler(final HttpTx httpTx, final Channel channel, final ChannelPool channelPool) {
        final Promise promise = channel.eventLoop().newPromise();
        channel.pipeline().addAfter(SSL_HANDLER, ALPN_HANDLER, (ChannelHandler)new ApplicationProtocolNegotiationHandler("http/1.1"){

            protected void configurePipeline(ChannelHandlerContext channelHandlerContext, String string) throws Exception {
                switch (string) {
                    case "h2": {
                        LOGGER.debug("ALPN led to HTTP/2 with remote {}", (Object)httpTx.request.getUri().getHost());
                        httpTx.listener.onProtocolAwareness(true);
                        DefaultHttp2Connection defaultHttp2Connection = new DefaultHttp2Connection(false);
                        HttpToHttp2ConnectionHandler httpToHttp2ConnectionHandler = new HttpToHttp2ConnectionHandlerBuilder().initialSettings(Http2Settings.defaultSettings()).connection((Http2Connection)defaultHttp2Connection).frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener((Http2Connection)defaultHttp2Connection, (Http2FrameListener)new ChunkedInboundHttp2ToHttpAdapter((Http2Connection)defaultHttp2Connection, false, true, promise){

                            public void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) throws Http2Exception {
                                channelHandlerContext.fireChannelRead((Object)new Http2AppHandler.GoAwayFrame(n, l));
                            }
                        })).build();
                        channelHandlerContext.pipeline().addLast(DefaultHttpClient.HTTP2_HANDLER, (ChannelHandler)httpToHttp2ConnectionHandler).addLast(DefaultHttpClient.APP_HTTP2_HANDLER, (ChannelHandler)new Http2AppHandler(DefaultHttpClient.this, (Http2Connection)defaultHttp2Connection, (Http2ConnectionHandler)httpToHttp2ConnectionHandler, channelPool, DefaultHttpClient.this.config));
                        channelPool.offer(channel);
                        SslHandler sslHandler = (SslHandler)channelHandlerContext.pipeline().get(DefaultHttpClient.SSL_HANDLER);
                        Set<String> set = Tls.extractSubjectAlternativeNames(sslHandler.engine());
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("TLS handshake successful: protocol={} cipher suite={}", (Object)sslHandler.engine().getSession().getProtocol(), (Object)sslHandler.engine().getSession().getCipherSuite());
                        }
                        if (set.isEmpty()) break;
                        channelPool.addCoalescedChannel(set, (InetSocketAddress)channel.remoteAddress(), channel, httpTx.key);
                        break;
                    }
                    case "http/1.1": {
                        LOGGER.debug("ALPN led to HTTP/1 with remote {}", (Object)httpTx.request.getUri().getHost());
                        if (httpTx.request.isHttp2PriorKnowledge()) {
                            IllegalStateException illegalStateException = new IllegalStateException("HTTP/2 Prior knowledge was set on host " + httpTx.request.getUri().getHost() + " but it only supports HTTP/1");
                            promise.setFailure((Throwable)illegalStateException);
                            throw illegalStateException;
                        }
                        httpTx.listener.onProtocolAwareness(false);
                        channelHandlerContext.pipeline().addBefore(DefaultHttpClient.CHUNKED_WRITER_HANDLER, DefaultHttpClient.HTTP_CLIENT_CODEC, (ChannelHandler)DefaultHttpClient.this.newHttpClientCodec()).addBefore(DefaultHttpClient.CHUNKED_WRITER_HANDLER, DefaultHttpClient.INFLATER_HANDLER, (ChannelHandler)DefaultHttpClient.this.newHttpContentDecompressor()).addAfter(DefaultHttpClient.CHUNKED_WRITER_HANDLER, DefaultHttpClient.APP_HTTP_HANDLER, (ChannelHandler)new HttpAppHandler(DefaultHttpClient.this, channelPool, DefaultHttpClient.this.config));
                        promise.setSuccess((Object)channelHandlerContext.channel());
                        break;
                    }
                    default: {
                        IllegalStateException illegalStateException = new IllegalStateException("Unknown protocol: " + string);
                        promise.setFailure((Throwable)illegalStateException);
                        channelHandlerContext.close();
                        throw illegalStateException;
                    }
                }
            }
        });
        promise.addListener(future -> {
            if (!future.isSuccess()) {
                httpTx.listener.onThrowable(future.cause());
            }
        });
        return promise;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void flushClientIdChannels(long l, EventLoop eventLoop) {
        if (eventLoop.inEventLoop()) {
            this.eventLoopResources(eventLoop).channelPool.flushClientIdChannelPoolPartitions(l);
        } else if (!eventLoop.isShutdown()) {
            eventLoop.execute(() -> this.eventLoopResources(eventLoop).channelPool.flushClientIdChannelPoolPartitions(l));
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        LOGGER = LoggerFactory.getLogger(DefaultHttpClient.class);
        IGNORE_REQUEST_TIMEOUT_REACHED_WHILE_TRYING_TO_CONNECT = new TimeoutException("Request timeout reached while trying to connect, should be ignored"){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
    }

    private class EventLoopResources {
        private final Bootstrap http1Bootstrap;
        private final Bootstrap http2Bootstrap;
        private final Bootstrap wsBootstrap;
        private final ChannelPool channelPool = new ChannelPool();

        private void addHttpHandlers(Channel channel) {
            channel.pipeline().addLast(DefaultHttpClient.HTTP_CLIENT_CODEC, (ChannelHandler)DefaultHttpClient.this.newHttpClientCodec()).addLast(DefaultHttpClient.INFLATER_HANDLER, (ChannelHandler)DefaultHttpClient.this.newHttpContentDecompressor()).addLast(DefaultHttpClient.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ChunkedWriteHandler()).addLast(DefaultHttpClient.APP_HTTP_HANDLER, (ChannelHandler)new HttpAppHandler(DefaultHttpClient.this, this.channelPool, DefaultHttpClient.this.config));
            if (DefaultHttpClient.this.config.getAdditionalChannelInitializer() != null) {
                DefaultHttpClient.this.config.getAdditionalChannelInitializer().accept(channel);
            }
        }

        private void addWsHandlers(Channel channel) {
            channel.pipeline().addLast(DefaultHttpClient.HTTP_CLIENT_CODEC, (ChannelHandler)DefaultHttpClient.this.newHttpClientCodec()).addLast(DefaultHttpClient.WS_OBJECT_AGGREGATOR, (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE)).addLast(DefaultHttpClient.WS_COMPRESSION, (ChannelHandler)AllowClientNoContextWebSocketClientCompressionHandler.INSTANCE).addLast(DefaultHttpClient.WS_FRAME_AGGREGATOR, (ChannelHandler)new WebSocketFrameAggregator(Integer.MAX_VALUE)).addLast(DefaultHttpClient.APP_WS_HANDLER, (ChannelHandler)new WebSocketHandler(DefaultHttpClient.this.config));
            if (DefaultHttpClient.this.config.getAdditionalChannelInitializer() != null) {
                DefaultHttpClient.this.config.getAdditionalChannelInitializer().accept(channel);
            }
        }

        private EventLoopResources(EventLoop eventLoop) {
            long l = DefaultHttpClient.this.config.getChannelPoolIdleCleanerPeriod();
            long l2 = DefaultHttpClient.this.config.getChannelPoolIdleTimeout() * 1000000L;
            eventLoop.scheduleWithFixedDelay(() -> this.channelPool.closeIdleChannels(l2), l, l, TimeUnit.MILLISECONDS);
            this.http1Bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(Transports.newSocketChannelFactory((boolean)DefaultHttpClient.this.config.isUseNativeTransport()))).group((EventLoopGroup)eventLoop)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)DefaultHttpClient.this.config.getConnectTimeout()))).option(ChannelOption.SO_REUSEADDR, (Object)DefaultHttpClient.this.config.isSoReuseAddress())).option(ChannelOption.TCP_NODELAY, (Object)DefaultHttpClient.this.config.isTcpNoDelay())).option(ChannelOption.SO_KEEPALIVE, (Object)DefaultHttpClient.this.config.isSoKeepAlive())).resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    channel.pipeline().addLast(DefaultHttpClient.PINNED_HANDLER, (ChannelHandler)NoopHandler.INSTANCE);
                    EventLoopResources.this.addHttpHandlers(channel);
                }
            });
            this.http2Bootstrap = (Bootstrap)this.http1Bootstrap.clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    channel.pipeline().addLast(DefaultHttpClient.PINNED_HANDLER, (ChannelHandler)NoopHandler.INSTANCE).addLast(DefaultHttpClient.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ChunkedWriteHandler());
                    if (DefaultHttpClient.this.config.getAdditionalChannelInitializer() != null) {
                        DefaultHttpClient.this.config.getAdditionalChannelInitializer().accept(channel);
                    }
                }
            });
            this.wsBootstrap = (Bootstrap)this.http1Bootstrap.clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    channel.pipeline().addLast(DefaultHttpClient.PINNED_HANDLER, (ChannelHandler)NoopHandler.INSTANCE);
                    EventLoopResources.this.addWsHandlers(channel);
                }
            });
        }

        private Bootstrap getHttp1BootstrapWithProxy(final ProxyServer proxyServer) {
            return (Bootstrap)this.http1Bootstrap.clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    channel.pipeline().addLast(DefaultHttpClient.PINNED_HANDLER, (ChannelHandler)NoopHandler.INSTANCE).addLast(DefaultHttpClient.PROXY_HANDLER, (ChannelHandler)proxyServer.newHandler());
                    EventLoopResources.this.addHttpHandlers(channel);
                }
            });
        }

        private Bootstrap getWsBootstrapWithProxy(final ProxyServer proxyServer) {
            return (Bootstrap)this.wsBootstrap.clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    channel.pipeline().addLast(DefaultHttpClient.PINNED_HANDLER, (ChannelHandler)NoopHandler.INSTANCE).addLast(DefaultHttpClient.PROXY_HANDLER, (ChannelHandler)proxyServer.newHandler());
                    EventLoopResources.this.addWsHandlers(channel);
                }
            });
        }
    }
}

