/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client;

import io.gatling.http.client.Request;
import io.gatling.http.client.SignatureCalculator;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.realm.BasicRealm;
import io.gatling.http.client.realm.Realm;
import io.gatling.http.client.resolver.InetAddressNameResolver;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.HttpUtils;
import io.gatling.http.client.util.MiscUtils;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.util.AsciiString;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class RequestBuilder {
    private static final AsciiString ACCEPT_ALL_HEADER_VALUE = new AsciiString((CharSequence)"*/*");
    private final HttpMethod method;
    private final Uri uri;
    private final InetAddressNameResolver nameResolver;
    private HttpHeaders headers = new DefaultHttpHeaders(false);
    private List<Cookie> cookies;
    private RequestBodyBuilder<?> bodyBuilder;
    private long requestTimeout;
    private String virtualHost;
    private InetAddress localIpV4Address;
    private InetAddress localIpV6Address;
    private Realm realm;
    private ProxyServer proxyServer;
    private SignatureCalculator signatureCalculator;
    private boolean http2Enabled;
    private boolean alpnRequired;
    private boolean http2PriorKnowledge;
    private String wsSubprotocol;
    private Charset defaultCharset = StandardCharsets.UTF_8;

    public RequestBuilder(HttpMethod httpMethod, Uri uri, InetAddressNameResolver inetAddressNameResolver) {
        this.method = httpMethod;
        this.uri = uri;
        this.nameResolver = inetAddressNameResolver;
    }

    public RequestBuilder(Request request, Uri uri) {
        this(request.getMethod(), uri, request.getNameResolver());
        this.headers = request.getHeaders();
        this.cookies = request.getCookies();
        this.bodyBuilder = request.getBody() != null ? request.getBody().newBuilder() : null;
        this.requestTimeout = request.getRequestTimeout();
        this.virtualHost = request.getVirtualHost();
        this.localIpV4Address = request.getLocalIpV4Address();
        this.localIpV6Address = request.getLocalIpV6Address();
        this.realm = request.getRealm();
        this.proxyServer = request.getProxyServer();
        this.signatureCalculator = request.getSignatureCalculator();
        this.http2Enabled = request.isHttp2Enabled();
        this.alpnRequired = request.isAlpnRequired();
        this.http2PriorKnowledge = request.isHttp2PriorKnowledge();
        this.wsSubprotocol = request.getWsSubprotocol();
    }

    public Uri getUri() {
        return this.uri;
    }

    public RequestBuilder setHeaders(HttpHeaders httpHeaders) {
        this.headers = httpHeaders;
        return this;
    }

    public RequestBuilder addHeader(CharSequence charSequence, Object object) {
        this.headers.add(charSequence, object);
        return this;
    }

    public RequestBuilder setCookies(List<Cookie> list) {
        this.cookies = list;
        return this;
    }

    public RequestBuilder setBodyBuilder(RequestBodyBuilder<?> requestBodyBuilder) {
        this.bodyBuilder = requestBodyBuilder;
        return this;
    }

    public RequestBuilder setRequestTimeout(long l) {
        this.requestTimeout = l;
        return this;
    }

    public RequestBuilder setVirtualHost(String string) {
        this.virtualHost = string;
        return this;
    }

    public RequestBuilder setLocalIpV4Address(InetAddress inetAddress) {
        this.localIpV4Address = inetAddress;
        return this;
    }

    public RequestBuilder setLocalIpV6Address(InetAddress inetAddress) {
        this.localIpV6Address = inetAddress;
        return this;
    }

    public RequestBuilder setRealm(Realm realm) {
        this.realm = realm;
        return this;
    }

    public RequestBuilder setProxyServer(ProxyServer proxyServer) {
        this.proxyServer = proxyServer;
        return this;
    }

    public RequestBuilder setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
        return this;
    }

    public RequestBuilder setHttp2Enabled(boolean bl) {
        this.http2Enabled = bl;
        return this;
    }

    public RequestBuilder setAlpnRequired(boolean bl) {
        this.alpnRequired = bl;
        return this;
    }

    public RequestBuilder setHttp2PriorKnowledge(boolean bl) {
        this.http2PriorKnowledge = bl;
        return this;
    }

    public RequestBuilder setDefaultCharset(Charset charset) {
        this.defaultCharset = charset;
        return this;
    }

    public RequestBuilder setWsSubprotocol(String string) {
        this.wsSubprotocol = string;
        return this;
    }

    public Request build() {
        Charset charset;
        String string;
        String string2;
        Object object;
        String string3;
        String string4;
        if (!this.headers.contains((CharSequence)HttpHeaderNames.ACCEPT)) {
            this.headers.set((CharSequence)HttpHeaderNames.ACCEPT, (Object)ACCEPT_ALL_HEADER_VALUE);
        }
        if (this.realm instanceof BasicRealm) {
            this.headers.add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)((BasicRealm)this.realm).getAuthorizationHeader());
        }
        if ((string4 = this.headers.get((CharSequence)HttpHeaderNames.ACCEPT_ENCODING)) != null && (string3 = HttpUtils.filterOutBrotliFromAcceptEncoding(string4)) != null) {
            this.headers.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)string3);
        }
        if (MiscUtils.isNonEmpty(this.cookies)) {
            this.headers.set((CharSequence)HttpHeaderNames.COOKIE, (Object)ClientCookieEncoder.LAX.encode(this.cookies));
        }
        if (!((string3 = this.headers.get((CharSequence)HttpHeaderNames.REFERER)) == null || HttpMethod.GET.equals((Object)this.method) || HttpMethod.HEAD.equals((Object)this.method) || this.headers.contains((CharSequence)HttpHeaderNames.ORIGIN) || (object = HttpUtils.originHeader(string3)) == null)) {
            this.headers.set((CharSequence)HttpHeaderNames.ORIGIN, object);
        }
        if (!this.headers.contains((CharSequence)HttpHeaderNames.HOST)) {
            this.headers.set((CharSequence)HttpHeaderNames.HOST, (Object)(this.virtualHost != null ? this.virtualHost : HttpUtils.hostHeader(this.uri)));
        }
        object = null;
        if (this.bodyBuilder != null && (string2 = ((RequestBody)(object = this.bodyBuilder.build(string = this.headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE), charset = HttpUtils.extractContentTypeCharsetAttribute(string), this.defaultCharset))).getContentType()) != null) {
            this.headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)string2);
        }
        return new Request(this.method, this.uri, this.headers, (List<Cookie>)(this.cookies != null ? this.cookies : Collections.emptyList()), (RequestBody<?>)object, this.requestTimeout, this.virtualHost, this.localIpV4Address, this.localIpV6Address, this.realm, this.proxyServer, this.signatureCalculator, this.nameResolver, this.http2Enabled, this.alpnRequired, this.http2PriorKnowledge, this.wsSubprotocol);
    }
}

