/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.file;

import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.body.file.FileRequestBodyBuilder;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.stream.ChunkedFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public final class FileRequestBody
extends RequestBody<File> {
    private final Charset charset;

    public FileRequestBody(File file, String string, Charset charset) {
        super(file, string);
        this.charset = charset;
    }

    @Override
    public WritableContent build(ByteBufAllocator byteBufAllocator) throws IOException {
        long l = ((File)this.content).length();
        ChunkedFile chunkedFile = new ChunkedFile((File)this.content);
        return new WritableContent(chunkedFile, l);
    }

    @Override
    public RequestBodyBuilder<File> newBuilder() {
        return new FileRequestBodyBuilder((File)this.content);
    }

    @Override
    public byte[] getBytes() {
        byte[] byArray = new byte[(int)((File)this.content).length()];
        try (FileInputStream fileInputStream = new FileInputStream((File)this.content);){
            ((InputStream)fileInputStream).read(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Can't read file", iOException);
        }
        return byArray;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String toString() {
        return "FileRequestBody{contentType='" + this.contentType + '\'' + ", charset=" + this.charset + ", content=" + this.content + '}';
    }
}

