/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.HttpClientConfig;
import io.gatling.http.client.impl.HttpTx;
import io.gatling.http.client.impl.request.WritableRequest;
import io.gatling.http.client.impl.request.WritableRequestBuilder;
import io.gatling.http.client.realm.DigestRealm;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

class DigestAuthHandler
extends ChannelInboundHandlerAdapter {
    private final HttpTx tx;
    private final DigestRealm realm;
    private final HttpClientConfig config;
    private String digestHeader;

    DigestAuthHandler(HttpTx httpTx, DigestRealm digestRealm, HttpClientConfig httpClientConfig) {
        this.tx = httpTx;
        this.realm = digestRealm;
        this.config = httpClientConfig;
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (this.digestHeader == null) {
            String string;
            HttpResponse httpResponse;
            if (object instanceof HttpResponse && (httpResponse = (HttpResponse)object).status() == HttpResponseStatus.UNAUTHORIZED && (string = DigestAuthHandler.getHeaderWithPrefix(httpResponse.headers().getAll((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE), "Digest")) != null) {
                this.digestHeader = this.realm.computeAuthorizationHeader(this.tx.request.getMethod(), this.tx.request.getUri(), string);
                ReferenceCountUtil.release((Object)object);
                return;
            }
            channelHandlerContext.fireChannelRead(object);
        } else if (object instanceof LastHttpContent) {
            ReferenceCountUtil.release((Object)object);
            WritableRequest writableRequest = WritableRequestBuilder.buildRequest(this.tx.request, channelHandlerContext.alloc(), this.config, false);
            writableRequest.getRequest().headers().add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)this.digestHeader);
            writableRequest.write(channelHandlerContext);
            channelHandlerContext.pipeline().remove((ChannelHandler)this);
        } else {
            ReferenceCountUtil.release((Object)object);
        }
    }

    private static String getHeaderWithPrefix(List<String> list, String string) {
        if (list != null) {
            for (String string2 : list) {
                if (!string2.regionMatches(true, 0, string, 0, string.length())) continue;
                return string2;
            }
        }
        return null;
    }
}

