/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.multipart.impl;

import io.gatling.http.client.Param;
import io.gatling.http.client.body.multipart.Part;
import io.gatling.http.client.body.multipart.impl.PartImplState;
import io.gatling.http.client.body.multipart.impl.PartVisitor;
import io.gatling.http.client.util.MiscUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public abstract class PartImpl
implements Closeable {
    static final byte QUOTE_BYTE = 34;
    static final byte[] CRLF_BYTES = "\r\n".getBytes(StandardCharsets.US_ASCII);
    static final byte[] EXTRA_BYTES = "--".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CONTENT_DISPOSITION_BYTES = "Content-Disposition: ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] FORM_DATA_DISPOSITION_TYPE_BYTES = "form-data".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] NAME_BYTES = "; name=".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CONTENT_TYPE_BYTES = "Content-Type: ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CHARSET_BYTES = "; charset=".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CONTENT_TRANSFER_ENCODING_BYTES = "Content-Transfer-Encoding: ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] HEADER_NAME_VALUE_SEPARATOR_BYTES = ": ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CONTENT_ID_BYTES = "Content-ID: ".getBytes(StandardCharsets.US_ASCII);
    protected final Part<?> part;
    protected final byte[] boundary;
    private final int preContentLength;
    private final int postContentLength;
    protected PartImplState state;
    private ByteBuf preContentBuffer;
    private ByteBuf postContentBuffer;

    PartImpl(Part<?> part, byte[] byArray) {
        this.part = part;
        this.boundary = byArray;
        this.preContentLength = this.computePreContentLength();
        this.postContentLength = this.computePostContentLength();
        this.state = PartImplState.PRE_CONTENT;
    }

    public long length() {
        return (long)(this.preContentLength + this.postContentLength) + this.getContentLength();
    }

    public PartImplState getState() {
        return this.state;
    }

    public void copyInto(ByteBuf byteBuf) throws IOException {
        switch (this.state) {
            case DONE: {
                return;
            }
            case PRE_CONTENT: {
                this.copyInto(this.lazyLoadPreContentBuffer(), byteBuf, PartImplState.CONTENT);
                return;
            }
            case CONTENT: {
                this.copyContentInto(byteBuf);
                return;
            }
            case POST_CONTENT: {
                this.copyInto(this.lazyLoadPostContentBuffer(), byteBuf, PartImplState.DONE);
                return;
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
    }

    private ByteBuf lazyLoadPreContentBuffer() {
        if (this.preContentBuffer == null) {
            this.preContentBuffer = this.computePreContentBytes(this.preContentLength);
        }
        return this.preContentBuffer;
    }

    private ByteBuf lazyLoadPostContentBuffer() {
        if (this.postContentBuffer == null) {
            this.postContentBuffer = this.computePostContentBytes(this.postContentLength);
        }
        return this.postContentBuffer;
    }

    @Override
    public void close() {
        if (this.preContentBuffer != null) {
            this.preContentBuffer.release();
        }
        if (this.postContentBuffer != null) {
            this.postContentBuffer.release();
        }
    }

    protected abstract long getContentLength();

    protected abstract void copyContentInto(ByteBuf var1) throws IOException;

    void copyInto(ByteBuf byteBuf, ByteBuf byteBuf2, PartImplState partImplState) {
        int n;
        int n2 = byteBuf.readableBytes();
        if (n2 <= (n = byteBuf2.writableBytes())) {
            byteBuf2.writeBytes(byteBuf);
            this.state = partImplState;
        } else {
            byteBuf2.writeBytes(byteBuf, n);
        }
    }

    protected int computePreContentLength() {
        PartVisitor.CounterPartVisitor counterPartVisitor = new PartVisitor.CounterPartVisitor();
        this.visitPreContent(counterPartVisitor);
        return counterPartVisitor.getCount();
    }

    protected ByteBuf computePreContentBytes(int n) {
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer(n);
        PartVisitor.ByteBufVisitor byteBufVisitor = new PartVisitor.ByteBufVisitor(byteBuf);
        this.visitPreContent(byteBufVisitor);
        return byteBuf;
    }

    protected int computePostContentLength() {
        PartVisitor.CounterPartVisitor counterPartVisitor = new PartVisitor.CounterPartVisitor();
        this.visitPostContent(counterPartVisitor);
        return counterPartVisitor.getCount();
    }

    protected ByteBuf computePostContentBytes(int n) {
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer(n);
        PartVisitor.ByteBufVisitor byteBufVisitor = new PartVisitor.ByteBufVisitor(byteBuf);
        this.visitPostContent(byteBufVisitor);
        return byteBuf;
    }

    private void visitStart(PartVisitor partVisitor) {
        partVisitor.withBytes(EXTRA_BYTES);
        partVisitor.withBytes(this.boundary);
    }

    protected void visitContentDispositionHeader(PartVisitor partVisitor) {
        partVisitor.withBytes(CRLF_BYTES);
        partVisitor.withBytes(CONTENT_DISPOSITION_BYTES);
        partVisitor.withBytes(this.part.getDispositionType() != null ? this.part.getDispositionType().getBytes(StandardCharsets.US_ASCII) : FORM_DATA_DISPOSITION_TYPE_BYTES);
        if (this.part.getName() != null) {
            partVisitor.withBytes(NAME_BYTES);
            partVisitor.withByte((byte)34);
            partVisitor.withBytes(this.part.getName().getBytes(StandardCharsets.US_ASCII));
            partVisitor.withByte((byte)34);
        }
    }

    private void visitContentTypeHeader(PartVisitor partVisitor) {
        String string = this.part.getContentType();
        if (string != null) {
            partVisitor.withBytes(CRLF_BYTES);
            partVisitor.withBytes(CONTENT_TYPE_BYTES);
            partVisitor.withBytes(string.getBytes(StandardCharsets.US_ASCII));
            Charset charset = this.part.getCharset();
            if (charset != null) {
                partVisitor.withBytes(CHARSET_BYTES);
                partVisitor.withBytes(this.part.getCharset().name().getBytes(StandardCharsets.US_ASCII));
            }
        }
    }

    private void visitTransferEncodingHeader(PartVisitor partVisitor) {
        String string = this.part.getTransferEncoding();
        if (string != null) {
            partVisitor.withBytes(CRLF_BYTES);
            partVisitor.withBytes(CONTENT_TRANSFER_ENCODING_BYTES);
            partVisitor.withBytes(string.getBytes(StandardCharsets.US_ASCII));
        }
    }

    private void visitContentIdHeader(PartVisitor partVisitor) {
        String string = this.part.getContentId();
        if (string != null) {
            partVisitor.withBytes(CRLF_BYTES);
            partVisitor.withBytes(CONTENT_ID_BYTES);
            partVisitor.withBytes(string.getBytes(StandardCharsets.US_ASCII));
        }
    }

    private void visitCustomHeaders(PartVisitor partVisitor) {
        if (MiscUtils.isNonEmpty(this.part.getCustomHeaders())) {
            List<Param> list = this.part.getCustomHeaders();
            for (Param param : list) {
                partVisitor.withBytes(CRLF_BYTES);
                partVisitor.withBytes(param.getName().getBytes(StandardCharsets.US_ASCII));
                partVisitor.withBytes(HEADER_NAME_VALUE_SEPARATOR_BYTES);
                partVisitor.withBytes(param.getValue().getBytes(StandardCharsets.US_ASCII));
            }
        }
    }

    private void visitEndOfHeaders(PartVisitor partVisitor) {
        partVisitor.withBytes(CRLF_BYTES);
        partVisitor.withBytes(CRLF_BYTES);
    }

    private void visitPreContent(PartVisitor partVisitor) {
        this.visitStart(partVisitor);
        this.visitContentDispositionHeader(partVisitor);
        this.visitContentTypeHeader(partVisitor);
        this.visitTransferEncodingHeader(partVisitor);
        this.visitContentIdHeader(partVisitor);
        this.visitCustomHeaders(partVisitor);
        this.visitEndOfHeaders(partVisitor);
    }

    private void visitPostContent(PartVisitor partVisitor) {
        partVisitor.withBytes(CRLF_BYTES);
    }
}

