/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.oauth;

import io.gatling.http.client.Param;
import io.gatling.http.client.oauth.ConsumerKey;
import io.gatling.http.client.oauth.Params;
import io.gatling.http.client.oauth.RequestToken;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.MiscUtils;
import io.gatling.http.client.util.StringUtils;
import io.gatling.http.client.util.Utf8UrlEncoder;
import io.gatling.jdk.util.StringBuilderPool;
import io.netty.handler.codec.http.HttpMethod;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OAuthSignatureCalculatorInstance {
    private static final Pattern STAR_CHAR_PATTERN = Pattern.compile("*", 16);
    private static final Pattern PLUS_CHAR_PATTERN = Pattern.compile("+", 16);
    private static final Pattern ENCODED_TILDE_PATTERN = Pattern.compile("%7E", 16);
    private static final String KEY_OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    private static final String KEY_OAUTH_NONCE = "oauth_nonce";
    private static final String KEY_OAUTH_SIGNATURE = "oauth_signature";
    private static final String KEY_OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    private static final String KEY_OAUTH_TIMESTAMP = "oauth_timestamp";
    private static final String KEY_OAUTH_TOKEN = "oauth_token";
    private static final String KEY_OAUTH_VERSION = "oauth_version";
    private static final String OAUTH_VERSION_1_0 = "1.0";
    private static final String OAUTH_SIGNATURE_METHOD = "HMAC-SHA1";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private final Mac mac;
    private final byte[] nonceBuffer = new byte[16];
    private final Params params = new Params();

    public OAuthSignatureCalculatorInstance() throws NoSuchAlgorithmException {
        this.mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
    }

    public String computeAuthorizationHeader(ConsumerKey consumerKey, RequestToken requestToken, HttpMethod httpMethod, Uri uri, List<Param> list) throws InvalidKeyException {
        String string = this.generateNonce();
        long l = OAuthSignatureCalculatorInstance.generateTimestamp();
        return this.computeAuthorizationHeader(consumerKey, requestToken, httpMethod, uri, list, l, string);
    }

    private String generateNonce() {
        ThreadLocalRandom.current().nextBytes(this.nonceBuffer);
        return Base64.getEncoder().encodeToString(this.nonceBuffer);
    }

    private static long generateTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    String computeAuthorizationHeader(ConsumerKey consumerKey, RequestToken requestToken, HttpMethod httpMethod, Uri uri, List<Param> list, long l, String string) throws InvalidKeyException {
        String string2 = Utf8UrlEncoder.percentEncodeQueryElement(string);
        String string3 = this.computeSignature(consumerKey, requestToken, httpMethod, uri, list, l, string2);
        return this.computeAuthorizationHeader(consumerKey, requestToken, string3, l, string2);
    }

    String computeSignature(ConsumerKey consumerKey, RequestToken requestToken, HttpMethod httpMethod, Uri uri, List<Param> list, long l, String string) throws InvalidKeyException {
        StringBuilder stringBuilder = this.signatureBaseString(consumerKey, requestToken, httpMethod, uri, list, l, string);
        ByteBuffer byteBuffer = StringUtils.charSequence2ByteBuffer(stringBuilder, StandardCharsets.UTF_8);
        byte[] byArray = this.digest(consumerKey, requestToken, byteBuffer);
        return Base64.getEncoder().encodeToString(byArray);
    }

    StringBuilder signatureBaseString(ConsumerKey consumerKey, RequestToken requestToken, HttpMethod httpMethod, Uri uri, List<Param> list, long l, String string) {
        String string2 = uri.toUrlWithoutQuery();
        String string3 = this.encodedParams(consumerKey, requestToken, l, string, uri.getEncodedQueryParams(), list);
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
        stringBuilder.append(httpMethod.name());
        stringBuilder.append('&');
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(stringBuilder, string2);
        stringBuilder.append('&');
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(stringBuilder, string3);
        return stringBuilder;
    }

    private String encodedParams(ConsumerKey consumerKey, RequestToken requestToken, long l, String string, List<Param> list, List<Param> list2) {
        this.params.reset();
        this.params.add(KEY_OAUTH_CONSUMER_KEY, consumerKey.percentEncodedKey).add(KEY_OAUTH_NONCE, string).add(KEY_OAUTH_SIGNATURE_METHOD, OAUTH_SIGNATURE_METHOD).add(KEY_OAUTH_TIMESTAMP, String.valueOf(l));
        if (requestToken.key != null) {
            this.params.add(KEY_OAUTH_TOKEN, requestToken.percentEncodedKey);
        }
        this.params.add(KEY_OAUTH_VERSION, OAUTH_VERSION_1_0);
        if (list2 != null) {
            for (Param param : list2) {
                this.params.add(Utf8UrlEncoder.percentEncodeQueryElement(param.getName()), Utf8UrlEncoder.percentEncodeQueryElement(param.getValue()));
            }
        }
        if (MiscUtils.isNonEmpty(list)) {
            for (Param param : list) {
                this.params.add(this.percentEncodeAlreadyFormUrlEncoded(param.getName()), this.percentEncodeAlreadyFormUrlEncoded(param.getValue()));
            }
        }
        return this.params.sortAndConcat();
    }

    private String percentEncodeAlreadyFormUrlEncoded(String string) {
        string = STAR_CHAR_PATTERN.matcher(string).replaceAll("%2A");
        string = PLUS_CHAR_PATTERN.matcher(string).replaceAll("%20");
        string = ENCODED_TILDE_PATTERN.matcher(string).replaceAll("~");
        return string;
    }

    private byte[] digest(ConsumerKey consumerKey, RequestToken requestToken, ByteBuffer byteBuffer) throws InvalidKeyException {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
        Utf8UrlEncoder.encodeAndAppendQueryElement(stringBuilder, consumerKey.secret);
        stringBuilder.append('&');
        if (requestToken != null && requestToken.secret != null) {
            Utf8UrlEncoder.encodeAndAppendQueryElement(stringBuilder, requestToken.secret);
        }
        byte[] byArray = StringUtils.charSequence2Bytes(stringBuilder, StandardCharsets.UTF_8);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, HMAC_SHA1_ALGORITHM);
        this.mac.init(secretKeySpec);
        this.mac.update(byteBuffer);
        return this.mac.doFinal();
    }

    String computeAuthorizationHeader(ConsumerKey consumerKey, RequestToken requestToken, String string, long l, String string2) {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
        stringBuilder.append("OAuth ");
        stringBuilder.append(KEY_OAUTH_CONSUMER_KEY).append("=\"").append(consumerKey.percentEncodedKey).append("\", ");
        if (requestToken.key != null) {
            stringBuilder.append(KEY_OAUTH_TOKEN).append("=\"").append(requestToken.percentEncodedKey).append("\", ");
        }
        stringBuilder.append(KEY_OAUTH_SIGNATURE_METHOD).append("=\"").append(OAUTH_SIGNATURE_METHOD).append("\", ");
        stringBuilder.append(KEY_OAUTH_SIGNATURE).append("=\"");
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(stringBuilder, string).append("\", ");
        stringBuilder.append(KEY_OAUTH_TIMESTAMP).append("=\"").append(l).append("\", ");
        stringBuilder.append(KEY_OAUTH_NONCE).append("=\"").append(string2).append("\", ");
        stringBuilder.append(KEY_OAUTH_VERSION).append("=\"").append(OAUTH_VERSION_1_0).append("\"");
        return stringBuilder.toString();
    }
}

