/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.http;

import io.gatling.core.filter.AllowList;
import io.gatling.core.filter.DenyList;
import io.gatling.core.protocol.Protocol;
import io.gatling.http.client.SignatureCalculator;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.response.Response;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Filter;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.http.Proxy;
import io.gatling.javaapi.http.internal.HttpChecks;
import io.gatling.javaapi.http.internal.ScalaHttpProtocolBuilderConditions;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.net.ssl.KeyManagerFactory;
import scala.PartialFunction;

public final class HttpProtocolBuilder
implements ProtocolBuilder {
    private final io.gatling.http.protocol.HttpProtocolBuilder wrapped;

    public HttpProtocolBuilder(io.gatling.http.protocol.HttpProtocolBuilder httpProtocolBuilder) {
        this.wrapped = httpProtocolBuilder;
    }

    public Protocol protocol() {
        return this.wrapped.protocol();
    }

    @Nonnull
    public HttpProtocolBuilder baseUrl(@Nonnull String string) {
        return this.baseUrls(string);
    }

    @Nonnull
    public HttpProtocolBuilder baseUrls(String ... stringArray) {
        return this.baseUrls(Arrays.asList(stringArray));
    }

    @Nonnull
    public HttpProtocolBuilder baseUrls(@Nonnull List<String> list) {
        return new HttpProtocolBuilder(this.wrapped.baseUrls(Converters.toScalaSeq(list)));
    }

    @Nonnull
    public HttpProtocolBuilder warmUp(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.warmUp(string));
    }

    @Nonnull
    public HttpProtocolBuilder disableWarmUp() {
        return new HttpProtocolBuilder(this.wrapped.disableWarmUp());
    }

    @Nonnull
    public HttpProtocolBuilder shareConnections() {
        return new HttpProtocolBuilder(this.wrapped.shareConnections());
    }

    @Nonnull
    public HttpProtocolBuilder virtualHost(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.virtualHost(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder virtualHost(@Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.virtualHost(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder localAddress(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.localAddress(string));
    }

    @Nonnull
    public HttpProtocolBuilder localAddresses(String ... stringArray) {
        return new HttpProtocolBuilder(this.wrapped.localAddresses(Converters.toScalaSeq((Object)stringArray)));
    }

    @Nonnull
    public HttpProtocolBuilder localAddresses(@Nonnull List<String> list) {
        return new HttpProtocolBuilder(this.wrapped.localAddresses(Converters.toScalaSeq(list)));
    }

    @Nonnull
    public HttpProtocolBuilder useAllLocalAddresses() {
        return new HttpProtocolBuilder(this.wrapped.useAllLocalAddresses());
    }

    @Nonnull
    public HttpProtocolBuilder useAllLocalAddressesMatching(String ... stringArray) {
        return new HttpProtocolBuilder(this.wrapped.useAllLocalAddressesMatching(Converters.toScalaSeq((Object)stringArray)));
    }

    @Nonnull
    public HttpProtocolBuilder maxConnectionsPerHost(int n) {
        return new HttpProtocolBuilder(this.wrapped.maxConnectionsPerHost(n));
    }

    @Nonnull
    public HttpProtocolBuilder perUserKeyManagerFactory(@Nonnull Function<Long, KeyManagerFactory> function) {
        return new HttpProtocolBuilder(this.wrapped.perUserKeyManagerFactory(object -> (KeyManagerFactory)function.apply((Long)object)));
    }

    @Nonnull
    public HttpProtocolBuilder disableAutoReferer() {
        return new HttpProtocolBuilder(this.wrapped.disableAutoReferer());
    }

    @Nonnull
    public HttpProtocolBuilder disableAutoOrigin() {
        return new HttpProtocolBuilder(this.wrapped.disableAutoOrigin());
    }

    @Nonnull
    public HttpProtocolBuilder disableCaching() {
        return new HttpProtocolBuilder(this.wrapped.disableCaching());
    }

    @Nonnull
    public HttpProtocolBuilder header(@Nonnull CharSequence charSequence, @Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.header(charSequence, Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder header(@Nonnull CharSequence charSequence, @Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.header(charSequence, Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder headers(Map<? extends CharSequence, String> map) {
        return new HttpProtocolBuilder(this.wrapped.headers(Converters.toScalaMap(map)));
    }

    @Nonnull
    public HttpProtocolBuilder acceptHeader(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.acceptHeader(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder acceptHeader(@Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.acceptHeader(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder acceptCharsetHeader(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.acceptCharsetHeader(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder acceptCharsetHeader(@Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.acceptCharsetHeader(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder acceptEncodingHeader(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.acceptEncodingHeader(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder acceptEncodingHeader(@Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.acceptEncodingHeader(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder acceptLanguageHeader(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.acceptLanguageHeader(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder acceptLanguageHeader(@Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.acceptLanguageHeader(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder authorizationHeader(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.authorizationHeader(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder authorizationHeader(@Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.authorizationHeader(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder connectionHeader(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.connectionHeader(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder connectionHeader(@Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.connectionHeader(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder contentTypeHeader(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.contentTypeHeader(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder contentTypeHeader(@Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.contentTypeHeader(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder doNotTrackHeader(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.doNotTrackHeader(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder doNotTrackHeader(@Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.doNotTrackHeader(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder originHeader(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.originHeader(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder originHeader(@Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.originHeader(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder userAgentHeader(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.userAgentHeader(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder userAgentHeader(@Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.userAgentHeader(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder upgradeInsecureRequestsHeader(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.upgradeInsecureRequestsHeader(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder upgradeInsecureRequestsHeader(@Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.upgradeInsecureRequestsHeader(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder basicAuth(@Nonnull String string, @Nonnull String string2) {
        return new HttpProtocolBuilder(this.wrapped.basicAuth(Expressions.toStringExpression((String)string), Expressions.toStringExpression((String)string2)));
    }

    @Nonnull
    public HttpProtocolBuilder basicAuth(@Nonnull String string, @Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.basicAuth(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder basicAuth(@Nonnull Function<Session, String> function, @Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.basicAuth(Expressions.javaFunctionToExpression(function), Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder basicAuth(@Nonnull Function<Session, String> function, @Nonnull Function<Session, String> function2) {
        return new HttpProtocolBuilder(this.wrapped.basicAuth(Expressions.javaFunctionToExpression(function), Expressions.javaFunctionToExpression(function2)));
    }

    @Nonnull
    public HttpProtocolBuilder digestAuth(@Nonnull String string, @Nonnull String string2) {
        return new HttpProtocolBuilder(this.wrapped.digestAuth(Expressions.toStringExpression((String)string), Expressions.toStringExpression((String)string2)));
    }

    @Nonnull
    public HttpProtocolBuilder digestAuth(@Nonnull String string, @Nonnull Function<Session, String> function) {
        return new HttpProtocolBuilder(this.wrapped.digestAuth(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder digestAuth(@Nonnull Function<Session, String> function, @Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.digestAuth(Expressions.javaFunctionToExpression(function), Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public HttpProtocolBuilder digestAuth(@Nonnull Function<Session, String> function, @Nonnull Function<Session, String> function2) {
        return new HttpProtocolBuilder(this.wrapped.digestAuth(Expressions.javaFunctionToExpression(function), Expressions.javaFunctionToExpression(function2)));
    }

    @Nonnull
    public HttpProtocolBuilder silentResources() {
        return new HttpProtocolBuilder(this.wrapped.silentResources());
    }

    @Nonnull
    public HttpProtocolBuilder silentUri(@Nonnull String string) {
        return new HttpProtocolBuilder(this.wrapped.silentUri(string));
    }

    @Nonnull
    public HttpProtocolBuilder disableUrlEncoding() {
        return new HttpProtocolBuilder(this.wrapped.disableUrlEncoding());
    }

    @Nonnull
    public HttpProtocolBuilder sign(@Nonnull SignatureCalculator signatureCalculator) {
        return new HttpProtocolBuilder(this.wrapped.sign(Expressions.toStaticValueExpression((Object)signatureCalculator)));
    }

    @Nonnull
    public HttpProtocolBuilder sign(@Nonnull Function<Session, SignatureCalculator> function) {
        return new HttpProtocolBuilder(this.wrapped.sign(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public HttpProtocolBuilder signWithOAuth1(@Nonnull String string, @Nonnull String string2, @Nonnull String string3, @Nonnull String string4) {
        return new HttpProtocolBuilder(this.wrapped.signWithOAuth1(Expressions.toStringExpression((String)string), Expressions.toStringExpression((String)string2), Expressions.toStringExpression((String)string3), Expressions.toStringExpression((String)string4)));
    }

    @Nonnull
    public HttpProtocolBuilder signWithOAuth1(@Nonnull Function<Session, String> function, @Nonnull Function<Session, String> function2, @Nonnull Function<Session, String> function3, @Nonnull Function<Session, String> function4) {
        return new HttpProtocolBuilder(this.wrapped.signWithOAuth1(Expressions.javaFunctionToExpression(function), Expressions.javaFunctionToExpression(function2), Expressions.javaFunctionToExpression(function3), Expressions.javaFunctionToExpression(function4)));
    }

    public HttpProtocolBuilder enableHttp2() {
        return new HttpProtocolBuilder(this.wrapped.enableHttp2());
    }

    public HttpProtocolBuilder http2PriorKnowledge(Map<String, Boolean> map) {
        return new HttpProtocolBuilder(this.wrapped.http2PriorKnowledge(Converters.toScalaMap(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))));
    }

    public HttpProtocolBuilder disableFollowRedirect() {
        return new HttpProtocolBuilder(this.wrapped.disableFollowRedirect());
    }

    public HttpProtocolBuilder maxRedirects(int n) {
        return new HttpProtocolBuilder(this.wrapped.maxRedirects(n));
    }

    public HttpProtocolBuilder strict302Handling() {
        return new HttpProtocolBuilder(this.wrapped.strict302Handling());
    }

    public HttpProtocolBuilder redirectNamingStrategy(RedirectNamingStrategy redirectNamingStrategy) {
        return new HttpProtocolBuilder(this.wrapped.redirectNamingStrategy((uri, string, object) -> redirectNamingStrategy.apply((Uri)uri, (String)string, (Integer)object)));
    }

    public HttpProtocolBuilder transformResponse(BiFunction<Response, Session, Response> biFunction) {
        return new HttpProtocolBuilder(this.wrapped.transformResponse(Expressions.javaBiFunctionToExpression(biFunction)));
    }

    public HttpProtocolBuilder check(CheckBuilder ... checkBuilderArray) {
        return this.check(Arrays.asList(checkBuilderArray));
    }

    public HttpProtocolBuilder check(List<CheckBuilder> list) {
        return new HttpProtocolBuilder(this.wrapped.check(HttpChecks.toScalaChecks(list)));
    }

    public UntypedCondition checkIf(Function<Session, Boolean> function) {
        return new UntypedCondition(ScalaHttpProtocolBuilderConditions.untyped(this.wrapped, function));
    }

    public UntypedCondition checkIf(String string) {
        return new UntypedCondition(ScalaHttpProtocolBuilderConditions.untyped(this.wrapped, string));
    }

    public TypedCondition checkIf(BiFunction<Response, Session, Boolean> biFunction) {
        return new TypedCondition(ScalaHttpProtocolBuilderConditions.typed(this.wrapped, biFunction));
    }

    public HttpProtocolBuilder inferHtmlResources() {
        return new HttpProtocolBuilder(this.wrapped.inferHtmlResources());
    }

    public HttpProtocolBuilder inferHtmlResources(Filter.AllowList allowList) {
        return new HttpProtocolBuilder(this.wrapped.inferHtmlResources((AllowList)allowList.asScala()));
    }

    public HttpProtocolBuilder inferHtmlResources(Filter.AllowList allowList, Filter.DenyList denyList) {
        return new HttpProtocolBuilder(this.wrapped.inferHtmlResources((AllowList)allowList.asScala(), (DenyList)denyList.asScala()));
    }

    public HttpProtocolBuilder inferHtmlResources(Filter.DenyList denyList) {
        return new HttpProtocolBuilder(this.wrapped.inferHtmlResources((DenyList)denyList.asScala()));
    }

    public HttpProtocolBuilder inferHtmlResources(Filter.DenyList denyList, Filter.AllowList allowList) {
        return new HttpProtocolBuilder(this.wrapped.inferHtmlResources((DenyList)denyList.asScala(), (AllowList)allowList.asScala()));
    }

    public HttpProtocolBuilder nameInferredHtmlResourcesAfterUrlTail() {
        return new HttpProtocolBuilder(this.wrapped.nameInferredHtmlResourcesAfterUrlTail());
    }

    public HttpProtocolBuilder nameInferredHtmlResourcesAfterAbsoluteUrl() {
        return new HttpProtocolBuilder(this.wrapped.nameInferredHtmlResourcesAfterAbsoluteUrl());
    }

    public HttpProtocolBuilder nameInferredHtmlResourcesAfterRelativeUrl() {
        return new HttpProtocolBuilder(this.wrapped.nameInferredHtmlResourcesAfterRelativeUrl());
    }

    public HttpProtocolBuilder nameInferredHtmlResourcesAfterPath() {
        return new HttpProtocolBuilder(this.wrapped.nameInferredHtmlResourcesAfterPath());
    }

    public HttpProtocolBuilder nameInferredHtmlResourcesAfterLastPathElement() {
        return new HttpProtocolBuilder(this.wrapped.nameInferredHtmlResourcesAfterLastPathElement());
    }

    public HttpProtocolBuilder nameInferredHtmlResources(Function<Uri, String> function) {
        return new HttpProtocolBuilder(this.wrapped.nameInferredHtmlResources(function::apply));
    }

    public HttpProtocolBuilder wsBaseUrl(String string) {
        return new HttpProtocolBuilder(this.wrapped.wsBaseUrl(string));
    }

    public HttpProtocolBuilder wsBaseUrls(String ... stringArray) {
        return new HttpProtocolBuilder(this.wrapped.wsBaseUrls(Converters.toScalaSeq((Object)stringArray)));
    }

    public HttpProtocolBuilder wsBaseUrls(List<String> list) {
        return new HttpProtocolBuilder(this.wrapped.wsBaseUrls(Converters.toScalaSeq(list)));
    }

    public HttpProtocolBuilder wsReconnect() {
        return new HttpProtocolBuilder(this.wrapped.wsReconnect());
    }

    public HttpProtocolBuilder wsMaxReconnects(int n) {
        return new HttpProtocolBuilder(this.wrapped.wsMaxReconnects(n));
    }

    public HttpProtocolBuilder wsAutoReplyTextFrame(final Function<String, String> function) {
        return new HttpProtocolBuilder(this.wrapped.wsAutoReplyTextFrame((PartialFunction)new PartialFunction<String, String>(){

            public boolean isDefinedAt(String string) {
                return function.apply(string) != null;
            }

            public String apply(String string) {
                return (String)function.apply(string);
            }
        }));
    }

    public HttpProtocolBuilder wsAutoReplySocketIo4() {
        return new HttpProtocolBuilder(this.wrapped.wsAutoReplySocketIo4());
    }

    public HttpProtocolBuilder noProxyFor(String ... stringArray) {
        return new HttpProtocolBuilder(this.wrapped.noProxyFor(Converters.toScalaSeq((Object)stringArray)));
    }

    public HttpProtocolBuilder proxy(Proxy proxy) {
        return new HttpProtocolBuilder(this.wrapped.proxy(proxy.asScala()));
    }

    public HttpProtocolBuilder asyncNameResolution(String ... stringArray) {
        return new HttpProtocolBuilder(this.wrapped.asyncNameResolution(Converters.toScalaSeq((Object)stringArray)));
    }

    public HttpProtocolBuilder asyncNameResolution(InetSocketAddress[] inetSocketAddressArray) {
        return new HttpProtocolBuilder(this.wrapped.asyncNameResolution(inetSocketAddressArray));
    }

    public HttpProtocolBuilder perUserNameResolution() {
        return new HttpProtocolBuilder(this.wrapped.perUserNameResolution());
    }

    public static final class TypedCondition {
        private final ScalaHttpProtocolBuilderConditions.Typed wrapped;

        public TypedCondition(ScalaHttpProtocolBuilderConditions.Typed typed) {
            this.wrapped = typed;
        }

        public HttpProtocolBuilder then(CheckBuilder ... checkBuilderArray) {
            return this.then(Arrays.asList(checkBuilderArray));
        }

        public HttpProtocolBuilder then(List<CheckBuilder> list) {
            return this.wrapped.then_(list);
        }
    }

    public static final class UntypedCondition {
        private final ScalaHttpProtocolBuilderConditions.Untyped wrapped;

        public UntypedCondition(ScalaHttpProtocolBuilderConditions.Untyped untyped) {
            this.wrapped = untyped;
        }

        public HttpProtocolBuilder then(CheckBuilder ... checkBuilderArray) {
            return this.then(Arrays.asList(checkBuilderArray));
        }

        public HttpProtocolBuilder then(List<CheckBuilder> list) {
            return this.wrapped.then_(list);
        }
    }

    @FunctionalInterface
    public static interface RedirectNamingStrategy {
        public String apply(Uri var1, String var2, int var3);
    }
}

